/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;

import org.agrona.MutableDirectBuffer;


/**
 * Recording termination notification.
 */
@SuppressWarnings("all")
public final class RecordingStoppedEncoder
{
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 103;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 8;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final RecordingStoppedEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public RecordingStoppedEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public RecordingStoppedEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int recordingIdId()
    {
        return 1;
    }

    public static int recordingIdSinceVersion()
    {
        return 0;
    }

    public static int recordingIdEncodingOffset()
    {
        return 0;
    }

    public static int recordingIdEncodingLength()
    {
        return 8;
    }

    public static String recordingIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long recordingIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long recordingIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long recordingIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public RecordingStoppedEncoder recordingId(final long value)
    {
        buffer.putLong(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int startPositionId()
    {
        return 2;
    }

    public static int startPositionSinceVersion()
    {
        return 0;
    }

    public static int startPositionEncodingOffset()
    {
        return 8;
    }

    public static int startPositionEncodingLength()
    {
        return 8;
    }

    public static String startPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long startPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long startPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long startPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public RecordingStoppedEncoder startPosition(final long value)
    {
        buffer.putLong(offset + 8, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int stopPositionId()
    {
        return 3;
    }

    public static int stopPositionSinceVersion()
    {
        return 0;
    }

    public static int stopPositionEncodingOffset()
    {
        return 16;
    }

    public static int stopPositionEncodingLength()
    {
        return 8;
    }

    public static String stopPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long stopPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long stopPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long stopPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public RecordingStoppedEncoder stopPosition(final long value)
    {
        buffer.putLong(offset + 16, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final RecordingStoppedDecoder decoder = new RecordingStoppedDecoder();
        decoder.wrap(buffer, initialOffset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
