/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;


/**
 * Replicate a recording from another archive.
 */
@SuppressWarnings("all")
public final class ReplicateRequest2Encoder
{
    public static final int BLOCK_LENGTH = 68;
    public static final int TEMPLATE_ID = 66;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 8;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final ReplicateRequest2Encoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public ReplicateRequest2Encoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public ReplicateRequest2Encoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int controlSessionIdId()
    {
        return 1;
    }

    public static int controlSessionIdSinceVersion()
    {
        return 0;
    }

    public static int controlSessionIdEncodingOffset()
    {
        return 0;
    }

    public static int controlSessionIdEncodingLength()
    {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long controlSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long controlSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public ReplicateRequest2Encoder controlSessionId(final long value)
    {
        buffer.putLong(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int correlationIdId()
    {
        return 2;
    }

    public static int correlationIdSinceVersion()
    {
        return 0;
    }

    public static int correlationIdEncodingOffset()
    {
        return 8;
    }

    public static int correlationIdEncodingLength()
    {
        return 8;
    }

    public static String correlationIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long correlationIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long correlationIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public ReplicateRequest2Encoder correlationId(final long value)
    {
        buffer.putLong(offset + 8, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int srcRecordingIdId()
    {
        return 3;
    }

    public static int srcRecordingIdSinceVersion()
    {
        return 0;
    }

    public static int srcRecordingIdEncodingOffset()
    {
        return 16;
    }

    public static int srcRecordingIdEncodingLength()
    {
        return 8;
    }

    public static String srcRecordingIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long srcRecordingIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long srcRecordingIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long srcRecordingIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public ReplicateRequest2Encoder srcRecordingId(final long value)
    {
        buffer.putLong(offset + 16, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int dstRecordingIdId()
    {
        return 4;
    }

    public static int dstRecordingIdSinceVersion()
    {
        return 0;
    }

    public static int dstRecordingIdEncodingOffset()
    {
        return 24;
    }

    public static int dstRecordingIdEncodingLength()
    {
        return 8;
    }

    public static String dstRecordingIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long dstRecordingIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long dstRecordingIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long dstRecordingIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public ReplicateRequest2Encoder dstRecordingId(final long value)
    {
        buffer.putLong(offset + 24, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int stopPositionId()
    {
        return 5;
    }

    public static int stopPositionSinceVersion()
    {
        return 0;
    }

    public static int stopPositionEncodingOffset()
    {
        return 32;
    }

    public static int stopPositionEncodingLength()
    {
        return 8;
    }

    public static String stopPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long stopPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long stopPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long stopPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public ReplicateRequest2Encoder stopPosition(final long value)
    {
        buffer.putLong(offset + 32, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int channelTagIdId()
    {
        return 6;
    }

    public static int channelTagIdSinceVersion()
    {
        return 0;
    }

    public static int channelTagIdEncodingOffset()
    {
        return 40;
    }

    public static int channelTagIdEncodingLength()
    {
        return 8;
    }

    public static String channelTagIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long channelTagIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long channelTagIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long channelTagIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public ReplicateRequest2Encoder channelTagId(final long value)
    {
        buffer.putLong(offset + 40, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int subscriptionTagIdId()
    {
        return 7;
    }

    public static int subscriptionTagIdSinceVersion()
    {
        return 0;
    }

    public static int subscriptionTagIdEncodingOffset()
    {
        return 48;
    }

    public static int subscriptionTagIdEncodingLength()
    {
        return 8;
    }

    public static String subscriptionTagIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long subscriptionTagIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long subscriptionTagIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long subscriptionTagIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public ReplicateRequest2Encoder subscriptionTagId(final long value)
    {
        buffer.putLong(offset + 48, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int srcControlStreamIdId()
    {
        return 8;
    }

    public static int srcControlStreamIdSinceVersion()
    {
        return 0;
    }

    public static int srcControlStreamIdEncodingOffset()
    {
        return 56;
    }

    public static int srcControlStreamIdEncodingLength()
    {
        return 4;
    }

    public static String srcControlStreamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int srcControlStreamIdNullValue()
    {
        return -2147483648;
    }

    public static int srcControlStreamIdMinValue()
    {
        return -2147483647;
    }

    public static int srcControlStreamIdMaxValue()
    {
        return 2147483647;
    }

    public ReplicateRequest2Encoder srcControlStreamId(final int value)
    {
        buffer.putInt(offset + 56, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int fileIoMaxLengthId()
    {
        return 12;
    }

    public static int fileIoMaxLengthSinceVersion()
    {
        return 7;
    }

    public static int fileIoMaxLengthEncodingOffset()
    {
        return 60;
    }

    public static int fileIoMaxLengthEncodingLength()
    {
        return 4;
    }

    public static String fileIoMaxLengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int fileIoMaxLengthNullValue()
    {
        return -2147483648;
    }

    public static int fileIoMaxLengthMinValue()
    {
        return -2147483647;
    }

    public static int fileIoMaxLengthMaxValue()
    {
        return 2147483647;
    }

    public ReplicateRequest2Encoder fileIoMaxLength(final int value)
    {
        buffer.putInt(offset + 60, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int replicationSessionIdId()
    {
        return 13;
    }

    public static int replicationSessionIdSinceVersion()
    {
        return 8;
    }

    public static int replicationSessionIdEncodingOffset()
    {
        return 64;
    }

    public static int replicationSessionIdEncodingLength()
    {
        return 4;
    }

    public static String replicationSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int replicationSessionIdNullValue()
    {
        return -2147483648;
    }

    public static int replicationSessionIdMinValue()
    {
        return -2147483647;
    }

    public static int replicationSessionIdMaxValue()
    {
        return 2147483647;
    }

    public ReplicateRequest2Encoder replicationSessionId(final int value)
    {
        buffer.putInt(offset + 64, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int srcControlChannelId()
    {
        return 9;
    }

    public static String srcControlChannelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String srcControlChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int srcControlChannelHeaderLength()
    {
        return 4;
    }

    public ReplicateRequest2Encoder putSrcControlChannel(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public ReplicateRequest2Encoder putSrcControlChannel(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public ReplicateRequest2Encoder srcControlChannel(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public ReplicateRequest2Encoder srcControlChannel(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public static int liveDestinationId()
    {
        return 10;
    }

    public static String liveDestinationCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String liveDestinationMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int liveDestinationHeaderLength()
    {
        return 4;
    }

    public ReplicateRequest2Encoder putLiveDestination(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public ReplicateRequest2Encoder putLiveDestination(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public ReplicateRequest2Encoder liveDestination(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public ReplicateRequest2Encoder liveDestination(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public static int replicationChannelId()
    {
        return 11;
    }

    public static String replicationChannelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String replicationChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int replicationChannelHeaderLength()
    {
        return 4;
    }

    public ReplicateRequest2Encoder putReplicationChannel(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public ReplicateRequest2Encoder putReplicationChannel(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public ReplicateRequest2Encoder replicationChannel(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public ReplicateRequest2Encoder replicationChannel(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public static int encodedCredentialsId()
    {
        return 14;
    }

    public static String encodedCredentialsMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int encodedCredentialsHeaderLength()
    {
        return 4;
    }

    public ReplicateRequest2Encoder putEncodedCredentials(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public ReplicateRequest2Encoder putEncodedCredentials(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final ReplicateRequest2Decoder decoder = new ReplicateRequest2Decoder();
        decoder.wrap(buffer, initialOffset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
