/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;

import org.agrona.DirectBuffer;


/**
 * Serialised state of the service pending message tracker.
 */
@SuppressWarnings("all")
public final class PendingMessageTrackerDecoder
{
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 107;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final PendingMessageTrackerDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public PendingMessageTrackerDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public PendingMessageTrackerDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public PendingMessageTrackerDecoder sbeRewind()
    {
        return wrap(buffer, initialOffset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int actingVersion()
    {
        return actingVersion;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int nextServiceSessionIdId()
    {
        return 1;
    }

    public static int nextServiceSessionIdSinceVersion()
    {
        return 0;
    }

    public static int nextServiceSessionIdEncodingOffset()
    {
        return 0;
    }

    public static int nextServiceSessionIdEncodingLength()
    {
        return 8;
    }

    public static String nextServiceSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long nextServiceSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long nextServiceSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long nextServiceSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long nextServiceSessionId()
    {
        return buffer.getLong(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int logServiceSessionIdId()
    {
        return 2;
    }

    public static int logServiceSessionIdSinceVersion()
    {
        return 0;
    }

    public static int logServiceSessionIdEncodingOffset()
    {
        return 8;
    }

    public static int logServiceSessionIdEncodingLength()
    {
        return 8;
    }

    public static String logServiceSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logServiceSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logServiceSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logServiceSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long logServiceSessionId()
    {
        return buffer.getLong(offset + 8, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int pendingMessageCapacityId()
    {
        return 3;
    }

    public static int pendingMessageCapacitySinceVersion()
    {
        return 0;
    }

    public static int pendingMessageCapacityEncodingOffset()
    {
        return 16;
    }

    public static int pendingMessageCapacityEncodingLength()
    {
        return 4;
    }

    public static String pendingMessageCapacityMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static int pendingMessageCapacityNullValue()
    {
        return 0;
    }

    public static int pendingMessageCapacityMinValue()
    {
        return -2147483647;
    }

    public static int pendingMessageCapacityMaxValue()
    {
        return 2147483647;
    }

    public int pendingMessageCapacity()
    {
        return buffer.getInt(offset + 16, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int serviceIdId()
    {
        return 4;
    }

    public static int serviceIdSinceVersion()
    {
        return 0;
    }

    public static int serviceIdEncodingOffset()
    {
        return 20;
    }

    public static int serviceIdEncodingLength()
    {
        return 4;
    }

    public static String serviceIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int serviceIdNullValue()
    {
        return -2147483648;
    }

    public static int serviceIdMinValue()
    {
        return -2147483647;
    }

    public static int serviceIdMaxValue()
    {
        return 2147483647;
    }

    public int serviceId()
    {
        return buffer.getInt(offset + 20, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final PendingMessageTrackerDecoder decoder = new PendingMessageTrackerDecoder();
        decoder.wrap(buffer, initialOffset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(initialOffset + actingBlockLength);
        builder.append("[PendingMessageTracker](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("nextServiceSessionId=");
        builder.append(this.nextServiceSessionId());
        builder.append('|');
        builder.append("logServiceSessionId=");
        builder.append(this.logServiceSessionId());
        builder.append('|');
        builder.append("pendingMessageCapacity=");
        builder.append(this.pendingMessageCapacity());
        builder.append('|');
        builder.append("serviceId=");
        builder.append(this.serviceId());

        limit(originalLimit);

        return builder;
    }
    
    public PendingMessageTrackerDecoder sbeSkip()
    {
        sbeRewind();

        return this;
    }
}
