/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;

import org.agrona.MutableDirectBuffer;


/**
 * Serialised state of the service pending message tracker.
 */
@SuppressWarnings("all")
public final class PendingMessageTrackerEncoder
{
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 107;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final PendingMessageTrackerEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public PendingMessageTrackerEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public PendingMessageTrackerEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int nextServiceSessionIdId()
    {
        return 1;
    }

    public static int nextServiceSessionIdSinceVersion()
    {
        return 0;
    }

    public static int nextServiceSessionIdEncodingOffset()
    {
        return 0;
    }

    public static int nextServiceSessionIdEncodingLength()
    {
        return 8;
    }

    public static String nextServiceSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long nextServiceSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long nextServiceSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long nextServiceSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public PendingMessageTrackerEncoder nextServiceSessionId(final long value)
    {
        buffer.putLong(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int logServiceSessionIdId()
    {
        return 2;
    }

    public static int logServiceSessionIdSinceVersion()
    {
        return 0;
    }

    public static int logServiceSessionIdEncodingOffset()
    {
        return 8;
    }

    public static int logServiceSessionIdEncodingLength()
    {
        return 8;
    }

    public static String logServiceSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logServiceSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logServiceSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logServiceSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public PendingMessageTrackerEncoder logServiceSessionId(final long value)
    {
        buffer.putLong(offset + 8, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int pendingMessageCapacityId()
    {
        return 3;
    }

    public static int pendingMessageCapacitySinceVersion()
    {
        return 0;
    }

    public static int pendingMessageCapacityEncodingOffset()
    {
        return 16;
    }

    public static int pendingMessageCapacityEncodingLength()
    {
        return 4;
    }

    public static String pendingMessageCapacityMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static int pendingMessageCapacityNullValue()
    {
        return 0;
    }

    public static int pendingMessageCapacityMinValue()
    {
        return -2147483647;
    }

    public static int pendingMessageCapacityMaxValue()
    {
        return 2147483647;
    }

    public PendingMessageTrackerEncoder pendingMessageCapacity(final int value)
    {
        buffer.putInt(offset + 16, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int serviceIdId()
    {
        return 4;
    }

    public static int serviceIdSinceVersion()
    {
        return 0;
    }

    public static int serviceIdEncodingOffset()
    {
        return 20;
    }

    public static int serviceIdEncodingLength()
    {
        return 4;
    }

    public static String serviceIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int serviceIdNullValue()
    {
        return -2147483648;
    }

    public static int serviceIdMinValue()
    {
        return -2147483647;
    }

    public static int serviceIdMaxValue()
    {
        return 2147483647;
    }

    public PendingMessageTrackerEncoder serviceId(final int value)
    {
        buffer.putInt(offset + 20, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final PendingMessageTrackerDecoder decoder = new PendingMessageTrackerDecoder();
        decoder.wrap(buffer, initialOffset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
