/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.Publication;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.client.ReplayParams;
import io.aeron.archive.client.ReplicationParams;
import io.aeron.archive.codecs.AttachSegmentsRequestEncoder;
import io.aeron.archive.codecs.AuthConnectRequestEncoder;
import io.aeron.archive.codecs.BooleanType;
import io.aeron.archive.codecs.BoundedReplayRequestEncoder;
import io.aeron.archive.codecs.ChallengeResponseEncoder;
import io.aeron.archive.codecs.CloseSessionRequestEncoder;
import io.aeron.archive.codecs.DeleteDetachedSegmentsRequestEncoder;
import io.aeron.archive.codecs.DetachSegmentsRequestEncoder;
import io.aeron.archive.codecs.ExtendRecordingRequest2Encoder;
import io.aeron.archive.codecs.ExtendRecordingRequestEncoder;
import io.aeron.archive.codecs.FindLastMatchingRecordingRequestEncoder;
import io.aeron.archive.codecs.KeepAliveRequestEncoder;
import io.aeron.archive.codecs.ListRecordingRequestEncoder;
import io.aeron.archive.codecs.ListRecordingSubscriptionsRequestEncoder;
import io.aeron.archive.codecs.ListRecordingsForUriRequestEncoder;
import io.aeron.archive.codecs.ListRecordingsRequestEncoder;
import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.MigrateSegmentsRequestEncoder;
import io.aeron.archive.codecs.PurgeRecordingRequestEncoder;
import io.aeron.archive.codecs.PurgeSegmentsRequestEncoder;
import io.aeron.archive.codecs.RecordingPositionRequestEncoder;
import io.aeron.archive.codecs.ReplayRequestEncoder;
import io.aeron.archive.codecs.ReplicateRequest2Encoder;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.archive.codecs.StartPositionRequestEncoder;
import io.aeron.archive.codecs.StartRecordingRequest2Encoder;
import io.aeron.archive.codecs.StartRecordingRequestEncoder;
import io.aeron.archive.codecs.StopAllReplaysRequestEncoder;
import io.aeron.archive.codecs.StopPositionRequestEncoder;
import io.aeron.archive.codecs.StopRecordingByIdentityRequestEncoder;
import io.aeron.archive.codecs.StopRecordingRequestEncoder;
import io.aeron.archive.codecs.StopRecordingSubscriptionRequestEncoder;
import io.aeron.archive.codecs.StopReplayRequestEncoder;
import io.aeron.archive.codecs.StopReplicationRequestEncoder;
import io.aeron.archive.codecs.TruncateRecordingRequestEncoder;
import io.aeron.security.CredentialsSupplier;
import io.aeron.security.NullCredentialsSupplier;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.YieldingIdleStrategy;

public final class ArchiveProxy {
    public static final int DEFAULT_RETRY_ATTEMPTS = 3;
    private final long connectTimeoutNs;
    private final int retryAttempts;
    private final IdleStrategy retryIdleStrategy;
    private final NanoClock nanoClock;
    private final CredentialsSupplier credentialsSupplier;
    private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(256);
    private final Publication publication;
    private final MessageHeaderEncoder messageHeader = new MessageHeaderEncoder();
    private StartRecordingRequestEncoder startRecordingRequest;
    private StartRecordingRequest2Encoder startRecordingRequest2;
    private StopRecordingRequestEncoder stopRecordingRequest;
    private StopRecordingSubscriptionRequestEncoder stopRecordingSubscriptionRequest;
    private StopRecordingByIdentityRequestEncoder stopRecordingByIdentityRequest;
    private ReplayRequestEncoder replayRequest;
    private StopReplayRequestEncoder stopReplayRequest;
    private ListRecordingsRequestEncoder listRecordingsRequest;
    private ListRecordingsForUriRequestEncoder listRecordingsForUriRequest;
    private ListRecordingRequestEncoder listRecordingRequest;
    private ExtendRecordingRequestEncoder extendRecordingRequest;
    private ExtendRecordingRequest2Encoder extendRecordingRequest2;
    private RecordingPositionRequestEncoder recordingPositionRequest;
    private TruncateRecordingRequestEncoder truncateRecordingRequest;
    private PurgeRecordingRequestEncoder purgeRecordingRequest;
    private StopPositionRequestEncoder stopPositionRequest;
    private FindLastMatchingRecordingRequestEncoder findLastMatchingRecordingRequest;
    private ListRecordingSubscriptionsRequestEncoder listRecordingSubscriptionsRequest;
    private BoundedReplayRequestEncoder boundedReplayRequest;
    private StopAllReplaysRequestEncoder stopAllReplaysRequest;
    private ReplicateRequest2Encoder replicateRequest;
    private StopReplicationRequestEncoder stopReplicationRequest;
    private StartPositionRequestEncoder startPositionRequest;
    private DetachSegmentsRequestEncoder detachSegmentsRequest;
    private DeleteDetachedSegmentsRequestEncoder deleteDetachedSegmentsRequest;
    private PurgeSegmentsRequestEncoder purgeSegmentsRequest;
    private AttachSegmentsRequestEncoder attachSegmentsRequest;
    private MigrateSegmentsRequestEncoder migrateSegmentsRequest;

    public ArchiveProxy(Publication publication) {
        this(publication, YieldingIdleStrategy.INSTANCE, SystemNanoClock.INSTANCE, AeronArchive.Configuration.MESSAGE_TIMEOUT_DEFAULT_NS, 3, new NullCredentialsSupplier());
    }

    public ArchiveProxy(Publication publication, IdleStrategy retryIdleStrategy, NanoClock nanoClock, long connectTimeoutNs, int retryAttempts, CredentialsSupplier credentialsSupplier) {
        this.publication = publication;
        this.retryIdleStrategy = retryIdleStrategy;
        this.nanoClock = nanoClock;
        this.connectTimeoutNs = connectTimeoutNs;
        this.retryAttempts = retryAttempts;
        this.credentialsSupplier = credentialsSupplier;
    }

    public Publication publication() {
        return this.publication;
    }

    public boolean connect(String responseChannel, int responseStreamId, long correlationId) {
        byte[] encodedCredentials = this.credentialsSupplier.encodedCredentials();
        AuthConnectRequestEncoder connectRequestEncoder = new AuthConnectRequestEncoder();
        connectRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).correlationId(correlationId).responseStreamId(responseStreamId).version(AeronArchive.Configuration.PROTOCOL_SEMANTIC_VERSION).responseChannel(responseChannel).putEncodedCredentials(encodedCredentials, 0, encodedCredentials.length);
        return this.offerWithTimeout(connectRequestEncoder.encodedLength(), null);
    }

    public boolean tryConnect(String responseChannel, int responseStreamId, long correlationId) {
        byte[] encodedCredentials = this.credentialsSupplier.encodedCredentials();
        AuthConnectRequestEncoder connectRequestEncoder = new AuthConnectRequestEncoder();
        connectRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).correlationId(correlationId).responseStreamId(responseStreamId).version(AeronArchive.Configuration.PROTOCOL_SEMANTIC_VERSION).responseChannel(responseChannel).putEncodedCredentials(encodedCredentials, 0, encodedCredentials.length);
        int length = 8 + connectRequestEncoder.encodedLength();
        return this.publication.offer(this.buffer, 0, length) > 0L;
    }

    public boolean connect(String responseChannel, int responseStreamId, long correlationId, AgentInvoker aeronClientInvoker) {
        byte[] encodedCredentials = this.credentialsSupplier.encodedCredentials();
        AuthConnectRequestEncoder connectRequestEncoder = new AuthConnectRequestEncoder();
        connectRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).correlationId(correlationId).responseStreamId(responseStreamId).version(AeronArchive.Configuration.PROTOCOL_SEMANTIC_VERSION).responseChannel(responseChannel).putEncodedCredentials(encodedCredentials, 0, encodedCredentials.length);
        return this.offerWithTimeout(connectRequestEncoder.encodedLength(), aeronClientInvoker);
    }

    public boolean keepAlive(long controlSessionId, long correlationId) {
        KeepAliveRequestEncoder keepAliveRequestEncoder = new KeepAliveRequestEncoder();
        keepAliveRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId);
        return this.offer(keepAliveRequestEncoder.encodedLength());
    }

    public boolean closeSession(long controlSessionId) {
        CloseSessionRequestEncoder closeSessionRequestEncoder = new CloseSessionRequestEncoder();
        closeSessionRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId);
        return this.offer(closeSessionRequestEncoder.encodedLength());
    }

    public boolean tryChallengeResponse(byte[] encodedCredentials, long correlationId, long controlSessionId) {
        ChallengeResponseEncoder challengeResponseEncoder = new ChallengeResponseEncoder();
        challengeResponseEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).putEncodedCredentials(encodedCredentials, 0, encodedCredentials.length);
        int length = 8 + challengeResponseEncoder.encodedLength();
        return this.publication.offer(this.buffer, 0, length) > 0L;
    }

    public boolean startRecording(String channel, int streamId, SourceLocation sourceLocation, long correlationId, long controlSessionId) {
        if (null == this.startRecordingRequest) {
            this.startRecordingRequest = new StartRecordingRequestEncoder();
        }
        this.startRecordingRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).streamId(streamId).sourceLocation(sourceLocation).channel(channel);
        return this.offer(this.startRecordingRequest.encodedLength());
    }

    public boolean startRecording(String channel, int streamId, SourceLocation sourceLocation, boolean autoStop, long correlationId, long controlSessionId) {
        if (null == this.startRecordingRequest2) {
            this.startRecordingRequest2 = new StartRecordingRequest2Encoder();
        }
        this.startRecordingRequest2.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).streamId(streamId).sourceLocation(sourceLocation).autoStop(autoStop ? BooleanType.TRUE : BooleanType.FALSE).channel(channel);
        return this.offer(this.startRecordingRequest2.encodedLength());
    }

    public boolean stopRecording(String channel, int streamId, long correlationId, long controlSessionId) {
        if (null == this.stopRecordingRequest) {
            this.stopRecordingRequest = new StopRecordingRequestEncoder();
        }
        this.stopRecordingRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).streamId(streamId).channel(channel);
        return this.offer(this.stopRecordingRequest.encodedLength());
    }

    public boolean stopRecording(long subscriptionId, long correlationId, long controlSessionId) {
        if (null == this.stopRecordingSubscriptionRequest) {
            this.stopRecordingSubscriptionRequest = new StopRecordingSubscriptionRequestEncoder();
        }
        this.stopRecordingSubscriptionRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).subscriptionId(subscriptionId);
        return this.offer(this.stopRecordingSubscriptionRequest.encodedLength());
    }

    public boolean stopRecordingByIdentity(long recordingId, long correlationId, long controlSessionId) {
        if (null == this.stopRecordingByIdentityRequest) {
            this.stopRecordingByIdentityRequest = new StopRecordingByIdentityRequestEncoder();
        }
        this.stopRecordingByIdentityRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId);
        return this.offer(this.stopRecordingByIdentityRequest.encodedLength());
    }

    public boolean replay(long recordingId, String replayChannel, int replayStreamId, ReplayParams replayParams, long correlationId, long controlSessionId) {
        if (replayParams.isBounded()) {
            return this.boundedReplay(recordingId, replayParams.position(), replayParams.length(), replayParams.boundingLimitCounterId(), replayChannel, replayStreamId, correlationId, controlSessionId, replayParams.fileIoMaxLength());
        }
        return this.replay(recordingId, replayParams.position(), replayParams.length(), replayChannel, replayStreamId, correlationId, controlSessionId, replayParams.fileIoMaxLength());
    }

    public boolean replay(long recordingId, long position, long length, String replayChannel, int replayStreamId, long correlationId, long controlSessionId) {
        return this.replay(recordingId, position, length, replayChannel, replayStreamId, correlationId, controlSessionId, -1);
    }

    public boolean boundedReplay(long recordingId, long position, long length, int limitCounterId, String replayChannel, int replayStreamId, long correlationId, long controlSessionId) {
        return this.boundedReplay(recordingId, position, length, limitCounterId, replayChannel, replayStreamId, correlationId, controlSessionId, -1);
    }

    public boolean stopReplay(long replaySessionId, long correlationId, long controlSessionId) {
        if (null == this.stopReplayRequest) {
            this.stopReplayRequest = new StopReplayRequestEncoder();
        }
        this.stopReplayRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).replaySessionId(replaySessionId);
        return this.offer(this.stopReplayRequest.encodedLength());
    }

    public boolean stopAllReplays(long recordingId, long correlationId, long controlSessionId) {
        if (null == this.stopAllReplaysRequest) {
            this.stopAllReplaysRequest = new StopAllReplaysRequestEncoder();
        }
        this.stopAllReplaysRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId);
        return this.offer(this.stopAllReplaysRequest.encodedLength());
    }

    public boolean listRecordings(long fromRecordingId, int recordCount, long correlationId, long controlSessionId) {
        if (null == this.listRecordingsRequest) {
            this.listRecordingsRequest = new ListRecordingsRequestEncoder();
        }
        this.listRecordingsRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).fromRecordingId(fromRecordingId).recordCount(recordCount);
        return this.offer(this.listRecordingsRequest.encodedLength());
    }

    public boolean listRecordingsForUri(long fromRecordingId, int recordCount, String channelFragment, int streamId, long correlationId, long controlSessionId) {
        if (null == this.listRecordingsForUriRequest) {
            this.listRecordingsForUriRequest = new ListRecordingsForUriRequestEncoder();
        }
        this.listRecordingsForUriRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).fromRecordingId(fromRecordingId).recordCount(recordCount).streamId(streamId).channel(channelFragment);
        return this.offer(this.listRecordingsForUriRequest.encodedLength());
    }

    public boolean listRecording(long recordingId, long correlationId, long controlSessionId) {
        if (null == this.listRecordingRequest) {
            this.listRecordingRequest = new ListRecordingRequestEncoder();
        }
        this.listRecordingRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId);
        return this.offer(this.listRecordingRequest.encodedLength());
    }

    public boolean extendRecording(String channel, int streamId, SourceLocation sourceLocation, long recordingId, long correlationId, long controlSessionId) {
        if (null == this.extendRecordingRequest) {
            this.extendRecordingRequest = new ExtendRecordingRequestEncoder();
        }
        this.extendRecordingRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId).streamId(streamId).sourceLocation(sourceLocation).channel(channel);
        return this.offer(this.extendRecordingRequest.encodedLength());
    }

    public boolean extendRecording(String channel, int streamId, SourceLocation sourceLocation, boolean autoStop, long recordingId, long correlationId, long controlSessionId) {
        if (null == this.extendRecordingRequest2) {
            this.extendRecordingRequest2 = new ExtendRecordingRequest2Encoder();
        }
        this.extendRecordingRequest2.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId).streamId(streamId).sourceLocation(sourceLocation).autoStop(autoStop ? BooleanType.TRUE : BooleanType.FALSE).channel(channel);
        return this.offer(this.extendRecordingRequest2.encodedLength());
    }

    public boolean getRecordingPosition(long recordingId, long correlationId, long controlSessionId) {
        if (null == this.recordingPositionRequest) {
            this.recordingPositionRequest = new RecordingPositionRequestEncoder();
        }
        this.recordingPositionRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId);
        return this.offer(this.recordingPositionRequest.encodedLength());
    }

    public boolean truncateRecording(long recordingId, long position, long correlationId, long controlSessionId) {
        if (null == this.truncateRecordingRequest) {
            this.truncateRecordingRequest = new TruncateRecordingRequestEncoder();
        }
        this.truncateRecordingRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId).position(position);
        return this.offer(this.truncateRecordingRequest.encodedLength());
    }

    public boolean purgeRecording(long recordingId, long correlationId, long controlSessionId) {
        if (null == this.purgeRecordingRequest) {
            this.purgeRecordingRequest = new PurgeRecordingRequestEncoder();
        }
        this.purgeRecordingRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId);
        return this.offer(this.purgeRecordingRequest.encodedLength());
    }

    public boolean getStartPosition(long recordingId, long correlationId, long controlSessionId) {
        if (null == this.startPositionRequest) {
            this.startPositionRequest = new StartPositionRequestEncoder();
        }
        this.startPositionRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId);
        return this.offer(this.startPositionRequest.encodedLength());
    }

    public boolean getStopPosition(long recordingId, long correlationId, long controlSessionId) {
        if (null == this.stopPositionRequest) {
            this.stopPositionRequest = new StopPositionRequestEncoder();
        }
        this.stopPositionRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId);
        return this.offer(this.stopPositionRequest.encodedLength());
    }

    public boolean findLastMatchingRecording(long minRecordingId, String channelFragment, int streamId, int sessionId, long correlationId, long controlSessionId) {
        if (null == this.findLastMatchingRecordingRequest) {
            this.findLastMatchingRecordingRequest = new FindLastMatchingRecordingRequestEncoder();
        }
        this.findLastMatchingRecordingRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).minRecordingId(minRecordingId).sessionId(sessionId).streamId(streamId).channel(channelFragment);
        return this.offer(this.findLastMatchingRecordingRequest.encodedLength());
    }

    public boolean listRecordingSubscriptions(int pseudoIndex, int subscriptionCount, String channelFragment, int streamId, boolean applyStreamId, long correlationId, long controlSessionId) {
        if (null == this.listRecordingSubscriptionsRequest) {
            this.listRecordingSubscriptionsRequest = new ListRecordingSubscriptionsRequestEncoder();
        }
        this.listRecordingSubscriptionsRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).pseudoIndex(pseudoIndex).subscriptionCount(subscriptionCount).applyStreamId(applyStreamId ? BooleanType.TRUE : BooleanType.FALSE).streamId(streamId).channel(channelFragment);
        return this.offer(this.listRecordingSubscriptionsRequest.encodedLength());
    }

    public boolean replicate(long srcRecordingId, long dstRecordingId, int srcControlStreamId, String srcControlChannel, String liveDestination, long correlationId, long controlSessionId) {
        return this.replicate(srcRecordingId, dstRecordingId, -1L, -1L, -1L, srcControlStreamId, srcControlChannel, liveDestination, null, correlationId, controlSessionId, -1, -1, NullCredentialsSupplier.NULL_CREDENTIAL);
    }

    public boolean replicate(long srcRecordingId, long dstRecordingId, long stopPosition, int srcControlStreamId, String srcControlChannel, String liveDestination, String replicationChannel, long correlationId, long controlSessionId) {
        return this.replicate(srcRecordingId, dstRecordingId, stopPosition, -1L, -1L, srcControlStreamId, srcControlChannel, liveDestination, replicationChannel, correlationId, controlSessionId, -1, -1, NullCredentialsSupplier.NULL_CREDENTIAL);
    }

    public boolean taggedReplicate(long srcRecordingId, long dstRecordingId, long channelTagId, long subscriptionTagId, int srcControlStreamId, String srcControlChannel, String liveDestination, long correlationId, long controlSessionId) {
        return this.replicate(srcRecordingId, dstRecordingId, -1L, channelTagId, subscriptionTagId, srcControlStreamId, srcControlChannel, liveDestination, null, correlationId, controlSessionId, -1, -1, NullCredentialsSupplier.NULL_CREDENTIAL);
    }

    public boolean taggedReplicate(long srcRecordingId, long dstRecordingId, long stopPosition, long channelTagId, long subscriptionTagId, int srcControlStreamId, String srcControlChannel, String liveDestination, String replicationChannel, long correlationId, long controlSessionId) {
        return this.replicate(srcRecordingId, dstRecordingId, stopPosition, channelTagId, subscriptionTagId, srcControlStreamId, srcControlChannel, liveDestination, replicationChannel, correlationId, controlSessionId, -1, -1, NullCredentialsSupplier.NULL_CREDENTIAL);
    }

    public boolean replicate(long srcRecordingId, int srcControlStreamId, String srcControlChannel, ReplicationParams replicationParams, long correlationId, long controlSessionId) {
        if (null != replicationParams.liveDestination() && -1 != replicationParams.replicationSessionId()) {
            throw new IllegalArgumentException("ReplicationParams.liveDestination and ReplicationParams.sessionId can not be specified together");
        }
        return this.replicate(srcRecordingId, replicationParams.dstRecordingId(), replicationParams.stopPosition(), replicationParams.channelTagId(), replicationParams.subscriptionTagId(), srcControlStreamId, srcControlChannel, replicationParams.liveDestination(), replicationParams.replicationChannel(), correlationId, controlSessionId, replicationParams.fileIoMaxLength(), replicationParams.replicationSessionId(), replicationParams.encodedCredentials());
    }

    public boolean stopReplication(long replicationId, long correlationId, long controlSessionId) {
        if (null == this.stopReplicationRequest) {
            this.stopReplicationRequest = new StopReplicationRequestEncoder();
        }
        this.stopReplicationRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).replicationId(replicationId);
        return this.offer(this.stopReplicationRequest.encodedLength());
    }

    public boolean detachSegments(long recordingId, long newStartPosition, long correlationId, long controlSessionId) {
        if (null == this.detachSegmentsRequest) {
            this.detachSegmentsRequest = new DetachSegmentsRequestEncoder();
        }
        this.detachSegmentsRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId).newStartPosition(newStartPosition);
        return this.offer(this.detachSegmentsRequest.encodedLength());
    }

    public boolean deleteDetachedSegments(long recordingId, long correlationId, long controlSessionId) {
        if (null == this.deleteDetachedSegmentsRequest) {
            this.deleteDetachedSegmentsRequest = new DeleteDetachedSegmentsRequestEncoder();
        }
        this.deleteDetachedSegmentsRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId);
        return this.offer(this.deleteDetachedSegmentsRequest.encodedLength());
    }

    public boolean purgeSegments(long recordingId, long newStartPosition, long correlationId, long controlSessionId) {
        if (null == this.purgeSegmentsRequest) {
            this.purgeSegmentsRequest = new PurgeSegmentsRequestEncoder();
        }
        this.purgeSegmentsRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId).newStartPosition(newStartPosition);
        return this.offer(this.purgeSegmentsRequest.encodedLength());
    }

    public boolean attachSegments(long recordingId, long correlationId, long controlSessionId) {
        if (null == this.attachSegmentsRequest) {
            this.attachSegmentsRequest = new AttachSegmentsRequestEncoder();
        }
        this.attachSegmentsRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId);
        return this.offer(this.attachSegmentsRequest.encodedLength());
    }

    public boolean migrateSegments(long srcRecordingId, long dstRecordingId, long correlationId, long controlSessionId) {
        if (null == this.migrateSegmentsRequest) {
            this.migrateSegmentsRequest = new MigrateSegmentsRequestEncoder();
        }
        this.migrateSegmentsRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).srcRecordingId(srcRecordingId).dstRecordingId(dstRecordingId);
        return this.offer(this.migrateSegmentsRequest.encodedLength());
    }

    private boolean offer(int length) {
        this.retryIdleStrategy.reset();
        int attempts = this.retryAttempts;
        long result;
        while ((result = this.publication.offer(this.buffer, 0, 8 + length)) <= 0L) {
            if (result == -4L) {
                throw new ArchiveException("connection to the archive has been closed");
            }
            if (result == -1L) {
                throw new ArchiveException("connection to the archive is no longer available");
            }
            if (result == -5L) {
                throw new ArchiveException("offer failed due to max position being reached");
            }
            if (--attempts <= 0) {
                return false;
            }
            this.retryIdleStrategy.idle();
        }
        return true;
    }

    private boolean offerWithTimeout(int length, AgentInvoker aeronClientInvoker) {
        this.retryIdleStrategy.reset();
        long deadlineNs = this.nanoClock.nanoTime() + this.connectTimeoutNs;
        long result;
        while ((result = this.publication.offer(this.buffer, 0, 8 + length)) <= 0L) {
            if (result == -4L) {
                throw new ArchiveException("connection to the archive has been closed");
            }
            if (result == -5L) {
                throw new ArchiveException("offer failed due to max position being reached");
            }
            if (deadlineNs - this.nanoClock.nanoTime() < 0L) {
                return false;
            }
            if (null != aeronClientInvoker) {
                aeronClientInvoker.invoke();
            }
            this.retryIdleStrategy.idle();
        }
        return true;
    }

    private boolean replay(long recordingId, long position, long length, String replayChannel, int replayStreamId, long correlationId, long controlSessionId, int fileIoMaxLength) {
        if (null == this.replayRequest) {
            this.replayRequest = new ReplayRequestEncoder();
        }
        this.replayRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId).position(position).length(length).replayStreamId(replayStreamId).fileIoMaxLength(fileIoMaxLength).replayChannel(replayChannel);
        return this.offer(this.replayRequest.encodedLength());
    }

    private boolean boundedReplay(long recordingId, long position, long length, int limitCounterId, String replayChannel, int replayStreamId, long correlationId, long controlSessionId, int fileIoMaxLength) {
        if (null == this.boundedReplayRequest) {
            this.boundedReplayRequest = new BoundedReplayRequestEncoder();
        }
        this.boundedReplayRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId).position(position).length(length).limitCounterId(limitCounterId).replayStreamId(replayStreamId).fileIoMaxLength(fileIoMaxLength).replayChannel(replayChannel);
        return this.offer(this.boundedReplayRequest.encodedLength());
    }

    private boolean replicate(long srcRecordingId, long dstRecordingId, long stopPosition, long channelTagId, long subscriptionTagId, int srcControlStreamId, String srcControlChannel, String liveDestination, String replicationChannel, long correlationId, long controlSessionId, int fileIoMaxLength, int replicationSessionId, byte[] encodedCredentials) {
        if (null == this.replicateRequest) {
            this.replicateRequest = new ReplicateRequest2Encoder();
        }
        this.replicateRequest.wrapAndApplyHeader(this.buffer, 0, this.messageHeader).controlSessionId(controlSessionId).correlationId(correlationId).srcRecordingId(srcRecordingId).dstRecordingId(dstRecordingId).stopPosition(stopPosition).channelTagId(channelTagId).subscriptionTagId(subscriptionTagId).srcControlStreamId(srcControlStreamId).fileIoMaxLength(fileIoMaxLength).srcControlChannel(srcControlChannel).liveDestination(liveDestination).replicationChannel(replicationChannel).replicationSessionId(replicationSessionId).putEncodedCredentials(encodedCredentials, 0, encodedCredentials.length);
        return this.offer(this.replicateRequest.encodedLength());
    }
}

