/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.MetaAttribute;
import io.aeron.archive.codecs.RecordingState;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class RecordingDescriptorHeaderDecoder {
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 21;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 8;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RecordingDescriptorHeaderDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 32;
    }

    public int sbeTemplateId() {
        return 21;
    }

    public int sbeSchemaId() {
        return 101;
    }

    public int sbeSchemaVersion() {
        return 8;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public RecordingDescriptorHeaderDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public RecordingDescriptorHeaderDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (21 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public RecordingDescriptorHeaderDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int lengthId() {
        return 1;
    }

    public static int lengthSinceVersion() {
        return 0;
    }

    public static int lengthEncodingOffset() {
        return 0;
    }

    public static int lengthEncodingLength() {
        return 4;
    }

    public static String lengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int lengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int lengthMinValue() {
        return -2147483647;
    }

    public static int lengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int length() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int stateId() {
        return 2;
    }

    public static int stateSinceVersion() {
        return 0;
    }

    public static int stateEncodingOffset() {
        return 4;
    }

    public static int stateEncodingLength() {
        return 4;
    }

    public static String stateMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public int stateRaw() {
        return this.buffer.getInt(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public RecordingState state() {
        return RecordingState.get(this.buffer.getInt(this.offset + 4, ByteOrder.LITTLE_ENDIAN));
    }

    public static int checksumId() {
        return 4;
    }

    public static int checksumSinceVersion() {
        return 0;
    }

    public static int checksumEncodingOffset() {
        return 8;
    }

    public static int checksumEncodingLength() {
        return 4;
    }

    public static String checksumMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int checksumNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int checksumMinValue() {
        return -2147483647;
    }

    public static int checksumMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int checksum() {
        return this.buffer.getInt(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int reservedId() {
        return 3;
    }

    public static int reservedSinceVersion() {
        return 0;
    }

    public static int reservedEncodingOffset() {
        return 31;
    }

    public static int reservedEncodingLength() {
        return 1;
    }

    public static String reservedMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte reservedNullValue() {
        return -128;
    }

    public static byte reservedMinValue() {
        return -127;
    }

    public static byte reservedMaxValue() {
        return 127;
    }

    public byte reserved() {
        return this.buffer.getByte(this.offset + 31);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        RecordingDescriptorHeaderDecoder decoder = new RecordingDescriptorHeaderDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[RecordingDescriptorHeader](sbeTemplateId=");
        builder.append(21);
        builder.append("|sbeSchemaId=");
        builder.append(101);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 8) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(8);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 32) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(32);
        builder.append("):");
        builder.append("length=");
        builder.append(this.length());
        builder.append('|');
        builder.append("state=");
        builder.append((Object)this.state());
        builder.append('|');
        builder.append("checksum=");
        builder.append(this.checksum());
        builder.append('|');
        builder.append("reserved=");
        builder.append(this.reserved());
        this.limit(originalLimit);
        return builder;
    }

    public RecordingDescriptorHeaderDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

