/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.MetaAttribute;
import io.aeron.archive.codecs.TaggedReplicateRequestDecoder;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class TaggedReplicateRequestEncoder {
    public static final int BLOCK_LENGTH = 52;
    public static final int TEMPLATE_ID = 62;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 8;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final TaggedReplicateRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 52;
    }

    public int sbeTemplateId() {
        return 62;
    }

    public int sbeSchemaId() {
        return 101;
    }

    public int sbeSchemaVersion() {
        return 8;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public TaggedReplicateRequestEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 52);
        return this;
    }

    public TaggedReplicateRequestEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(52).templateId(62).schemaId(101).version(8);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int controlSessionIdId() {
        return 1;
    }

    public static int controlSessionIdSinceVersion() {
        return 0;
    }

    public static int controlSessionIdEncodingOffset() {
        return 0;
    }

    public static int controlSessionIdEncodingLength() {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long controlSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long controlSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public TaggedReplicateRequestEncoder controlSessionId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public TaggedReplicateRequestEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int srcRecordingIdId() {
        return 3;
    }

    public static int srcRecordingIdSinceVersion() {
        return 0;
    }

    public static int srcRecordingIdEncodingOffset() {
        return 16;
    }

    public static int srcRecordingIdEncodingLength() {
        return 8;
    }

    public static String srcRecordingIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long srcRecordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long srcRecordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long srcRecordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public TaggedReplicateRequestEncoder srcRecordingId(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int dstRecordingIdId() {
        return 4;
    }

    public static int dstRecordingIdSinceVersion() {
        return 0;
    }

    public static int dstRecordingIdEncodingOffset() {
        return 24;
    }

    public static int dstRecordingIdEncodingLength() {
        return 8;
    }

    public static String dstRecordingIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long dstRecordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long dstRecordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long dstRecordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public TaggedReplicateRequestEncoder dstRecordingId(long value) {
        this.buffer.putLong(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int channelTagIdId() {
        return 5;
    }

    public static int channelTagIdSinceVersion() {
        return 0;
    }

    public static int channelTagIdEncodingOffset() {
        return 32;
    }

    public static int channelTagIdEncodingLength() {
        return 8;
    }

    public static String channelTagIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long channelTagIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long channelTagIdMinValue() {
        return -9223372036854775807L;
    }

    public static long channelTagIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public TaggedReplicateRequestEncoder channelTagId(long value) {
        this.buffer.putLong(this.offset + 32, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int subscriptionTagIdId() {
        return 6;
    }

    public static int subscriptionTagIdSinceVersion() {
        return 0;
    }

    public static int subscriptionTagIdEncodingOffset() {
        return 40;
    }

    public static int subscriptionTagIdEncodingLength() {
        return 8;
    }

    public static String subscriptionTagIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long subscriptionTagIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long subscriptionTagIdMinValue() {
        return -9223372036854775807L;
    }

    public static long subscriptionTagIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public TaggedReplicateRequestEncoder subscriptionTagId(long value) {
        this.buffer.putLong(this.offset + 40, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int srcControlStreamIdId() {
        return 7;
    }

    public static int srcControlStreamIdSinceVersion() {
        return 0;
    }

    public static int srcControlStreamIdEncodingOffset() {
        return 48;
    }

    public static int srcControlStreamIdEncodingLength() {
        return 4;
    }

    public static String srcControlStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int srcControlStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int srcControlStreamIdMinValue() {
        return -2147483647;
    }

    public static int srcControlStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public TaggedReplicateRequestEncoder srcControlStreamId(int value) {
        this.buffer.putInt(this.offset + 48, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int srcControlChannelId() {
        return 8;
    }

    public static String srcControlChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String srcControlChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int srcControlChannelHeaderLength() {
        return 4;
    }

    public TaggedReplicateRequestEncoder putSrcControlChannel(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public TaggedReplicateRequestEncoder putSrcControlChannel(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public TaggedReplicateRequestEncoder srcControlChannel(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public TaggedReplicateRequestEncoder srcControlChannel(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public static int liveDestinationId() {
        return 9;
    }

    public static String liveDestinationCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String liveDestinationMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int liveDestinationHeaderLength() {
        return 4;
    }

    public TaggedReplicateRequestEncoder putLiveDestination(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public TaggedReplicateRequestEncoder putLiveDestination(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public TaggedReplicateRequestEncoder liveDestination(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public TaggedReplicateRequestEncoder liveDestination(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        TaggedReplicateRequestDecoder decoder = new TaggedReplicateRequestDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 52, 8);
        return decoder.appendTo(builder);
    }
}

