/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.CommonContext;
import io.aeron.Counter;
import io.aeron.RethrowingErrorHandler;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.cluster.ClusterBackupAgent;
import io.aeron.cluster.ClusterBackupEventsListener;
import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.client.AeronCluster;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.mark.ClusterComponentType;
import io.aeron.cluster.service.ClusterCounters;
import io.aeron.cluster.service.ClusterMarkFile;
import io.aeron.cluster.service.ClusteredServiceContainer;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.ConfigurationException;
import io.aeron.security.CredentialsSupplier;
import io.aeron.security.NullCredentialsSupplier;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Supplier;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.IoUtil;
import org.agrona.MarkFile;
import org.agrona.Strings;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.CountedErrorHandler;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NoOpLock;
import org.agrona.concurrent.ShutdownSignalBarrier;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.YieldingIdleStrategy;
import org.agrona.concurrent.errors.DistinctErrorLog;
import org.agrona.concurrent.status.AtomicCounter;

public final class ClusterBackup
implements AutoCloseable {
    public static final int BACKUP_STATE_TYPE_ID = 208;
    public static final int LIVE_LOG_POSITION_TYPE_ID = 209;
    public static final int QUERY_DEADLINE_TYPE_ID = 210;
    public static final int CLUSTER_BACKUP_ERROR_COUNT_TYPE_ID = 211;
    private final Context ctx;
    private final AgentInvoker agentInvoker;
    private final AgentRunner agentRunner;

    private ClusterBackup(Context ctx) {
        try {
            ctx.conclude();
            this.ctx = ctx;
            ClusterBackupAgent agent = new ClusterBackupAgent(ctx);
            if (ctx.useAgentInvoker()) {
                this.agentRunner = null;
                this.agentInvoker = new AgentInvoker(ctx.errorHandler(), ctx.errorCounter(), agent);
            } else {
                this.agentRunner = new AgentRunner(ctx.idleStrategy(), ctx.errorHandler(), ctx.errorCounter(), agent);
                this.agentInvoker = null;
            }
        }
        catch (ConcurrentConcludeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            CloseHelper.quietClose(ctx::close);
            throw ex;
        }
    }

    public static ClusterBackup launch() {
        return ClusterBackup.launch(new Context());
    }

    public static ClusterBackup launch(Context ctx) {
        ClusterBackup clusterBackup = new ClusterBackup(ctx);
        if (null != clusterBackup.agentRunner) {
            AgentRunner.startOnThread(clusterBackup.agentRunner, ctx.threadFactory());
        } else {
            clusterBackup.agentInvoker.start();
        }
        return clusterBackup;
    }

    public Context context() {
        return this.ctx;
    }

    public AgentInvoker conductorAgentInvoker() {
        return this.agentInvoker;
    }

    @Override
    public void close() {
        CountedErrorHandler countedErrorHandler = this.ctx.countedErrorHandler();
        CloseHelper.close(countedErrorHandler, this.agentRunner);
        CloseHelper.close(countedErrorHandler, this.agentInvoker);
    }

    public static class Context
    implements Cloneable {
        private static final AtomicIntegerFieldUpdater<Context> IS_CONCLUDED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Context.class, "isConcluded");
        private volatile int isConcluded;
        private boolean ownsAeronClient = false;
        private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
        private Aeron aeron;
        private int clusterId = ClusteredServiceContainer.Configuration.clusterId();
        private String consensusChannel = Configuration.consensusChannel();
        private int consensusStreamId = ConsensusModule.Configuration.consensusStreamId();
        private int consensusModuleSnapshotStreamId = ConsensusModule.Configuration.snapshotStreamId();
        private int serviceSnapshotStreamId = ClusteredServiceContainer.Configuration.snapshotStreamId();
        private int logStreamId = ConsensusModule.Configuration.logStreamId();
        private String catchupEndpoint = Configuration.catchupEndpoint();
        private String catchupChannel = Configuration.catchupChannel();
        private long clusterBackupIntervalNs = Configuration.clusterBackupIntervalNs();
        private long clusterBackupResponseTimeoutNs = Configuration.clusterBackupResponseTimeoutNs();
        private long clusterBackupProgressTimeoutNs = Configuration.clusterBackupProgressTimeoutNs();
        private long clusterBackupCoolDownIntervalNs = Configuration.clusterBackupCoolDownIntervalNs();
        private int errorBufferLength = ConsensusModule.Configuration.errorBufferLength();
        private boolean deleteDirOnStart = false;
        private boolean useAgentInvoker = false;
        private String clusterDirectoryName = ClusteredServiceContainer.Configuration.clusterDirName();
        private File clusterDir;
        private File markFileDir;
        private ClusterMarkFile markFile;
        private String clusterConsensusEndpoints = ConsensusModule.Configuration.clusterConsensusEndpoints();
        private ThreadFactory threadFactory;
        private EpochClock epochClock;
        private Supplier<IdleStrategy> idleStrategySupplier;
        private DistinctErrorLog errorLog;
        private ErrorHandler errorHandler;
        private AtomicCounter errorCounter;
        private CountedErrorHandler countedErrorHandler;
        private Counter stateCounter;
        private Counter liveLogPositionCounter;
        private Counter nextQueryDeadlineMsCounter;
        private AeronArchive.Context archiveContext;
        private AeronArchive.Context clusterArchiveContext;
        private ShutdownSignalBarrier shutdownSignalBarrier;
        private Runnable terminationHook;
        private ClusterBackupEventsListener eventsListener;
        private CredentialsSupplier credentialsSupplier;
        private String sourceType = Configuration.clusterBackupSourceType();
        private long replicationProgressTimeoutNs = ConsensusModule.Configuration.replicationProgressTimeoutNs();
        private long replicationProgressIntervalNs = ConsensusModule.Configuration.replicationProgressIntervalNs();

        public Context clone() {
            try {
                return (Context)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void conclude() {
            ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
            if (0 != IS_CONCLUDED_UPDATER.getAndSet(this, 1)) {
                throw new ConcurrentConcludeException();
            }
            if (null == this.clusterDir) {
                this.clusterDir = new File(this.clusterDirectoryName);
            } else {
                this.clusterDirectoryName = this.clusterDir.getPath();
            }
            if (this.deleteDirOnStart) {
                IoUtil.delete(this.clusterDir, false);
            }
            if (null == this.catchupEndpoint) {
                throw new ClusterException("ClusterBackup.Context.catchupEndpoint must be set");
            }
            if (!this.clusterDir.exists() && !this.clusterDir.mkdirs()) {
                throw new ClusterException("failed to create cluster dir: " + this.clusterDir.getAbsolutePath());
            }
            if (null == this.markFileDir) {
                String dir = ClusteredServiceContainer.Configuration.markFileDir();
                File file = this.markFileDir = Strings.isEmpty(dir) ? this.clusterDir : new File(dir);
            }
            if (!this.markFileDir.exists() && !this.markFileDir.mkdirs()) {
                throw new ArchiveException("failed to create mark file dir: " + this.markFileDir.getAbsolutePath());
            }
            if (null == this.epochClock) {
                this.epochClock = SystemEpochClock.INSTANCE;
            }
            if (-1L == this.replicationProgressIntervalNs) {
                this.replicationProgressIntervalNs = Math.max(this.replicationProgressTimeoutNs / 10L, 1L);
            }
            if (null == this.markFile) {
                this.markFile = new ClusterMarkFile(new File(this.markFileDir, "cluster-mark.dat"), ClusterComponentType.BACKUP, this.errorBufferLength, this.epochClock, ClusteredServiceContainer.Configuration.LIVENESS_TIMEOUT_MS);
            }
            MarkFile.ensureMarkFileLink(this.clusterDir, new File(this.markFile.parentDirectory(), "cluster-mark.dat"), "cluster-mark.lnk");
            if (null == this.errorLog) {
                this.errorLog = new DistinctErrorLog(this.markFile.errorBuffer(), this.epochClock, StandardCharsets.US_ASCII);
            }
            this.errorHandler = CommonContext.setupErrorHandler(this.errorHandler, this.errorLog);
            if (null == this.aeron) {
                this.ownsAeronClient = true;
                this.aeron = Aeron.connect(new Aeron.Context().aeronDirectoryName(this.aeronDirectoryName).errorHandler(this.errorHandler).epochClock(this.epochClock).useConductorAgentInvoker(true).awaitingIdleStrategy(YieldingIdleStrategy.INSTANCE).subscriberErrorHandler(RethrowingErrorHandler.INSTANCE).clientLock(NoOpLock.INSTANCE));
                if (null == this.errorCounter) {
                    this.errorCounter = ClusterCounters.allocateVersioned(this.aeron, buffer, "ClusterBackup Errors", 211, this.clusterId, "1.43.0", "940b6ccf43");
                }
            }
            if (!(this.aeron.context().subscriberErrorHandler() instanceof RethrowingErrorHandler)) {
                throw new ClusterException("Aeron client must use a RethrowingErrorHandler");
            }
            if (null == this.aeron.conductorAgentInvoker()) {
                throw new ClusterException("Aeron client must use conductor agent invoker");
            }
            if (null == this.errorCounter) {
                throw new ClusterException("error counter must be supplied if aeron client is");
            }
            if (null == this.countedErrorHandler) {
                this.countedErrorHandler = new CountedErrorHandler(this.errorHandler, this.errorCounter);
                if (this.ownsAeronClient) {
                    this.aeron.context().errorHandler(this.countedErrorHandler);
                }
            }
            if (null == this.stateCounter) {
                this.stateCounter = ClusterCounters.allocate(this.aeron, buffer, "ClusterBackup State", 208, this.clusterId);
            }
            if (null == this.liveLogPositionCounter) {
                this.liveLogPositionCounter = ClusterCounters.allocate(this.aeron, buffer, "ClusterBackup live log position", 209, this.clusterId);
            }
            if (null == this.nextQueryDeadlineMsCounter) {
                this.nextQueryDeadlineMsCounter = ClusterCounters.allocate(this.aeron, buffer, "ClusterBackup next query deadline in ms", 210, this.clusterId);
            }
            if (null == this.threadFactory) {
                this.threadFactory = Thread::new;
            }
            if (null == this.idleStrategySupplier) {
                this.idleStrategySupplier = ClusteredServiceContainer.Configuration.idleStrategySupplier(null);
            }
            if (null == this.archiveContext) {
                this.archiveContext = new AeronArchive.Context().controlRequestChannel(AeronArchive.Configuration.localControlChannel()).controlResponseChannel(AeronArchive.Configuration.localControlChannel()).controlRequestStreamId(AeronArchive.Configuration.localControlStreamId());
            }
            this.archiveContext.aeron(this.aeron).errorHandler(this.errorHandler).ownsAeronClient(false).lock(NoOpLock.INSTANCE);
            if (!this.archiveContext.controlRequestChannel().startsWith("aeron:ipc")) {
                throw new ClusterException("local archive control must be IPC");
            }
            if (!this.archiveContext.controlResponseChannel().startsWith("aeron:ipc")) {
                throw new ClusterException("local archive control must be IPC");
            }
            if (null == this.clusterArchiveContext) {
                this.clusterArchiveContext = new AeronArchive.Context();
            }
            this.clusterArchiveContext.aeron(this.aeron).ownsAeronClient(false).lock(NoOpLock.INSTANCE);
            if (null == this.shutdownSignalBarrier) {
                this.shutdownSignalBarrier = new ShutdownSignalBarrier();
            }
            if (null == this.terminationHook) {
                this.terminationHook = () -> this.shutdownSignalBarrier.signalAll();
            }
            if (null == this.credentialsSupplier) {
                this.credentialsSupplier = new NullCredentialsSupplier();
            }
            try {
                SourceType.valueOf(this.sourceType);
            }
            catch (IllegalArgumentException ex) {
                throw new ConfigurationException("ClusterBackup.Context.sourceType=" + this.sourceType + " is not valid. Must be one of: " + Arrays.toString((Object[])SourceType.values()));
            }
            this.concludeMarkFile();
        }

        public Context aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public Aeron aeron() {
            return this.aeron;
        }

        public Context aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Context ownsAeronClient(boolean ownsAeronClient) {
            this.ownsAeronClient = ownsAeronClient;
            return this;
        }

        public boolean ownsAeronClient() {
            return this.ownsAeronClient;
        }

        public Context deleteDirOnStart(boolean deleteDirOnStart) {
            this.deleteDirOnStart = deleteDirOnStart;
            return this;
        }

        public boolean deleteDirOnStart() {
            return this.deleteDirOnStart;
        }

        public Context clusterId(int clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public int clusterId() {
            return this.clusterId;
        }

        public Context clusterDirectoryName(String clusterDirectoryName) {
            this.clusterDirectoryName = clusterDirectoryName;
            return this;
        }

        public String clusterDirectoryName() {
            return this.clusterDirectoryName;
        }

        public Context clusterDir(File clusterDir) {
            this.clusterDir = clusterDir;
            return this;
        }

        public File clusterDir() {
            return this.clusterDir;
        }

        public File markFileDir() {
            return this.markFileDir;
        }

        public Context markFileDir(File markFileDir) {
            this.markFileDir = markFileDir;
            return this;
        }

        public Context archiveContext(AeronArchive.Context archiveContext) {
            this.archiveContext = archiveContext;
            return this;
        }

        public AeronArchive.Context archiveContext() {
            return this.archiveContext;
        }

        public Context clusterArchiveContext(AeronArchive.Context archiveContext) {
            this.clusterArchiveContext = archiveContext;
            return this;
        }

        public AeronArchive.Context clusterArchiveContext() {
            return this.clusterArchiveContext;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        public Context threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Context idleStrategySupplier(Supplier<IdleStrategy> idleStrategySupplier) {
            this.idleStrategySupplier = idleStrategySupplier;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategySupplier.get();
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public AtomicCounter errorCounter() {
            return this.errorCounter;
        }

        public Context errorCounter(AtomicCounter errorCounter) {
            this.errorCounter = errorCounter;
            return this;
        }

        public Context countedErrorHandler(CountedErrorHandler countedErrorHandler) {
            this.countedErrorHandler = countedErrorHandler;
            return this;
        }

        public CountedErrorHandler countedErrorHandler() {
            return this.countedErrorHandler;
        }

        public Context consensusChannel(String channel) {
            this.consensusChannel = channel;
            return this;
        }

        public String consensusChannel() {
            return this.consensusChannel;
        }

        public Context consensusStreamId(int streamId) {
            this.consensusStreamId = streamId;
            return this;
        }

        public int consensusStreamId() {
            return this.consensusStreamId;
        }

        public Context consensusModuleSnapshotStreamId(int streamId) {
            this.consensusModuleSnapshotStreamId = streamId;
            return this;
        }

        public int consensusModuleSnapshotStreamId() {
            return this.consensusModuleSnapshotStreamId;
        }

        public Context serviceSnapshotStreamId(int streamId) {
            this.serviceSnapshotStreamId = streamId;
            return this;
        }

        public int serviceSnapshotStreamId() {
            return this.serviceSnapshotStreamId;
        }

        public Context logStreamId(int streamId) {
            this.logStreamId = streamId;
            return this;
        }

        public int logStreamId() {
            return this.logStreamId;
        }

        public Context catchupEndpoint(String catchupEndpoint) {
            this.catchupEndpoint = catchupEndpoint;
            return this;
        }

        public String catchupEndpoint() {
            return this.catchupEndpoint;
        }

        public Context catchupChannel(String catchupChannel) {
            this.catchupChannel = catchupChannel;
            return this;
        }

        public String catchupChannel() {
            return this.catchupChannel;
        }

        public Context clusterBackupIntervalNs(long clusterBackupIntervalNs) {
            this.clusterBackupIntervalNs = clusterBackupIntervalNs;
            return this;
        }

        public long clusterBackupIntervalNs() {
            return this.clusterBackupIntervalNs;
        }

        public Context clusterBackupResponseTimeoutNs(long clusterBackupResponseTimeoutNs) {
            this.clusterBackupResponseTimeoutNs = clusterBackupResponseTimeoutNs;
            return this;
        }

        public long clusterBackupResponseTimeoutNs() {
            return this.clusterBackupResponseTimeoutNs;
        }

        public Context clusterBackupProgressTimeoutNs(long clusterBackupProgressTimeoutNs) {
            this.clusterBackupProgressTimeoutNs = clusterBackupProgressTimeoutNs;
            return this;
        }

        public long clusterBackupProgressTimeoutNs() {
            return this.clusterBackupProgressTimeoutNs;
        }

        public Context clusterBackupCoolDownIntervalNs(long clusterBackupCoolDownIntervalNs) {
            this.clusterBackupCoolDownIntervalNs = clusterBackupCoolDownIntervalNs;
            return this;
        }

        public long clusterBackupCoolDownIntervalNs() {
            return this.clusterBackupCoolDownIntervalNs;
        }

        public Context clusterConsensusEndpoints(String endpoints) {
            this.clusterConsensusEndpoints = endpoints;
            return this;
        }

        public String clusterConsensusEndpoints() {
            return this.clusterConsensusEndpoints;
        }

        public Context shutdownSignalBarrier(ShutdownSignalBarrier barrier) {
            this.shutdownSignalBarrier = barrier;
            return this;
        }

        public ShutdownSignalBarrier shutdownSignalBarrier() {
            return this.shutdownSignalBarrier;
        }

        public Context terminationHook(Runnable terminationHook) {
            this.terminationHook = terminationHook;
            return this;
        }

        public Runnable terminationHook() {
            return this.terminationHook;
        }

        public Context clusterMarkFile(ClusterMarkFile markFile) {
            this.markFile = markFile;
            return this;
        }

        public ClusterMarkFile clusterMarkFile() {
            return this.markFile;
        }

        public Context errorBufferLength(int errorBufferLength) {
            this.errorBufferLength = errorBufferLength;
            return this;
        }

        public int errorBufferLength() {
            return this.errorBufferLength;
        }

        public Context errorLog(DistinctErrorLog errorLog) {
            this.errorLog = errorLog;
            return this;
        }

        public DistinctErrorLog errorLog() {
            return this.errorLog;
        }

        public Counter stateCounter() {
            return this.stateCounter;
        }

        public Context stateCounter(Counter stateCounter) {
            this.stateCounter = stateCounter;
            return this;
        }

        public Counter liveLogPositionCounter() {
            return this.liveLogPositionCounter;
        }

        public Context liveLogPositionCounter(Counter liveLogPositionCounter) {
            this.liveLogPositionCounter = liveLogPositionCounter;
            return this;
        }

        public Counter nextQueryDeadlineMsCounter() {
            return this.nextQueryDeadlineMsCounter;
        }

        public Context nextQueryDeadlineMsCounter(Counter nextQueryDeadlineMsCounter) {
            this.nextQueryDeadlineMsCounter = nextQueryDeadlineMsCounter;
            return this;
        }

        public ClusterBackupEventsListener eventsListener() {
            return this.eventsListener;
        }

        public Context eventsListener(ClusterBackupEventsListener eventsListener) {
            this.eventsListener = eventsListener;
            return this;
        }

        public Context useAgentInvoker(boolean useAgentInvoker) {
            this.useAgentInvoker = useAgentInvoker;
            return this;
        }

        public boolean useAgentInvoker() {
            return this.useAgentInvoker;
        }

        public Context credentialsSupplier(CredentialsSupplier credentialsSupplier) {
            this.credentialsSupplier = credentialsSupplier;
            return this;
        }

        public CredentialsSupplier credentialsSupplier() {
            return this.credentialsSupplier;
        }

        public Context sourceType(SourceType sourceType) {
            this.sourceType = sourceType.name();
            return this;
        }

        public SourceType sourceType() {
            return SourceType.valueOf(this.sourceType);
        }

        public Context replicationProgressTimeoutNs(long timeoutNs) {
            this.replicationProgressTimeoutNs = timeoutNs;
            return this;
        }

        public long replicationProgressTimeoutNs() {
            return this.replicationProgressTimeoutNs;
        }

        public Context replicationProgressIntervalNs(long intervalNs) {
            this.replicationProgressIntervalNs = intervalNs;
            return this;
        }

        public long replicationProgressIntervalNs() {
            return this.replicationProgressIntervalNs;
        }

        public void deleteDirectory() {
            if (null != this.clusterDir) {
                IoUtil.delete(this.clusterDir, false);
            }
        }

        public void close() {
            if (this.ownsAeronClient) {
                CloseHelper.close(this.countedErrorHandler, this.aeron);
            } else {
                CloseHelper.close(this.countedErrorHandler, this.stateCounter);
                CloseHelper.close(this.countedErrorHandler, this.liveLogPositionCounter);
            }
            CloseHelper.close(this.countedErrorHandler, this.markFile);
        }

        public String toString() {
            return "ClusterBackup.Context\n{\n    isConcluded=" + (1 == this.isConcluded) + "\n    ownsAeronClient=" + this.ownsAeronClient + "\n    aeronDirectoryName='" + this.aeronDirectoryName + '\'' + "\n    aeron=" + this.aeron + "\n    clusterId=" + this.clusterId + "\n    consensusChannel='" + this.consensusChannel + '\'' + "\n    consensusStreamId=" + this.consensusStreamId + "\n    consensusModuleSnapshotStreamId=" + this.consensusModuleSnapshotStreamId + "\n    serviceSnapshotStreamId=" + this.serviceSnapshotStreamId + "\n    logStreamId=" + this.logStreamId + "\n    catchupEndpoint='" + this.catchupEndpoint + '\'' + "\n    catchupChannel='" + this.catchupChannel + '\'' + "\n    clusterBackupIntervalNs=" + this.clusterBackupIntervalNs + "\n    clusterBackupResponseTimeoutNs=" + this.clusterBackupResponseTimeoutNs + "\n    clusterBackupProgressTimeoutNs=" + this.clusterBackupProgressTimeoutNs + "\n    clusterBackupCoolDownIntervalNs=" + this.clusterBackupCoolDownIntervalNs + "\n    errorBufferLength=" + this.errorBufferLength + "\n    deleteDirOnStart=" + this.deleteDirOnStart + "\n    useAgentInvoker=" + this.useAgentInvoker + "\n    clusterDirectoryName='" + this.clusterDirectoryName + '\'' + "\n    clusterDir=" + this.clusterDir + "\n    markFile=" + this.markFile + "\n    clusterConsensusEndpoints='" + this.clusterConsensusEndpoints + '\'' + "\n    threadFactory=" + this.threadFactory + "\n    epochClock=" + this.epochClock + "\n    idleStrategySupplier=" + this.idleStrategySupplier + "\n    errorLog=" + this.errorLog + "\n    errorHandler=" + this.errorHandler + "\n    errorCounter=" + this.errorCounter + "\n    countedErrorHandler=" + this.countedErrorHandler + "\n    stateCounter=" + this.stateCounter + "\n    liveLogPositionCounter=" + this.liveLogPositionCounter + "\n    nextQueryDeadlineMsCounter=" + this.nextQueryDeadlineMsCounter + "\n    archiveContext=" + this.archiveContext + "\n    clusterArchiveContext=" + this.clusterArchiveContext + "\n    shutdownSignalBarrier=" + this.shutdownSignalBarrier + "\n    terminationHook=" + this.terminationHook + "\n    eventsListener=" + this.eventsListener + "\n}";
        }

        private void concludeMarkFile() {
            ClusterMarkFile.checkHeaderLength(this.aeron.context().aeronDirectoryName(), null, null, null, null);
            this.markFile.encoder().archiveStreamId(this.archiveContext.controlRequestStreamId()).serviceStreamId(ClusteredServiceContainer.Configuration.serviceStreamId()).consensusModuleStreamId(ClusteredServiceContainer.Configuration.consensusModuleStreamId()).ingressStreamId(AeronCluster.Configuration.ingressStreamId()).memberId(-1).serviceId(-1).clusterId(ClusteredServiceContainer.Configuration.clusterId()).aeronDirectory(this.aeron.context().aeronDirectoryName()).controlChannel(null).ingressChannel(null).serviceName(null).authenticator(null);
            this.markFile.updateActivityTimestamp(this.epochClock.time());
            this.markFile.signalReady();
        }
    }

    public static class Configuration {
        public static final String CLUSTER_BACKUP_CATCHUP_ENDPOINT_PROP_NAME = "aeron.cluster.backup.catchup.endpoint";
        public static final String CLUSTER_BACKUP_CATCHUP_CHANNEL_PROP_NAME = "aeron.cluster.backup.catchup.channel";
        public static final String CLUSTER_BACKUP_CATCHUP_CHANNEL_DEFAULT = "aeron:udp?alias=backup|cc=cubic|so-sndbuf=512k|so-rcvbuf=512k|rcv-wnd=512k";
        public static final String CLUSTER_BACKUP_INTERVAL_PROP_NAME = "aeron.cluster.backup.interval";
        public static final long CLUSTER_BACKUP_INTERVAL_DEFAULT_NS = TimeUnit.HOURS.toNanos(1L);
        public static final String CLUSTER_BACKUP_RESPONSE_TIMEOUT_PROP_NAME = "aeron.cluster.backup.response.timeout";
        public static final long CLUSTER_BACKUP_RESPONSE_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(5L);
        public static final String CLUSTER_BACKUP_PROGRESS_TIMEOUT_PROP_NAME = "aeron.cluster.backup.progress.timeout";
        public static final String CLUSTER_BACKUP_COOL_DOWN_INTERVAL_PROP_NAME = "aeron.cluster.backup.cool.down.interval";
        public static final long CLUSTER_BACKUP_COOL_DOWN_INTERVAL_DEFAULT_NS = TimeUnit.SECONDS.toNanos(30L);
        public static final long CLUSTER_BACKUP_PROGRESS_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(10L);
        public static final String CLUSTER_BACKUP_SOURCE_TYPE_PROP_NAME = "aeron.cluster.backup.source.type";
        public static final String CLUSTER_BACKUP_SOURCE_TYPE_DEFAULT = SourceType.ANY.name();

        public static String catchupEndpoint() {
            String configuredCatchupEndpoint = System.getProperty(CLUSTER_BACKUP_CATCHUP_ENDPOINT_PROP_NAME);
            if (null == configuredCatchupEndpoint && null != ConsensusModule.Configuration.clusterMembers()) {
                ClusterMember member = ClusterMember.determineMember(ClusterMember.parse(ConsensusModule.Configuration.clusterMembers()), ConsensusModule.Configuration.clusterMemberId(), ConsensusModule.Configuration.memberEndpoints());
                configuredCatchupEndpoint = member.catchupEndpoint();
            }
            return configuredCatchupEndpoint;
        }

        public static String catchupChannel() {
            return System.getProperty(CLUSTER_BACKUP_CATCHUP_CHANNEL_PROP_NAME, CLUSTER_BACKUP_CATCHUP_CHANNEL_DEFAULT);
        }

        public static String consensusChannel() {
            ChannelUri consensusUri;
            String consensusChannel = ConsensusModule.Configuration.consensusChannel();
            if (null != consensusChannel && null != ConsensusModule.Configuration.clusterMembers() && !(consensusUri = ChannelUri.parse(consensusChannel)).containsKey("endpoint")) {
                ClusterMember member = ClusterMember.determineMember(ClusterMember.parse(ConsensusModule.Configuration.clusterMembers()), ConsensusModule.Configuration.clusterMemberId(), ConsensusModule.Configuration.memberEndpoints());
                consensusUri.put("endpoint", member.consensusEndpoint());
                consensusChannel = consensusUri.toString();
            }
            return consensusChannel;
        }

        public static long clusterBackupIntervalNs() {
            return SystemUtil.getDurationInNanos(CLUSTER_BACKUP_INTERVAL_PROP_NAME, CLUSTER_BACKUP_INTERVAL_DEFAULT_NS);
        }

        public static long clusterBackupResponseTimeoutNs() {
            return SystemUtil.getDurationInNanos(CLUSTER_BACKUP_RESPONSE_TIMEOUT_PROP_NAME, CLUSTER_BACKUP_RESPONSE_TIMEOUT_DEFAULT_NS);
        }

        public static long clusterBackupProgressTimeoutNs() {
            return SystemUtil.getDurationInNanos(CLUSTER_BACKUP_PROGRESS_TIMEOUT_PROP_NAME, CLUSTER_BACKUP_PROGRESS_TIMEOUT_DEFAULT_NS);
        }

        public static long clusterBackupCoolDownIntervalNs() {
            return SystemUtil.getDurationInNanos(CLUSTER_BACKUP_COOL_DOWN_INTERVAL_PROP_NAME, CLUSTER_BACKUP_COOL_DOWN_INTERVAL_DEFAULT_NS);
        }

        public static String clusterBackupSourceType() {
            return System.getProperty(CLUSTER_BACKUP_SOURCE_TYPE_PROP_NAME, CLUSTER_BACKUP_SOURCE_TYPE_DEFAULT);
        }
    }

    public static enum SourceType {
        ANY,
        LEADER,
        FOLLOWER;

    }

    public static enum State {
        BACKUP_QUERY(0),
        SNAPSHOT_RETRIEVE(1),
        LIVE_LOG_RECORD(2),
        LIVE_LOG_REPLAY(3),
        UPDATE_RECORDING_LOG(4),
        BACKING_UP(5),
        RESET_BACKUP(6),
        CLOSED(7);

        static final State[] STATES;
        private final int code;

        private State(int code) {
            if (code != this.ordinal()) {
                throw new IllegalArgumentException(this.name() + " - code must equal ordinal value: code=" + code);
            }
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public static State get(AtomicCounter counter) {
            if (counter.isClosed()) {
                return CLOSED;
            }
            return State.get(counter.get());
        }

        public static State get(long code) {
            if (code < 0L || code > (long)(STATES.length - 1)) {
                throw new ClusterException("invalid state counter code: " + code);
            }
            return STATES[(int)code];
        }

        static {
            STATES = State.values();
        }
    }
}

