/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ChannelUri;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.LogAdapter;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.service.Cluster;
import io.aeron.exceptions.AeronException;
import org.agrona.CloseHelper;

final class LogReplay {
    private final long startPosition;
    private final long stopPosition;
    private final int logSessionId;
    private final ConsensusModuleAgent consensusModuleAgent;
    private final ConsensusModule.Context ctx;
    private final LogAdapter logAdapter;
    private final Subscription logSubscription;

    LogReplay(AeronArchive archive, long recordingId, long startPosition, long stopPosition, LogAdapter logAdapter, ConsensusModule.Context ctx) {
        this.startPosition = startPosition;
        this.stopPosition = stopPosition;
        this.logAdapter = logAdapter;
        this.consensusModuleAgent = logAdapter.consensusModuleAgent();
        this.ctx = ctx;
        String channel = ctx.replayChannel();
        int streamId = ctx.replayStreamId();
        long length = stopPosition - startPosition;
        this.logSessionId = (int)archive.startReplay(recordingId, startPosition, length, channel, streamId);
        this.logSubscription = ctx.aeron().addSubscription(ChannelUri.addSessionId(channel, this.logSessionId), streamId);
    }

    void close() {
        this.logAdapter.disconnect(this.ctx.countedErrorHandler());
        CloseHelper.close(this.ctx.countedErrorHandler(), this.logSubscription);
    }

    int doWork() {
        int workCount = 0;
        if (null == this.logAdapter.image()) {
            Image image = this.logSubscription.imageBySessionId(this.logSessionId);
            if (null != image) {
                if (image.joinPosition() != this.startPosition) {
                    throw new ClusterException("joinPosition=" + image.joinPosition() + " expected startPosition=" + this.startPosition, AeronException.Category.WARN);
                }
                this.logAdapter.image(image);
                this.consensusModuleAgent.awaitServicesReady(this.logSubscription.channel(), this.logSubscription.streamId(), this.logSessionId, this.startPosition, this.stopPosition, true, Cluster.Role.FOLLOWER);
                ++workCount;
            }
        } else {
            workCount += this.consensusModuleAgent.replayLogPoll(this.logAdapter, this.stopPosition);
        }
        return workCount;
    }

    boolean isDone() {
        return this.logAdapter.image() != null && this.logAdapter.position() >= this.stopPosition && this.consensusModuleAgent.state() != ConsensusModule.State.SNAPSHOT;
    }

    public String toString() {
        return "LogReplay{startPosition=" + this.startPosition + ", stopPosition=" + this.stopPosition + ", logSessionId=" + this.logSessionId + ", logSubscription=" + this.logSubscription + '}';
    }
}

