/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.ClusterControl;
import io.aeron.cluster.NodeControl;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;

interface ToggleApplication<T extends Enum<T>> {
    public static final ToggleApplication<ClusterControl.ToggleState> CLUSTER_CONTROL = new ToggleApplication<ClusterControl.ToggleState>(){

        @Override
        public ClusterControl.ToggleState get(AtomicCounter counter) {
            return ClusterControl.ToggleState.get(counter);
        }

        @Override
        public boolean apply(AtomicCounter counter, ClusterControl.ToggleState targetState) {
            return targetState.toggle(counter);
        }

        @Override
        public AtomicCounter find(CountersReader countersReader, int clusterId) {
            return ClusterControl.findControlToggle(countersReader, clusterId);
        }

        @Override
        public boolean isNeutral(ClusterControl.ToggleState toggleState) {
            return ClusterControl.ToggleState.NEUTRAL == toggleState;
        }
    };
    public static final ToggleApplication<NodeControl.ToggleState> NODE_CONTROL = new ToggleApplication<NodeControl.ToggleState>(){

        @Override
        public NodeControl.ToggleState get(AtomicCounter counter) {
            return NodeControl.ToggleState.get(counter);
        }

        @Override
        public boolean apply(AtomicCounter counter, NodeControl.ToggleState targetState) {
            return targetState.toggle(counter);
        }

        @Override
        public AtomicCounter find(CountersReader countersReader, int clusterId) {
            return NodeControl.findControlToggle(countersReader, clusterId);
        }

        @Override
        public boolean isNeutral(NodeControl.ToggleState toggleState) {
            return NodeControl.ToggleState.NEUTRAL == toggleState;
        }
    };

    public T get(AtomicCounter var1);

    public boolean apply(AtomicCounter var1, T var2);

    public AtomicCounter find(CountersReader var1, int var2);

    public boolean isNeutral(T var1);
}

