/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.BackupResponseDecoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class BackupResponseEncoder {
    public static final int BLOCK_LENGTH = 60;
    public static final int TEMPLATE_ID = 78;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final BackupResponseEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private final SnapshotsEncoder snapshots = new SnapshotsEncoder(this);

    public int sbeBlockLength() {
        return 60;
    }

    public int sbeTemplateId() {
        return 78;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 12;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public BackupResponseEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 60);
        return this;
    }

    public BackupResponseEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(60).templateId(78).schemaId(111).version(12);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int correlationIdId() {
        return 1;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 0;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public BackupResponseEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int logRecordingIdId() {
        return 2;
    }

    public static int logRecordingIdSinceVersion() {
        return 0;
    }

    public static int logRecordingIdEncodingOffset() {
        return 8;
    }

    public static int logRecordingIdEncodingLength() {
        return 8;
    }

    public static String logRecordingIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logRecordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logRecordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long logRecordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public BackupResponseEncoder logRecordingId(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int logLeadershipTermIdId() {
        return 3;
    }

    public static int logLeadershipTermIdSinceVersion() {
        return 0;
    }

    public static int logLeadershipTermIdEncodingOffset() {
        return 16;
    }

    public static int logLeadershipTermIdEncodingLength() {
        return 8;
    }

    public static String logLeadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logLeadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logLeadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long logLeadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public BackupResponseEncoder logLeadershipTermId(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int logTermBaseLogPositionId() {
        return 4;
    }

    public static int logTermBaseLogPositionSinceVersion() {
        return 0;
    }

    public static int logTermBaseLogPositionEncodingOffset() {
        return 24;
    }

    public static int logTermBaseLogPositionEncodingLength() {
        return 8;
    }

    public static String logTermBaseLogPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logTermBaseLogPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logTermBaseLogPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logTermBaseLogPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public BackupResponseEncoder logTermBaseLogPosition(long value) {
        this.buffer.putLong(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int lastLeadershipTermIdId() {
        return 5;
    }

    public static int lastLeadershipTermIdSinceVersion() {
        return 0;
    }

    public static int lastLeadershipTermIdEncodingOffset() {
        return 32;
    }

    public static int lastLeadershipTermIdEncodingLength() {
        return 8;
    }

    public static String lastLeadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long lastLeadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long lastLeadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long lastLeadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public BackupResponseEncoder lastLeadershipTermId(long value) {
        this.buffer.putLong(this.offset + 32, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int lastTermBaseLogPositionId() {
        return 6;
    }

    public static int lastTermBaseLogPositionSinceVersion() {
        return 0;
    }

    public static int lastTermBaseLogPositionEncodingOffset() {
        return 40;
    }

    public static int lastTermBaseLogPositionEncodingLength() {
        return 8;
    }

    public static String lastTermBaseLogPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long lastTermBaseLogPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long lastTermBaseLogPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long lastTermBaseLogPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public BackupResponseEncoder lastTermBaseLogPosition(long value) {
        this.buffer.putLong(this.offset + 40, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int commitPositionCounterIdId() {
        return 7;
    }

    public static int commitPositionCounterIdSinceVersion() {
        return 0;
    }

    public static int commitPositionCounterIdEncodingOffset() {
        return 48;
    }

    public static int commitPositionCounterIdEncodingLength() {
        return 4;
    }

    public static String commitPositionCounterIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int commitPositionCounterIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int commitPositionCounterIdMinValue() {
        return -2147483647;
    }

    public static int commitPositionCounterIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public BackupResponseEncoder commitPositionCounterId(int value) {
        this.buffer.putInt(this.offset + 48, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int leaderMemberIdId() {
        return 8;
    }

    public static int leaderMemberIdSinceVersion() {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset() {
        return 52;
    }

    public static int leaderMemberIdEncodingLength() {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int leaderMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int leaderMemberIdMinValue() {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public BackupResponseEncoder leaderMemberId(int value) {
        this.buffer.putInt(this.offset + 52, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int memberIdId() {
        return 17;
    }

    public static int memberIdSinceVersion() {
        return 10;
    }

    public static int memberIdEncodingOffset() {
        return 56;
    }

    public static int memberIdEncodingLength() {
        return 4;
    }

    public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int memberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int memberIdMinValue() {
        return -2147483647;
    }

    public static int memberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public BackupResponseEncoder memberId(int value) {
        this.buffer.putInt(this.offset + 56, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static long snapshotsId() {
        return 9L;
    }

    public SnapshotsEncoder snapshotsCount(int count) {
        this.snapshots.wrap(this.buffer, count);
        return this.snapshots;
    }

    public static int clusterMembersId() {
        return 16;
    }

    public static String clusterMembersCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String clusterMembersMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int clusterMembersHeaderLength() {
        return 4;
    }

    public BackupResponseEncoder putClusterMembers(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public BackupResponseEncoder putClusterMembers(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public BackupResponseEncoder clusterMembers(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public BackupResponseEncoder clusterMembers(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        BackupResponseDecoder decoder = new BackupResponseDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 60, 12);
        return decoder.appendTo(builder);
    }

    public static final class SnapshotsEncoder {
        public static final int HEADER_SIZE = 4;
        private final BackupResponseEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        SnapshotsEncoder(BackupResponseEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4);
            buffer.putShort(limit + 0, (short)44, ByteOrder.LITTLE_ENDIAN);
            buffer.putShort(limit + 2, (short)count, ByteOrder.LITTLE_ENDIAN);
        }

        public SnapshotsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + SnapshotsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putShort(this.initialLimit + 2, (short)this.count, ByteOrder.LITTLE_ENDIAN);
            return this.count;
        }

        public static int countMinValue() {
            return 0;
        }

        public static int countMaxValue() {
            return 65534;
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 44;
        }

        public static int recordingIdId() {
            return 10;
        }

        public static int recordingIdSinceVersion() {
            return 0;
        }

        public static int recordingIdEncodingOffset() {
            return 0;
        }

        public static int recordingIdEncodingLength() {
            return 8;
        }

        public static String recordingIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long recordingIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long recordingIdMinValue() {
            return -9223372036854775807L;
        }

        public static long recordingIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public SnapshotsEncoder recordingId(long value) {
            this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int leadershipTermIdId() {
            return 11;
        }

        public static int leadershipTermIdSinceVersion() {
            return 0;
        }

        public static int leadershipTermIdEncodingOffset() {
            return 8;
        }

        public static int leadershipTermIdEncodingLength() {
            return 8;
        }

        public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long leadershipTermIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long leadershipTermIdMinValue() {
            return -9223372036854775807L;
        }

        public static long leadershipTermIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public SnapshotsEncoder leadershipTermId(long value) {
            this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int termBaseLogPositionId() {
            return 12;
        }

        public static int termBaseLogPositionSinceVersion() {
            return 0;
        }

        public static int termBaseLogPositionEncodingOffset() {
            return 16;
        }

        public static int termBaseLogPositionEncodingLength() {
            return 8;
        }

        public static String termBaseLogPositionMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long termBaseLogPositionNullValue() {
            return Long.MIN_VALUE;
        }

        public static long termBaseLogPositionMinValue() {
            return -9223372036854775807L;
        }

        public static long termBaseLogPositionMaxValue() {
            return Long.MAX_VALUE;
        }

        public SnapshotsEncoder termBaseLogPosition(long value) {
            this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int logPositionId() {
            return 13;
        }

        public static int logPositionSinceVersion() {
            return 0;
        }

        public static int logPositionEncodingOffset() {
            return 24;
        }

        public static int logPositionEncodingLength() {
            return 8;
        }

        public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long logPositionNullValue() {
            return Long.MIN_VALUE;
        }

        public static long logPositionMinValue() {
            return -9223372036854775807L;
        }

        public static long logPositionMaxValue() {
            return Long.MAX_VALUE;
        }

        public SnapshotsEncoder logPosition(long value) {
            this.buffer.putLong(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int timestampId() {
            return 14;
        }

        public static int timestampSinceVersion() {
            return 0;
        }

        public static int timestampEncodingOffset() {
            return 32;
        }

        public static int timestampEncodingLength() {
            return 8;
        }

        public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long timestampNullValue() {
            return Long.MIN_VALUE;
        }

        public static long timestampMinValue() {
            return -9223372036854775807L;
        }

        public static long timestampMaxValue() {
            return Long.MAX_VALUE;
        }

        public SnapshotsEncoder timestamp(long value) {
            this.buffer.putLong(this.offset + 32, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int serviceIdId() {
            return 15;
        }

        public static int serviceIdSinceVersion() {
            return 0;
        }

        public static int serviceIdEncodingOffset() {
            return 40;
        }

        public static int serviceIdEncodingLength() {
            return 4;
        }

        public static String serviceIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int serviceIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int serviceIdMinValue() {
            return -2147483647;
        }

        public static int serviceIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public SnapshotsEncoder serviceId(int value) {
            this.buffer.putInt(this.offset + 40, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }
    }
}

