/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class CloseSessionDecoder {
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 30;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final CloseSessionDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 8;
    }

    public int sbeTemplateId() {
        return 30;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 12;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public CloseSessionDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public CloseSessionDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (30 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public CloseSessionDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int clusterSessionIdId() {
        return 1;
    }

    public static int clusterSessionIdSinceVersion() {
        return 0;
    }

    public static int clusterSessionIdEncodingOffset() {
        return 0;
    }

    public static int clusterSessionIdEncodingLength() {
        return 8;
    }

    public static String clusterSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long clusterSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long clusterSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long clusterSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long clusterSessionId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        CloseSessionDecoder decoder = new CloseSessionDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[CloseSession](sbeTemplateId=");
        builder.append(30);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 12) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(12);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 8) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(8);
        builder.append("):");
        builder.append("clusterSessionId=");
        builder.append(this.clusterSessionId());
        this.limit(originalLimit);
        return builder;
    }

    public CloseSessionDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

