/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class HeartbeatRequestDecoder {
    public static final int BLOCK_LENGTH = 12;
    public static final int TEMPLATE_ID = 79;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final HeartbeatRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 12;
    }

    public int sbeTemplateId() {
        return 79;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 12;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public HeartbeatRequestDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public HeartbeatRequestDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (79 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public HeartbeatRequestDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int correlationIdId() {
        return 1;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 0;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int responseStreamIdId() {
        return 2;
    }

    public static int responseStreamIdSinceVersion() {
        return 0;
    }

    public static int responseStreamIdEncodingOffset() {
        return 8;
    }

    public static int responseStreamIdEncodingLength() {
        return 4;
    }

    public static String responseStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int responseStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int responseStreamIdMinValue() {
        return -2147483647;
    }

    public static int responseStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int responseStreamId() {
        return this.buffer.getInt(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int responseChannelId() {
        return 4;
    }

    public static int responseChannelSinceVersion() {
        return 0;
    }

    public static String responseChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String responseChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int responseChannelHeaderLength() {
        return 4;
    }

    public int responseChannelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipResponseChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getResponseChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getResponseChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapResponseChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String responseChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getResponseChannel(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public static int encodedCredentialsId() {
        return 5;
    }

    public static int encodedCredentialsSinceVersion() {
        return 0;
    }

    public static String encodedCredentialsMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int encodedCredentialsHeaderLength() {
        return 4;
    }

    public int encodedCredentialsLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipEncodedCredentials() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getEncodedCredentials(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getEncodedCredentials(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapEncodedCredentials(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        HeartbeatRequestDecoder decoder = new HeartbeatRequestDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[HeartbeatRequest](sbeTemplateId=");
        builder.append(79);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 12) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(12);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 12) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(12);
        builder.append("):");
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("responseStreamId=");
        builder.append(this.responseStreamId());
        builder.append('|');
        builder.append("responseChannel=");
        builder.append('\'');
        this.getResponseChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("encodedCredentials=");
        builder.append(this.skipEncodedCredentials()).append(" bytes of raw data");
        this.limit(originalLimit);
        return builder;
    }

    public HeartbeatRequestDecoder sbeSkip() {
        this.sbeRewind();
        this.skipResponseChannel();
        this.skipEncodedCredentials();
        return this;
    }
}

