/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.ClusterTimeUnit;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class NewLeadershipTermEventDecoder {
    public static final int BLOCK_LENGTH = 48;
    public static final int TEMPLATE_ID = 24;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final NewLeadershipTermEventDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 48;
    }

    public int sbeTemplateId() {
        return 24;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 12;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public NewLeadershipTermEventDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public NewLeadershipTermEventDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (24 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public NewLeadershipTermEventDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int leadershipTermIdId() {
        return 1;
    }

    public static int leadershipTermIdSinceVersion() {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset() {
        return 0;
    }

    public static int leadershipTermIdEncodingLength() {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long leadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long leadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long leadershipTermId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int logPositionId() {
        return 2;
    }

    public static int logPositionSinceVersion() {
        return 0;
    }

    public static int logPositionEncodingOffset() {
        return 8;
    }

    public static int logPositionEncodingLength() {
        return 8;
    }

    public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long logPosition() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int timestampId() {
        return 3;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 16;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long timestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timestampMinValue() {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public long timestamp() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int termBaseLogPositionId() {
        return 4;
    }

    public static int termBaseLogPositionSinceVersion() {
        return 0;
    }

    public static int termBaseLogPositionEncodingOffset() {
        return 24;
    }

    public static int termBaseLogPositionEncodingLength() {
        return 8;
    }

    public static String termBaseLogPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long termBaseLogPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long termBaseLogPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long termBaseLogPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long termBaseLogPosition() {
        return this.buffer.getLong(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static int leaderMemberIdId() {
        return 5;
    }

    public static int leaderMemberIdSinceVersion() {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset() {
        return 32;
    }

    public static int leaderMemberIdEncodingLength() {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int leaderMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int leaderMemberIdMinValue() {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int leaderMemberId() {
        return this.buffer.getInt(this.offset + 32, ByteOrder.LITTLE_ENDIAN);
    }

    public static int logSessionIdId() {
        return 6;
    }

    public static int logSessionIdSinceVersion() {
        return 0;
    }

    public static int logSessionIdEncodingOffset() {
        return 36;
    }

    public static int logSessionIdEncodingLength() {
        return 4;
    }

    public static String logSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int logSessionIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int logSessionIdMinValue() {
        return -2147483647;
    }

    public static int logSessionIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int logSessionId() {
        return this.buffer.getInt(this.offset + 36, ByteOrder.LITTLE_ENDIAN);
    }

    public static int timeUnitId() {
        return 7;
    }

    public static int timeUnitSinceVersion() {
        return 4;
    }

    public static int timeUnitEncodingOffset() {
        return 40;
    }

    public static int timeUnitEncodingLength() {
        return 4;
    }

    public static String timeUnitMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public int timeUnitRaw() {
        if (this.parentMessage.actingVersion < 4) {
            return Integer.MIN_VALUE;
        }
        return this.buffer.getInt(this.offset + 40, ByteOrder.LITTLE_ENDIAN);
    }

    public ClusterTimeUnit timeUnit() {
        if (this.parentMessage.actingVersion < 4) {
            return ClusterTimeUnit.NULL_VAL;
        }
        return ClusterTimeUnit.get(this.buffer.getInt(this.offset + 40, ByteOrder.LITTLE_ENDIAN));
    }

    public static int appVersionId() {
        return 8;
    }

    public static int appVersionSinceVersion() {
        return 4;
    }

    public static int appVersionEncodingOffset() {
        return 44;
    }

    public static int appVersionEncodingLength() {
        return 4;
    }

    public static String appVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int appVersionNullValue() {
        return 0;
    }

    public static int appVersionMinValue() {
        return 1;
    }

    public static int appVersionMaxValue() {
        return 0xFFFFFF;
    }

    public int appVersion() {
        if (this.parentMessage.actingVersion < 4) {
            return 0;
        }
        return this.buffer.getInt(this.offset + 44, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        NewLeadershipTermEventDecoder decoder = new NewLeadershipTermEventDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[NewLeadershipTermEvent](sbeTemplateId=");
        builder.append(24);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 12) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(12);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 48) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(48);
        builder.append("):");
        builder.append("leadershipTermId=");
        builder.append(this.leadershipTermId());
        builder.append('|');
        builder.append("logPosition=");
        builder.append(this.logPosition());
        builder.append('|');
        builder.append("timestamp=");
        builder.append(this.timestamp());
        builder.append('|');
        builder.append("termBaseLogPosition=");
        builder.append(this.termBaseLogPosition());
        builder.append('|');
        builder.append("leaderMemberId=");
        builder.append(this.leaderMemberId());
        builder.append('|');
        builder.append("logSessionId=");
        builder.append(this.logSessionId());
        builder.append('|');
        builder.append("timeUnit=");
        builder.append((Object)this.timeUnit());
        builder.append('|');
        builder.append("appVersion=");
        builder.append(this.appVersion());
        this.limit(originalLimit);
        return builder;
    }

    public NewLeadershipTermEventDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

