/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.EventCode;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class SessionEventDecoder {
    public static final int BLOCK_LENGTH = 36;
    public static final int TEMPLATE_ID = 2;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SessionEventDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 36;
    }

    public int sbeTemplateId() {
        return 2;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 12;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public SessionEventDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public SessionEventDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (2 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public SessionEventDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int clusterSessionIdId() {
        return 1;
    }

    public static int clusterSessionIdSinceVersion() {
        return 0;
    }

    public static int clusterSessionIdEncodingOffset() {
        return 0;
    }

    public static int clusterSessionIdEncodingLength() {
        return 8;
    }

    public static String clusterSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long clusterSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long clusterSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long clusterSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long clusterSessionId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int leadershipTermIdId() {
        return 3;
    }

    public static int leadershipTermIdSinceVersion() {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset() {
        return 16;
    }

    public static int leadershipTermIdEncodingLength() {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long leadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long leadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long leadershipTermId() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int leaderMemberIdId() {
        return 4;
    }

    public static int leaderMemberIdSinceVersion() {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset() {
        return 24;
    }

    public static int leaderMemberIdEncodingLength() {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int leaderMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int leaderMemberIdMinValue() {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int leaderMemberId() {
        return this.buffer.getInt(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static int codeId() {
        return 5;
    }

    public static int codeSinceVersion() {
        return 0;
    }

    public static int codeEncodingOffset() {
        return 28;
    }

    public static int codeEncodingLength() {
        return 4;
    }

    public static String codeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public int codeRaw() {
        return this.buffer.getInt(this.offset + 28, ByteOrder.LITTLE_ENDIAN);
    }

    public EventCode code() {
        return EventCode.get(this.buffer.getInt(this.offset + 28, ByteOrder.LITTLE_ENDIAN));
    }

    public static int versionId() {
        return 6;
    }

    public static int versionSinceVersion() {
        return 6;
    }

    public static int versionEncodingOffset() {
        return 32;
    }

    public static int versionEncodingLength() {
        return 4;
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int versionNullValue() {
        return 0;
    }

    public static int versionMinValue() {
        return 1;
    }

    public static int versionMaxValue() {
        return 0xFFFFFF;
    }

    public int version() {
        if (this.parentMessage.actingVersion < 6) {
            return 0;
        }
        return this.buffer.getInt(this.offset + 32, ByteOrder.LITTLE_ENDIAN);
    }

    public static int detailId() {
        return 7;
    }

    public static int detailSinceVersion() {
        return 0;
    }

    public static String detailCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String detailMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int detailHeaderLength() {
        return 4;
    }

    public int detailLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipDetail() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getDetail(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getDetail(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapDetail(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String detail() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getDetail(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        SessionEventDecoder decoder = new SessionEventDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[SessionEvent](sbeTemplateId=");
        builder.append(2);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 12) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(12);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 36) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(36);
        builder.append("):");
        builder.append("clusterSessionId=");
        builder.append(this.clusterSessionId());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("leadershipTermId=");
        builder.append(this.leadershipTermId());
        builder.append('|');
        builder.append("leaderMemberId=");
        builder.append(this.leaderMemberId());
        builder.append('|');
        builder.append("code=");
        builder.append((Object)this.code());
        builder.append('|');
        builder.append("version=");
        builder.append(this.version());
        builder.append('|');
        builder.append("detail=");
        builder.append('\'');
        this.getDetail(builder);
        builder.append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public SessionEventDecoder sbeSkip() {
        this.sbeRewind();
        this.skipDetail();
        return this;
    }
}

