/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs.mark;

import io.aeron.cluster.codecs.mark.ClusterComponentType;
import io.aeron.cluster.codecs.mark.MessageHeaderDecoder;
import io.aeron.cluster.codecs.mark.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class MarkFileHeaderDecoder {
    public static final int BLOCK_LENGTH = 128;
    public static final int TEMPLATE_ID = 200;
    public static final int SCHEMA_ID = 110;
    public static final int SCHEMA_VERSION = 1;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final MarkFileHeaderDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 128;
    }

    public int sbeTemplateId() {
        return 200;
    }

    public int sbeSchemaId() {
        return 110;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public MarkFileHeaderDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public MarkFileHeaderDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (200 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public MarkFileHeaderDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int versionId() {
        return 1;
    }

    public static int versionSinceVersion() {
        return 0;
    }

    public static int versionEncodingOffset() {
        return 0;
    }

    public static int versionEncodingLength() {
        return 4;
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int versionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int versionMinValue() {
        return -2147483647;
    }

    public static int versionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int version() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int componentTypeId() {
        return 2;
    }

    public static int componentTypeSinceVersion() {
        return 0;
    }

    public static int componentTypeEncodingOffset() {
        return 4;
    }

    public static int componentTypeEncodingLength() {
        return 4;
    }

    public static String componentTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public int componentTypeRaw() {
        return this.buffer.getInt(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public ClusterComponentType componentType() {
        return ClusterComponentType.get(this.buffer.getInt(this.offset + 4, ByteOrder.LITTLE_ENDIAN));
    }

    public static int activityTimestampId() {
        return 3;
    }

    public static int activityTimestampSinceVersion() {
        return 0;
    }

    public static int activityTimestampEncodingOffset() {
        return 8;
    }

    public static int activityTimestampEncodingLength() {
        return 8;
    }

    public static String activityTimestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long activityTimestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long activityTimestampMinValue() {
        return -9223372036854775807L;
    }

    public static long activityTimestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public long activityTimestamp() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int startTimestampId() {
        return 4;
    }

    public static int startTimestampSinceVersion() {
        return 0;
    }

    public static int startTimestampEncodingOffset() {
        return 16;
    }

    public static int startTimestampEncodingLength() {
        return 8;
    }

    public static String startTimestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long startTimestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long startTimestampMinValue() {
        return -9223372036854775807L;
    }

    public static long startTimestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public long startTimestamp() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int pidId() {
        return 5;
    }

    public static int pidSinceVersion() {
        return 0;
    }

    public static int pidEncodingOffset() {
        return 24;
    }

    public static int pidEncodingLength() {
        return 8;
    }

    public static String pidMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long pidNullValue() {
        return Long.MIN_VALUE;
    }

    public static long pidMinValue() {
        return -9223372036854775807L;
    }

    public static long pidMaxValue() {
        return Long.MAX_VALUE;
    }

    public long pid() {
        return this.buffer.getLong(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static int candidateTermIdId() {
        return 6;
    }

    public static int candidateTermIdSinceVersion() {
        return 0;
    }

    public static int candidateTermIdEncodingOffset() {
        return 32;
    }

    public static int candidateTermIdEncodingLength() {
        return 8;
    }

    public static String candidateTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long candidateTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long candidateTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long candidateTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long candidateTermId() {
        return this.buffer.getLong(this.offset + 32, ByteOrder.LITTLE_ENDIAN);
    }

    public static int archiveStreamIdId() {
        return 7;
    }

    public static int archiveStreamIdSinceVersion() {
        return 0;
    }

    public static int archiveStreamIdEncodingOffset() {
        return 40;
    }

    public static int archiveStreamIdEncodingLength() {
        return 4;
    }

    public static String archiveStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int archiveStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int archiveStreamIdMinValue() {
        return -2147483647;
    }

    public static int archiveStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int archiveStreamId() {
        return this.buffer.getInt(this.offset + 40, ByteOrder.LITTLE_ENDIAN);
    }

    public static int serviceStreamIdId() {
        return 8;
    }

    public static int serviceStreamIdSinceVersion() {
        return 0;
    }

    public static int serviceStreamIdEncodingOffset() {
        return 44;
    }

    public static int serviceStreamIdEncodingLength() {
        return 4;
    }

    public static String serviceStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int serviceStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int serviceStreamIdMinValue() {
        return -2147483647;
    }

    public static int serviceStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int serviceStreamId() {
        return this.buffer.getInt(this.offset + 44, ByteOrder.LITTLE_ENDIAN);
    }

    public static int consensusModuleStreamIdId() {
        return 9;
    }

    public static int consensusModuleStreamIdSinceVersion() {
        return 0;
    }

    public static int consensusModuleStreamIdEncodingOffset() {
        return 48;
    }

    public static int consensusModuleStreamIdEncodingLength() {
        return 4;
    }

    public static String consensusModuleStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int consensusModuleStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int consensusModuleStreamIdMinValue() {
        return -2147483647;
    }

    public static int consensusModuleStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int consensusModuleStreamId() {
        return this.buffer.getInt(this.offset + 48, ByteOrder.LITTLE_ENDIAN);
    }

    public static int ingressStreamIdId() {
        return 10;
    }

    public static int ingressStreamIdSinceVersion() {
        return 0;
    }

    public static int ingressStreamIdEncodingOffset() {
        return 52;
    }

    public static int ingressStreamIdEncodingLength() {
        return 4;
    }

    public static String ingressStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int ingressStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int ingressStreamIdMinValue() {
        return -2147483647;
    }

    public static int ingressStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int ingressStreamId() {
        return this.buffer.getInt(this.offset + 52, ByteOrder.LITTLE_ENDIAN);
    }

    public static int memberIdId() {
        return 11;
    }

    public static int memberIdSinceVersion() {
        return 0;
    }

    public static int memberIdEncodingOffset() {
        return 56;
    }

    public static int memberIdEncodingLength() {
        return 4;
    }

    public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int memberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int memberIdMinValue() {
        return -2147483647;
    }

    public static int memberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int memberId() {
        return this.buffer.getInt(this.offset + 56, ByteOrder.LITTLE_ENDIAN);
    }

    public static int serviceIdId() {
        return 12;
    }

    public static int serviceIdSinceVersion() {
        return 0;
    }

    public static int serviceIdEncodingOffset() {
        return 60;
    }

    public static int serviceIdEncodingLength() {
        return 4;
    }

    public static String serviceIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int serviceIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int serviceIdMinValue() {
        return -2147483647;
    }

    public static int serviceIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int serviceId() {
        return this.buffer.getInt(this.offset + 60, ByteOrder.LITTLE_ENDIAN);
    }

    public static int headerLengthId() {
        return 13;
    }

    public static int headerLengthSinceVersion() {
        return 0;
    }

    public static int headerLengthEncodingOffset() {
        return 64;
    }

    public static int headerLengthEncodingLength() {
        return 4;
    }

    public static String headerLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int headerLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int headerLengthMinValue() {
        return -2147483647;
    }

    public static int headerLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int headerLength() {
        return this.buffer.getInt(this.offset + 64, ByteOrder.LITTLE_ENDIAN);
    }

    public static int errorBufferLengthId() {
        return 14;
    }

    public static int errorBufferLengthSinceVersion() {
        return 0;
    }

    public static int errorBufferLengthEncodingOffset() {
        return 68;
    }

    public static int errorBufferLengthEncodingLength() {
        return 4;
    }

    public static String errorBufferLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int errorBufferLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int errorBufferLengthMinValue() {
        return -2147483647;
    }

    public static int errorBufferLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int errorBufferLength() {
        return this.buffer.getInt(this.offset + 68, ByteOrder.LITTLE_ENDIAN);
    }

    public static int clusterIdId() {
        return 15;
    }

    public static int clusterIdSinceVersion() {
        return 0;
    }

    public static int clusterIdEncodingOffset() {
        return 72;
    }

    public static int clusterIdEncodingLength() {
        return 4;
    }

    public static String clusterIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int clusterIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int clusterIdMinValue() {
        return -2147483647;
    }

    public static int clusterIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int clusterId() {
        return this.buffer.getInt(this.offset + 72, ByteOrder.LITTLE_ENDIAN);
    }

    public static int aeronDirectoryId() {
        return 16;
    }

    public static int aeronDirectorySinceVersion() {
        return 0;
    }

    public static String aeronDirectoryCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String aeronDirectoryMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int aeronDirectoryHeaderLength() {
        return 4;
    }

    public int aeronDirectoryLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipAeronDirectory() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getAeronDirectory(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getAeronDirectory(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapAeronDirectory(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String aeronDirectory() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getAeronDirectory(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public static int controlChannelId() {
        return 17;
    }

    public static int controlChannelSinceVersion() {
        return 0;
    }

    public static String controlChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String controlChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int controlChannelHeaderLength() {
        return 4;
    }

    public int controlChannelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipControlChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getControlChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getControlChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapControlChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String controlChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getControlChannel(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public static int ingressChannelId() {
        return 18;
    }

    public static int ingressChannelSinceVersion() {
        return 0;
    }

    public static String ingressChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String ingressChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int ingressChannelHeaderLength() {
        return 4;
    }

    public int ingressChannelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipIngressChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getIngressChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getIngressChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapIngressChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String ingressChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getIngressChannel(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public static int serviceNameId() {
        return 19;
    }

    public static int serviceNameSinceVersion() {
        return 0;
    }

    public static String serviceNameCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String serviceNameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int serviceNameHeaderLength() {
        return 4;
    }

    public int serviceNameLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipServiceName() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getServiceName(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getServiceName(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapServiceName(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String serviceName() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getServiceName(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public static int authenticatorId() {
        return 20;
    }

    public static int authenticatorSinceVersion() {
        return 0;
    }

    public static String authenticatorCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String authenticatorMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int authenticatorHeaderLength() {
        return 4;
    }

    public int authenticatorLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipAuthenticator() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getAuthenticator(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getAuthenticator(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapAuthenticator(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String authenticator() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getAuthenticator(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public static int servicesClusterDirId() {
        return 21;
    }

    public static int servicesClusterDirSinceVersion() {
        return 1;
    }

    public static String servicesClusterDirCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String servicesClusterDirMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int servicesClusterDirHeaderLength() {
        return 4;
    }

    public int servicesClusterDirLength() {
        if (this.parentMessage.actingVersion < 1) {
            return 0;
        }
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipServicesClusterDir() {
        if (this.parentMessage.actingVersion < 1) {
            return 0;
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getServicesClusterDir(MutableDirectBuffer dst, int dstOffset, int length) {
        if (this.parentMessage.actingVersion < 1) {
            return 0;
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getServicesClusterDir(byte[] dst, int dstOffset, int length) {
        if (this.parentMessage.actingVersion < 1) {
            return 0;
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapServicesClusterDir(DirectBuffer wrapBuffer) {
        if (this.parentMessage.actingVersion < 1) {
            wrapBuffer.wrap(this.buffer, this.offset, 0);
            return;
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String servicesClusterDir() {
        if (this.parentMessage.actingVersion < 1) {
            return "";
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getServicesClusterDir(Appendable appendable) {
        if (this.parentMessage.actingVersion < 1) {
            return 0;
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        MarkFileHeaderDecoder decoder = new MarkFileHeaderDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[MarkFileHeader](sbeTemplateId=");
        builder.append(200);
        builder.append("|sbeSchemaId=");
        builder.append(110);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 128) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(128);
        builder.append("):");
        builder.append("version=");
        builder.append(this.version());
        builder.append('|');
        builder.append("componentType=");
        builder.append((Object)this.componentType());
        builder.append('|');
        builder.append("activityTimestamp=");
        builder.append(this.activityTimestamp());
        builder.append('|');
        builder.append("startTimestamp=");
        builder.append(this.startTimestamp());
        builder.append('|');
        builder.append("pid=");
        builder.append(this.pid());
        builder.append('|');
        builder.append("candidateTermId=");
        builder.append(this.candidateTermId());
        builder.append('|');
        builder.append("archiveStreamId=");
        builder.append(this.archiveStreamId());
        builder.append('|');
        builder.append("serviceStreamId=");
        builder.append(this.serviceStreamId());
        builder.append('|');
        builder.append("consensusModuleStreamId=");
        builder.append(this.consensusModuleStreamId());
        builder.append('|');
        builder.append("ingressStreamId=");
        builder.append(this.ingressStreamId());
        builder.append('|');
        builder.append("memberId=");
        builder.append(this.memberId());
        builder.append('|');
        builder.append("serviceId=");
        builder.append(this.serviceId());
        builder.append('|');
        builder.append("headerLength=");
        builder.append(this.headerLength());
        builder.append('|');
        builder.append("errorBufferLength=");
        builder.append(this.errorBufferLength());
        builder.append('|');
        builder.append("clusterId=");
        builder.append(this.clusterId());
        builder.append('|');
        builder.append("aeronDirectory=");
        builder.append('\'');
        this.getAeronDirectory(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("controlChannel=");
        builder.append('\'');
        this.getControlChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("ingressChannel=");
        builder.append('\'');
        this.getIngressChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("serviceName=");
        builder.append('\'');
        this.getServiceName(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("authenticator=");
        builder.append('\'');
        this.getAuthenticator(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("servicesClusterDir=");
        builder.append('\'');
        this.getServicesClusterDir(builder);
        builder.append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public MarkFileHeaderDecoder sbeSkip() {
        this.sbeRewind();
        this.skipAeronDirectory();
        this.skipControlChannel();
        this.skipIngressChannel();
        this.skipServiceName();
        this.skipAuthenticator();
        this.skipServicesClusterDir();
        return this;
    }
}

