/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ErrorCode;
import io.aeron.command.ClientTimeoutFlyweight;
import io.aeron.command.CounterUpdateFlyweight;
import io.aeron.command.ErrorResponseFlyweight;
import io.aeron.command.ImageBuffersReadyFlyweight;
import io.aeron.command.ImageMessageFlyweight;
import io.aeron.command.OperationSucceededFlyweight;
import io.aeron.command.PublicationBuffersReadyFlyweight;
import io.aeron.command.SubscriptionReadyFlyweight;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.broadcast.BroadcastTransmitter;

final class ClientProxy {
    private final MutableDirectBuffer buffer = new ExpandableArrayBuffer(1024);
    private final BroadcastTransmitter transmitter;
    private final ErrorResponseFlyweight errorResponse = new ErrorResponseFlyweight();
    private final PublicationBuffersReadyFlyweight publicationReady = new PublicationBuffersReadyFlyweight();
    private final SubscriptionReadyFlyweight subscriptionReady = new SubscriptionReadyFlyweight();
    private final ImageBuffersReadyFlyweight imageReady = new ImageBuffersReadyFlyweight();
    private final OperationSucceededFlyweight operationSucceeded = new OperationSucceededFlyweight();
    private final ImageMessageFlyweight imageMessage = new ImageMessageFlyweight();
    private final CounterUpdateFlyweight counterUpdate = new CounterUpdateFlyweight();
    private final ClientTimeoutFlyweight clientTimeout = new ClientTimeoutFlyweight();

    ClientProxy(BroadcastTransmitter transmitter) {
        this.transmitter = transmitter;
        this.errorResponse.wrap(this.buffer, 0);
        this.imageReady.wrap(this.buffer, 0);
        this.publicationReady.wrap(this.buffer, 0);
        this.subscriptionReady.wrap(this.buffer, 0);
        this.operationSucceeded.wrap(this.buffer, 0);
        this.imageMessage.wrap(this.buffer, 0);
        this.counterUpdate.wrap(this.buffer, 0);
        this.clientTimeout.wrap(this.buffer, 0);
    }

    void onError(long correlationId, ErrorCode errorCode, String errorMessage) {
        this.errorResponse.offendingCommandCorrelationId(correlationId).errorCode(errorCode).errorMessage(errorMessage);
        this.transmit(3841, this.buffer, 0, this.errorResponse.length());
    }

    void onAvailableImage(long correlationId, int streamId, int sessionId, long subscriptionRegistrationId, int positionCounterId, String logFileName, String sourceIdentity) {
        this.imageReady.correlationId(correlationId).sessionId(sessionId).streamId(streamId).subscriptionRegistrationId(subscriptionRegistrationId).subscriberPositionId(positionCounterId).logFileName(logFileName).sourceIdentity(sourceIdentity);
        this.transmit(3842, this.buffer, 0, this.imageReady.length());
    }

    void onPublicationReady(long correlationId, long registrationId, int streamId, int sessionId, String logFileName, int positionCounterId, int channelStatusCounterId, boolean isExclusive) {
        this.publicationReady.correlationId(correlationId).registrationId(registrationId).sessionId(sessionId).streamId(streamId).publicationLimitCounterId(positionCounterId).channelStatusCounterId(channelStatusCounterId).logFileName(logFileName);
        int msgTypeId = isExclusive ? 3846 : 3843;
        this.transmit(msgTypeId, this.buffer, 0, this.publicationReady.length());
    }

    void onSubscriptionReady(long correlationId, int channelStatusCounterId) {
        this.subscriptionReady.correlationId(correlationId).channelStatusCounterId(channelStatusCounterId);
        this.transmit(3847, this.buffer, 0, 12);
    }

    void operationSucceeded(long correlationId) {
        this.operationSucceeded.correlationId(correlationId);
        this.transmit(3844, this.buffer, 0, 8);
    }

    void onUnavailableImage(long correlationId, long subscriptionRegistrationId, int streamId, String channel) {
        this.imageMessage.correlationId(correlationId).subscriptionRegistrationId(subscriptionRegistrationId).streamId(streamId).channel(channel);
        this.transmit(3845, this.buffer, 0, this.imageMessage.length());
    }

    void onCounterReady(long correlationId, int counterId) {
        this.counterUpdate.correlationId(correlationId).counterId(counterId);
        this.transmit(3848, this.buffer, 0, 12);
    }

    void onUnavailableCounter(long registrationId, int counterId) {
        this.counterUpdate.correlationId(registrationId).counterId(counterId);
        this.transmit(3849, this.buffer, 0, 12);
    }

    void onClientTimeout(long clientId) {
        this.clientTimeout.clientId(clientId);
        this.transmit(3850, this.buffer, 0, 8);
    }

    private void transmit(int msgTypeId, DirectBuffer buffer, int index, int length) {
        this.transmitter.transmit(msgTypeId, buffer, index, length);
    }

    public String toString() {
        return "ClientProxy{}";
    }
}

