/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.PublicationImage;
import io.aeron.driver.Receiver;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.media.UdpChannel;
import java.net.InetSocketAddress;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.QueuedPipe;
import org.agrona.concurrent.status.AtomicCounter;

final class ReceiverProxy {
    private final ThreadingMode threadingMode;
    private final QueuedPipe<Runnable> commandQueue;
    private final AtomicCounter failCount;
    private Receiver receiver;

    ReceiverProxy(ThreadingMode threadingMode, QueuedPipe<Runnable> commandQueue, AtomicCounter failCount) {
        this.threadingMode = threadingMode;
        this.commandQueue = commandQueue;
        this.failCount = failCount;
    }

    public String toString() {
        return "ReceiverProxy{threadingMode=" + (Object)((Object)this.threadingMode) + ", failCount=" + this.failCount + '}';
    }

    void receiver(Receiver receiver) {
        this.receiver = receiver;
    }

    Receiver receiver() {
        return this.receiver;
    }

    boolean isApplyingBackpressure() {
        return this.commandQueue.remainingCapacity() < 1;
    }

    void addSubscription(ReceiveChannelEndpoint mediaEndpoint, int streamId) {
        if (this.notConcurrent()) {
            this.receiver.onAddSubscription(mediaEndpoint, streamId);
        } else {
            this.offer(() -> this.receiver.onAddSubscription(mediaEndpoint, streamId));
        }
    }

    void addSubscription(ReceiveChannelEndpoint mediaEndpoint, int streamId, int sessionId) {
        if (this.notConcurrent()) {
            this.receiver.onAddSubscription(mediaEndpoint, streamId, sessionId);
        } else {
            this.offer(() -> this.receiver.onAddSubscription(mediaEndpoint, streamId, sessionId));
        }
    }

    void removeSubscription(ReceiveChannelEndpoint mediaEndpoint, int streamId) {
        if (this.notConcurrent()) {
            this.receiver.onRemoveSubscription(mediaEndpoint, streamId);
        } else {
            this.offer(() -> this.receiver.onRemoveSubscription(mediaEndpoint, streamId));
        }
    }

    void removeSubscription(ReceiveChannelEndpoint mediaEndpoint, int streamId, int sessionId) {
        if (this.notConcurrent()) {
            this.receiver.onRemoveSubscription(mediaEndpoint, streamId, sessionId);
        } else {
            this.offer(() -> this.receiver.onRemoveSubscription(mediaEndpoint, streamId, sessionId));
        }
    }

    void newPublicationImage(ReceiveChannelEndpoint channelEndpoint, PublicationImage image) {
        if (this.notConcurrent()) {
            this.receiver.onNewPublicationImage(channelEndpoint, image);
        } else {
            this.offer(() -> this.receiver.onNewPublicationImage(channelEndpoint, image));
        }
    }

    void registerReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        if (this.notConcurrent()) {
            this.receiver.onRegisterReceiveChannelEndpoint(channelEndpoint);
        } else {
            this.offer(() -> this.receiver.onRegisterReceiveChannelEndpoint(channelEndpoint));
        }
    }

    void closeReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        if (this.notConcurrent()) {
            this.receiver.onCloseReceiveChannelEndpoint(channelEndpoint);
        } else {
            this.offer(() -> this.receiver.onCloseReceiveChannelEndpoint(channelEndpoint));
        }
    }

    void removeCoolDown(ReceiveChannelEndpoint channelEndpoint, int sessionId, int streamId) {
        if (this.notConcurrent()) {
            this.receiver.onRemoveCoolDown(channelEndpoint, sessionId, streamId);
        } else {
            this.offer(() -> this.receiver.onRemoveCoolDown(channelEndpoint, sessionId, streamId));
        }
    }

    void addDestination(ReceiveChannelEndpoint channelEndpoint, ReceiveDestinationTransport transport) {
        if (this.notConcurrent()) {
            this.receiver.onAddDestination(channelEndpoint, transport);
        } else {
            this.offer(() -> this.receiver.onAddDestination(channelEndpoint, transport));
        }
    }

    void removeDestination(ReceiveChannelEndpoint channelEndpoint, UdpChannel udpChannel) {
        if (this.notConcurrent()) {
            this.receiver.onRemoveDestination(channelEndpoint, udpChannel);
        } else {
            this.offer(() -> this.receiver.onRemoveDestination(channelEndpoint, udpChannel));
        }
    }

    void onResolutionChange(ReceiveChannelEndpoint channelEndpoint, UdpChannel udpChannel, InetSocketAddress newAddress) {
        if (this.notConcurrent()) {
            this.receiver.onResolutionChange(channelEndpoint, udpChannel, newAddress);
        } else {
            this.offer(() -> this.receiver.onResolutionChange(channelEndpoint, udpChannel, newAddress));
        }
    }

    private boolean notConcurrent() {
        return this.threadingMode == ThreadingMode.SHARED || this.threadingMode == ThreadingMode.INVOKER;
    }

    private void offer(Runnable cmd) {
        while (!this.commandQueue.offer(cmd)) {
            if (!this.failCount.isClosed()) {
                this.failCount.increment();
            }
            Thread.yield();
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new AgentTerminationException("interrupted");
        }
    }
}

