/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.FlowControl;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.UdpChannel;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.SetupFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import org.agrona.concurrent.status.CountersManager;

public class UnicastFlowControl
implements FlowControl {
    public static final UnicastFlowControl INSTANCE = new UnicastFlowControl();
    private static final int RETRANSMIT_RECEIVER_WINDOW_MULTIPLE = 16;

    @Override
    public long onStatusMessage(StatusMessageFlyweight flyweight, InetSocketAddress receiverAddress, long senderLimit, int initialTermId, int positionBitsToShift, long timeNs) {
        long position = LogBufferDescriptor.computePosition(flyweight.consumptionTermId(), flyweight.consumptionTermOffset(), positionBitsToShift, initialTermId);
        return Math.max(senderLimit, position + (long)flyweight.receiverWindowLength());
    }

    @Override
    public void onTriggerSendSetup(StatusMessageFlyweight flyweight, InetSocketAddress receiverAddress, long timeNs) {
    }

    @Override
    public long onSetup(SetupFlyweight flyweight, long senderLimit, long senderPosition, int positionBitsToShift, long timeNs) {
        return senderLimit;
    }

    @Override
    public void initialize(MediaDriver.Context context, CountersManager countersManager, UdpChannel udpChannel, int streamId, int sessionId, long registrationId, int initialTermId, int termBufferLength) {
    }

    @Override
    public void close() {
    }

    @Override
    public long onIdle(long timeNs, long senderLimit, long senderPosition, boolean isEos) {
        return senderLimit;
    }

    @Override
    public boolean hasRequiredReceivers() {
        return true;
    }

    @Override
    public int maxRetransmissionLength(long resendPosition, int resendLength, int termBufferLength, int mtuLength) {
        int estimatedWindowLength = Configuration.receiverWindowLength(termBufferLength, 131072);
        return Math.min(16 * estimatedWindowLength, resendLength);
    }
}

