/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.ErrorCode;
import io.aeron.driver.DataPacketDispatcher;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.DataTransportPoller;
import io.aeron.driver.media.ImageConnection;
import io.aeron.driver.media.MultiRcvDestination;
import io.aeron.driver.media.ReceiveChannelEndpointRhsPadding;
import io.aeron.driver.media.ReceiveChannelEndpointThreadLocals;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ControlProtocolException;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import io.aeron.status.ChannelEndpointStatus;
import io.aeron.status.LocalSocketAddressStatus;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.TimeUnit;
import org.agrona.collections.Hashing;
import org.agrona.collections.Int2IntCounterMap;
import org.agrona.collections.Long2LongCounterMap;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

public class ReceiveChannelEndpoint
extends ReceiveChannelEndpointRhsPadding {
    static final long DESTINATION_ADDRESS_TIMEOUT = TimeUnit.SECONDS.toNanos(5L);
    private final DataPacketDispatcher dispatcher;
    private final ByteBuffer smBuffer;
    private final StatusMessageFlyweight statusMessageFlyweight;
    private final ByteBuffer nakBuffer;
    private final NakFlyweight nakFlyweight;
    private final ByteBuffer rttMeasurementBuffer;
    private final RttMeasurementFlyweight rttMeasurementFlyweight;
    private final AtomicCounter shortSends;
    private final AtomicCounter possibleTtlAsymmetry;
    private final AtomicCounter statusIndicator;
    private final Int2IntCounterMap refCountByStreamIdMap = new Int2IntCounterMap(0);
    private final Long2LongCounterMap refCountByStreamIdAndSessionIdMap = new Long2LongCounterMap(0L);
    private final MultiRcvDestination multiRcvDestination;
    private final CachedNanoClock cachedNanoClock;
    private final Long groupTag;
    private final boolean isChannelReceiveTimestampEnabled;
    private final EpochNanoClock channelReceiveTimestampClock;
    private final long receiverId;
    private InetSocketAddress currentControlAddress;
    private AtomicCounter localSocketAddressIndicator;
    private int imageRefCount;

    public ReceiveChannelEndpoint(UdpChannel udpChannel, DataPacketDispatcher dispatcher, AtomicCounter statusIndicator, MediaDriver.Context context) {
        super(udpChannel, udpChannel.remoteData(), udpChannel.remoteData(), null, context);
        this.dispatcher = dispatcher;
        this.statusIndicator = statusIndicator;
        this.shortSends = context.systemCounters().get(SystemCounterDescriptor.SHORT_SENDS);
        this.possibleTtlAsymmetry = context.systemCounters().get(SystemCounterDescriptor.POSSIBLE_TTL_ASYMMETRY);
        ReceiveChannelEndpointThreadLocals threadLocals = context.receiveChannelEndpointThreadLocals();
        this.smBuffer = threadLocals.statusMessageBuffer();
        this.statusMessageFlyweight = threadLocals.statusMessageFlyweight();
        this.nakBuffer = threadLocals.nakBuffer();
        this.nakFlyweight = threadLocals.nakFlyweight();
        this.rttMeasurementBuffer = threadLocals.rttMeasurementBuffer();
        this.rttMeasurementFlyweight = threadLocals.rttMeasurementFlyweight();
        this.cachedNanoClock = context.receiverCachedNanoClock();
        this.timeOfLastActivityNs = this.cachedNanoClock.nanoTime();
        this.receiverId = threadLocals.nextReceiverId();
        this.groupTag = null == udpChannel.groupTag() ? context.receiverGroupTag() : udpChannel.groupTag();
        this.multiRcvDestination = udpChannel.isManualControlMode() ? new MultiRcvDestination() : null;
        this.currentControlAddress = udpChannel.localControl();
        this.channelReceiveTimestampClock = context.channelReceiveTimestampClock();
        this.isChannelReceiveTimestampEnabled = udpChannel.isChannelReceiveTimestampEnabled();
    }

    public void localSocketAddressIndicator(AtomicCounter counter) {
        if (null != this.multiRcvDestination) {
            throw new IllegalStateException("local socket address indicator not used for MDS");
        }
        this.localSocketAddressIndicator = counter;
    }

    public int sendTo(ByteBuffer buffer, InetSocketAddress remoteAddress) {
        int remaining = buffer.remaining();
        int bytesSent = 0;
        try {
            if (null != this.sendDatagramChannel && this.sendDatagramChannel.isOpen()) {
                this.sendHook(buffer, remoteAddress);
                bytesSent = this.sendDatagramChannel.send(buffer, remoteAddress);
            }
        }
        catch (IOException ex) {
            ReceiveChannelEndpoint.sendError(remaining, ex, remoteAddress);
        }
        return bytesSent;
    }

    public String originalUriString() {
        return this.subscriptionUdpChannel().originalUriString();
    }

    public AtomicCounter statusIndicatorCounter() {
        return this.statusIndicator;
    }

    public void indicateActive() {
        long currentStatus = this.statusIndicator.get();
        if (currentStatus != 0L) {
            throw new AeronException("channel cannot be registered unless INITIALIZING: status=" + ChannelEndpointStatus.status(currentStatus));
        }
        if (null == this.multiRcvDestination) {
            String bindAddressAndPort = this.bindAddressAndPort();
            this.statusIndicator.appendToLabel(bindAddressAndPort);
            this.updateLocalSocketAddress(bindAddressAndPort);
        }
        this.statusIndicator.setOrdered(1L);
    }

    public void closeIndicators() {
        this.statusIndicator.close();
        if (null != this.localSocketAddressIndicator) {
            this.localSocketAddressIndicator.close();
        }
    }

    public void closeMultiRcvDestinationTransports(DataTransportPoller poller) {
        if (null != this.multiRcvDestination) {
            this.multiRcvDestination.closeTransports(poller);
        }
    }

    public void closeMultiRcvDestinationIndicators(DriverConductorProxy conductorProxy) {
        if (null != this.multiRcvDestination) {
            this.multiRcvDestination.closeIndicators(conductorProxy);
        }
    }

    public void openChannel(DriverConductorProxy conductorProxy) {
        if (null == this.multiRcvDestination) {
            if (conductorProxy.notConcurrent()) {
                this.openDatagramChannel(this.statusIndicator);
            } else {
                try {
                    this.openDatagramChannel(this.statusIndicator);
                }
                catch (Exception ex) {
                    conductorProxy.channelEndpointError(this.statusIndicator.id(), ex);
                    throw ex;
                }
            }
        }
    }

    public void possibleTtlAsymmetryEncountered() {
        this.possibleTtlAsymmetry.incrementOrdered();
    }

    public int incRefToStream(int streamId) {
        return this.refCountByStreamIdMap.incrementAndGet(streamId);
    }

    public int decRefToStream(int streamId) {
        int count = this.refCountByStreamIdMap.decrementAndGet(streamId);
        if (-1 == count) {
            this.refCountByStreamIdMap.remove(streamId);
            throw new IllegalStateException("unknown stream Id: " + streamId);
        }
        return count;
    }

    public long incRefToStreamAndSession(int streamId, int sessionId) {
        return this.refCountByStreamIdAndSessionIdMap.incrementAndGet(Hashing.compoundKey(streamId, sessionId));
    }

    public long decRefToStreamAndSession(int streamId, int sessionId) {
        long key = Hashing.compoundKey(streamId, sessionId);
        long count = this.refCountByStreamIdAndSessionIdMap.decrementAndGet(key);
        if (-1L == count) {
            this.refCountByStreamIdAndSessionIdMap.remove(key);
            throw new IllegalStateException("unknown stream Id + session Id: " + streamId + " " + sessionId);
        }
        return count;
    }

    public int distinctSubscriptionCount() {
        return this.refCountByStreamIdMap.size() + this.refCountByStreamIdAndSessionIdMap.size();
    }

    public boolean shouldBeClosed() {
        return this.refCountByStreamIdMap.isEmpty() && this.refCountByStreamIdAndSessionIdMap.isEmpty() && !this.statusIndicator.isClosed() && this.imageRefCount <= 0;
    }

    public boolean hasExplicitControl() {
        return this.udpChannel.hasExplicitControl();
    }

    public InetSocketAddress explicitControlAddress() {
        return this.udpChannel.hasExplicitControl() ? this.currentControlAddress : null;
    }

    public boolean hasDestinationControl() {
        return null != this.multiRcvDestination;
    }

    public void validateAllowsDestinationControl() {
        if (null == this.multiRcvDestination) {
            throw new ControlProtocolException(ErrorCode.INVALID_CHANNEL, "channel does not allow manual control");
        }
    }

    @Override
    public boolean isMulticast() {
        return this.isMulticast(0);
    }

    public boolean isMulticast(int transportIndex) {
        if (null != this.multiRcvDestination) {
            return this.multiRcvDestination.transport(transportIndex).isMulticast();
        }
        if (0 == transportIndex) {
            return super.isMulticast();
        }
        throw new IllegalStateException("isMulticast for unknown index " + transportIndex);
    }

    public UdpChannel subscriptionUdpChannel() {
        return this.udpChannel;
    }

    @Override
    public UdpChannel udpChannel() {
        return this.udpChannel(0);
    }

    public UdpChannel udpChannel(int transportIndex) {
        if (null != this.multiRcvDestination && this.multiRcvDestination.hasDestination(transportIndex)) {
            return this.multiRcvDestination.transport(transportIndex).udpChannel();
        }
        if (0 == transportIndex) {
            return super.udpChannel();
        }
        throw new IllegalStateException("udpChannel for unknown index " + transportIndex);
    }

    public boolean hasTag() {
        return this.udpChannel.hasTag();
    }

    public long tag() {
        return this.udpChannel.tag();
    }

    public boolean matchesTag(UdpChannel udpChannel) {
        return this.udpChannel.matchesTag(udpChannel);
    }

    @Override
    public int multicastTtl() {
        return this.multicastTtl(0);
    }

    public int multicastTtl(int transportIndex) {
        if (null != this.multiRcvDestination) {
            return this.multiRcvDestination.transport(transportIndex).multicastTtl();
        }
        if (0 == transportIndex) {
            return super.multicastTtl();
        }
        throw new IllegalStateException("multicastTtl for unknown index " + transportIndex);
    }

    public int addDestination(ReceiveDestinationTransport transport) {
        return this.multiRcvDestination.addDestination(transport);
    }

    public void removeDestination(int transportIndex) {
        this.multiRcvDestination.removeDestination(transportIndex);
    }

    public int destination(UdpChannel udpChannel) {
        return this.multiRcvDestination.transport(udpChannel);
    }

    public ReceiveDestinationTransport destination(int transportIndex) {
        return this.multiRcvDestination.transport(transportIndex);
    }

    public boolean hasDestination(int transportIndex) {
        return null == this.multiRcvDestination ? 0 == transportIndex : this.multiRcvDestination.hasDestination(transportIndex);
    }

    public int onDataPacket(DataHeaderFlyweight header, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress, int transportIndex) {
        if (this.isChannelReceiveTimestampEnabled && 0 != (header.flags() & 0x80)) {
            this.applyChannelReceiveTimestamp(buffer, length);
        }
        this.updateTimeOfLastActivityNs(this.cachedNanoClock.nanoTime(), transportIndex);
        return this.dispatcher.onDataPacket(this, header, buffer, length, srcAddress, transportIndex);
    }

    public void onSetupMessage(SetupFlyweight header, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress, int transportIndex) {
        this.updateTimeOfLastActivityNs(this.cachedNanoClock.nanoTime(), transportIndex);
        this.dispatcher.onSetupMessage(this, header, srcAddress, transportIndex);
    }

    public void onRttMeasurement(RttMeasurementFlyweight header, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress, int transportIndex) {
        long requestedReceiverId = header.receiverId();
        if (requestedReceiverId == this.receiverId || requestedReceiverId == 0L) {
            this.updateTimeOfLastActivityNs(this.cachedNanoClock.nanoTime(), transportIndex);
            this.dispatcher.onRttMeasurement(this, header, srcAddress, transportIndex);
        }
    }

    public void sendSetupElicitingStatusMessage(int transportIndex, InetSocketAddress controlAddress, int sessionId, int streamId) {
        this.smBuffer.clear();
        this.statusMessageFlyweight.sessionId(sessionId).streamId(streamId).consumptionTermId(0).consumptionTermOffset(0).receiverWindowLength(0).receiverId(this.receiverId).groupTag(this.groupTag).flags((short)128);
        this.smBuffer.limit(this.statusMessageFlyweight.frameLength());
        this.send(this.smBuffer, this.statusMessageFlyweight.frameLength(), transportIndex, controlAddress);
    }

    public void sendRttMeasurement(int transportIndex, InetSocketAddress controlAddress, int sessionId, int streamId, long echoTimestampNs, long receptionDelta, boolean isReply) {
        this.rttMeasurementBuffer.clear();
        this.rttMeasurementFlyweight.sessionId(sessionId).streamId(streamId).receiverId(this.receiverId).echoTimestampNs(echoTimestampNs).receptionDelta(receptionDelta).flags(isReply ? (short)128 : 0);
        this.send(this.rttMeasurementBuffer, 40, transportIndex, controlAddress);
    }

    public void sendStatusMessage(ImageConnection[] controlAddresses, int sessionId, int streamId, int termId, int termOffset, int windowLength, short flags) {
        this.smBuffer.clear();
        this.statusMessageFlyweight.sessionId(sessionId).streamId(streamId).consumptionTermId(termId).consumptionTermOffset(termOffset).receiverWindowLength(windowLength).receiverId(this.receiverId).groupTag(this.groupTag).flags(flags);
        this.smBuffer.limit(this.statusMessageFlyweight.frameLength());
        this.send(this.smBuffer, this.statusMessageFlyweight.frameLength(), controlAddresses);
    }

    public void sendNakMessage(ImageConnection[] controlAddresses, int sessionId, int streamId, int termId, int termOffset, int length) {
        this.nakBuffer.clear();
        this.nakFlyweight.streamId(streamId).sessionId(sessionId).termId(termId).termOffset(termOffset).length(length);
        this.send(this.nakBuffer, 28, controlAddresses);
    }

    public void sendRttMeasurement(ImageConnection[] controlAddresses, int sessionId, int streamId, long echoTimestampNs, long receptionDelta, boolean isReply) {
        this.rttMeasurementBuffer.clear();
        this.rttMeasurementFlyweight.sessionId(sessionId).streamId(streamId).receiverId(this.receiverId).echoTimestampNs(echoTimestampNs).receptionDelta(receptionDelta).flags(isReply ? (short)128 : 0);
        this.send(this.rttMeasurementBuffer, 40, controlAddresses);
    }

    public DataPacketDispatcher dispatcher() {
        return this.dispatcher;
    }

    public void updateControlAddress(int transportIndex, InetSocketAddress newAddress) {
        if (null != this.multiRcvDestination) {
            this.multiRcvDestination.updateControlAddress(transportIndex, newAddress);
        } else if (this.udpChannel.hasExplicitControl()) {
            this.currentControlAddress = newAddress;
        }
    }

    protected void send(ByteBuffer buffer, int length, ImageConnection[] imageConnections) {
        int bytesSent;
        int n = bytesSent = null == this.multiRcvDestination ? this.sendTo(buffer, imageConnections[0].controlAddress) : this.multiRcvDestination.sendToAll(imageConnections, buffer, length, this.cachedNanoClock.nanoTime());
        if (length != bytesSent) {
            this.shortSends.increment();
        }
    }

    protected void send(ByteBuffer buffer, int length, int transportIndex, InetSocketAddress remoteAddress) {
        int bytesSent;
        int n = bytesSent = null == this.multiRcvDestination ? this.sendTo(buffer, remoteAddress) : MultiRcvDestination.sendTo(this.multiRcvDestination.transport(transportIndex), buffer, remoteAddress);
        if (length != bytesSent) {
            this.shortSends.increment();
        }
    }

    void checkForReResolution(long nowNs, DriverConductorProxy conductorProxy) {
        if (null != this.multiRcvDestination) {
            this.multiRcvDestination.checkForReResolution(this, nowNs, conductorProxy);
        } else if (this.udpChannel.hasExplicitControl() && this.timeOfLastActivityNs + DESTINATION_ADDRESS_TIMEOUT - nowNs < 0L) {
            this.timeOfLastActivityNs = nowNs;
            conductorProxy.reResolveControl(this.udpChannel.channelUri().get("control"), this.udpChannel, this, this.currentControlAddress);
        }
    }

    public void incRefImages() {
        ++this.imageRefCount;
    }

    public void decRefImages() {
        --this.imageRefCount;
    }

    private void updateTimeOfLastActivityNs(long nowNs, int transportIndex) {
        if (null == this.multiRcvDestination) {
            this.timeOfLastActivityNs = nowNs;
        } else {
            this.multiRcvDestination.transport(transportIndex).timeOfLastActivityNs(nowNs);
        }
    }

    private void updateLocalSocketAddress(String bindAddressAndPort) {
        if (null != this.localSocketAddressIndicator) {
            LocalSocketAddressStatus.updateBindAddress(this.localSocketAddressIndicator, bindAddressAndPort, this.context.countersMetaDataBuffer());
            this.localSocketAddressIndicator.setOrdered(1L);
        }
    }

    private void applyChannelReceiveTimestamp(UnsafeBuffer buffer, int length) {
        int offset;
        if (length > 32 && 32 + (offset = this.udpChannel.channelReceiveTimestampOffset()) + 8 < length) {
            buffer.putLong(32 + offset, this.channelReceiveTimestampClock.nanoTime(), ByteOrder.LITTLE_ENDIAN);
        }
    }
}

