/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.samples.ImageRateSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;

public final class ImageRateReporter
implements Runnable {
    private final int messageLength;
    private final AtomicBoolean running;
    private final ImageRateSubscriber subscriber;

    public ImageRateReporter(int messageLength, AtomicBoolean running, ImageRateSubscriber subscriber) {
        this.messageLength = messageLength;
        this.running = running;
        this.subscriber = subscriber;
    }

    @Override
    public void run() {
        long lastTimestampMs = System.currentTimeMillis();
        long lastTotalBytes = this.subscriber.totalBytes();
        int messageLength = this.messageLength;
        while (this.running.get()) {
            LockSupport.parkNanos(1000000000L);
            long newTimestampMs = System.currentTimeMillis();
            long newTotalBytes = this.subscriber.totalBytes();
            long durationMs = newTimestampMs - lastTimestampMs;
            long bytesTransferred = newTotalBytes - lastTotalBytes;
            System.out.format("Duration %dms - %,d messages - %,d payload bytes%n", durationMs, bytesTransferred / (long)messageLength, bytesTransferred);
            lastTimestampMs = newTimestampMs;
            lastTotalBytes = newTotalBytes;
        }
    }
}

