/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.raw;

import io.aeron.samples.raw.Common;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.ToIntFunction;
import org.agrona.SystemUtil;
import org.agrona.concurrent.HighResolutionTimer;
import org.agrona.concurrent.SigInt;
import org.agrona.hints.ThreadHints;
import org.agrona.nio.NioSelectedKeySet;

public class HackSelectReceiveSendUdpPong {
    public static void main(String[] args) throws IOException {
        if (SystemUtil.isWindows()) {
            HighResolutionTimer.enable();
        }
        InetSocketAddress sendAddress = new InetSocketAddress(Common.PONG_DEST, 20123);
        ByteBuffer buffer = ByteBuffer.allocateDirect(1408);
        DatagramChannel receiveChannel = DatagramChannel.open();
        Common.init(receiveChannel);
        receiveChannel.bind(new InetSocketAddress(Common.PING_DEST, 20124));
        DatagramChannel sendChannel = DatagramChannel.open();
        Common.init(sendChannel);
        Selector selector = Selector.open();
        NioSelectedKeySet keySet = Common.keySet(selector);
        ToIntFunction<SelectionKey> handler = key -> {
            try {
                buffer.clear();
                receiveChannel.receive(buffer);
                long receivedSequenceNumber = buffer.getLong(0);
                long receivedTimestamp = buffer.getLong(8);
                buffer.clear();
                buffer.putLong(receivedSequenceNumber);
                buffer.putLong(receivedTimestamp);
                buffer.flip();
                sendChannel.send(buffer, sendAddress);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return 1;
        };
        receiveChannel.register(selector, 1, null);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        while (true) {
            if (selector.selectNow() == 0) {
                if (!running.get()) {
                    return;
                }
                ThreadHints.onSpinWait();
                continue;
            }
            keySet.forEach(handler);
        }
    }
}

