/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;


/**
 * Request a range of active recording subscriptions which match a criteria.
 */
@SuppressWarnings("all")
public final class ListRecordingSubscriptionsRequestEncoder
{
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 17;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 9;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final ListRecordingSubscriptionsRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public ListRecordingSubscriptionsRequestEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public ListRecordingSubscriptionsRequestEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int controlSessionIdId()
    {
        return 1;
    }

    public static int controlSessionIdSinceVersion()
    {
        return 0;
    }

    public static int controlSessionIdEncodingOffset()
    {
        return 0;
    }

    public static int controlSessionIdEncodingLength()
    {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long controlSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long controlSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public ListRecordingSubscriptionsRequestEncoder controlSessionId(final long value)
    {
        buffer.putLong(offset + 0, value, BYTE_ORDER);
        return this;
    }


    public static int correlationIdId()
    {
        return 2;
    }

    public static int correlationIdSinceVersion()
    {
        return 0;
    }

    public static int correlationIdEncodingOffset()
    {
        return 8;
    }

    public static int correlationIdEncodingLength()
    {
        return 8;
    }

    public static String correlationIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long correlationIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long correlationIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public ListRecordingSubscriptionsRequestEncoder correlationId(final long value)
    {
        buffer.putLong(offset + 8, value, BYTE_ORDER);
        return this;
    }


    public static int pseudoIndexId()
    {
        return 3;
    }

    public static int pseudoIndexSinceVersion()
    {
        return 0;
    }

    public static int pseudoIndexEncodingOffset()
    {
        return 16;
    }

    public static int pseudoIndexEncodingLength()
    {
        return 4;
    }

    public static String pseudoIndexMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int pseudoIndexNullValue()
    {
        return -2147483648;
    }

    public static int pseudoIndexMinValue()
    {
        return -2147483647;
    }

    public static int pseudoIndexMaxValue()
    {
        return 2147483647;
    }

    public ListRecordingSubscriptionsRequestEncoder pseudoIndex(final int value)
    {
        buffer.putInt(offset + 16, value, BYTE_ORDER);
        return this;
    }


    public static int subscriptionCountId()
    {
        return 4;
    }

    public static int subscriptionCountSinceVersion()
    {
        return 0;
    }

    public static int subscriptionCountEncodingOffset()
    {
        return 20;
    }

    public static int subscriptionCountEncodingLength()
    {
        return 4;
    }

    public static String subscriptionCountMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int subscriptionCountNullValue()
    {
        return -2147483648;
    }

    public static int subscriptionCountMinValue()
    {
        return -2147483647;
    }

    public static int subscriptionCountMaxValue()
    {
        return 2147483647;
    }

    public ListRecordingSubscriptionsRequestEncoder subscriptionCount(final int value)
    {
        buffer.putInt(offset + 20, value, BYTE_ORDER);
        return this;
    }


    public static int applyStreamIdId()
    {
        return 5;
    }

    public static int applyStreamIdSinceVersion()
    {
        return 0;
    }

    public static int applyStreamIdEncodingOffset()
    {
        return 24;
    }

    public static int applyStreamIdEncodingLength()
    {
        return 4;
    }

    public static String applyStreamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public ListRecordingSubscriptionsRequestEncoder applyStreamId(final BooleanType value)
    {
        buffer.putInt(offset + 24, value.value(), BYTE_ORDER);
        return this;
    }

    public static int streamIdId()
    {
        return 6;
    }

    public static int streamIdSinceVersion()
    {
        return 0;
    }

    public static int streamIdEncodingOffset()
    {
        return 28;
    }

    public static int streamIdEncodingLength()
    {
        return 4;
    }

    public static String streamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int streamIdNullValue()
    {
        return -2147483648;
    }

    public static int streamIdMinValue()
    {
        return -2147483647;
    }

    public static int streamIdMaxValue()
    {
        return 2147483647;
    }

    public ListRecordingSubscriptionsRequestEncoder streamId(final int value)
    {
        buffer.putInt(offset + 28, value, BYTE_ORDER);
        return this;
    }


    public static int channelId()
    {
        return 7;
    }

    public static String channelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String channelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int channelHeaderLength()
    {
        return 4;
    }

    public ListRecordingSubscriptionsRequestEncoder putChannel(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public ListRecordingSubscriptionsRequestEncoder putChannel(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public ListRecordingSubscriptionsRequestEncoder channel(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public ListRecordingSubscriptionsRequestEncoder channel(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final ListRecordingSubscriptionsRequestDecoder decoder = new ListRecordingSubscriptionsRequestDecoder();
        decoder.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
