/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;


/**
 * Replicate a recording from another archive and set tags on subscription.
 */
@SuppressWarnings("all")
public final class TaggedReplicateRequestDecoder
{
    public static final int BLOCK_LENGTH = 52;
    public static final int TEMPLATE_ID = 62;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 9;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final TaggedReplicateRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public TaggedReplicateRequestDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public TaggedReplicateRequestDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public TaggedReplicateRequestDecoder sbeRewind()
    {
        return wrap(buffer, offset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int actingVersion()
    {
        return actingVersion;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int controlSessionIdId()
    {
        return 1;
    }

    public static int controlSessionIdSinceVersion()
    {
        return 0;
    }

    public static int controlSessionIdEncodingOffset()
    {
        return 0;
    }

    public static int controlSessionIdEncodingLength()
    {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long controlSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long controlSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long controlSessionId()
    {
        return buffer.getLong(offset + 0, BYTE_ORDER);
    }


    public static int correlationIdId()
    {
        return 2;
    }

    public static int correlationIdSinceVersion()
    {
        return 0;
    }

    public static int correlationIdEncodingOffset()
    {
        return 8;
    }

    public static int correlationIdEncodingLength()
    {
        return 8;
    }

    public static String correlationIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long correlationIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long correlationIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long correlationId()
    {
        return buffer.getLong(offset + 8, BYTE_ORDER);
    }


    public static int srcRecordingIdId()
    {
        return 3;
    }

    public static int srcRecordingIdSinceVersion()
    {
        return 0;
    }

    public static int srcRecordingIdEncodingOffset()
    {
        return 16;
    }

    public static int srcRecordingIdEncodingLength()
    {
        return 8;
    }

    public static String srcRecordingIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long srcRecordingIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long srcRecordingIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long srcRecordingIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long srcRecordingId()
    {
        return buffer.getLong(offset + 16, BYTE_ORDER);
    }


    public static int dstRecordingIdId()
    {
        return 4;
    }

    public static int dstRecordingIdSinceVersion()
    {
        return 0;
    }

    public static int dstRecordingIdEncodingOffset()
    {
        return 24;
    }

    public static int dstRecordingIdEncodingLength()
    {
        return 8;
    }

    public static String dstRecordingIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long dstRecordingIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long dstRecordingIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long dstRecordingIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long dstRecordingId()
    {
        return buffer.getLong(offset + 24, BYTE_ORDER);
    }


    public static int channelTagIdId()
    {
        return 5;
    }

    public static int channelTagIdSinceVersion()
    {
        return 0;
    }

    public static int channelTagIdEncodingOffset()
    {
        return 32;
    }

    public static int channelTagIdEncodingLength()
    {
        return 8;
    }

    public static String channelTagIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long channelTagIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long channelTagIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long channelTagIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long channelTagId()
    {
        return buffer.getLong(offset + 32, BYTE_ORDER);
    }


    public static int subscriptionTagIdId()
    {
        return 6;
    }

    public static int subscriptionTagIdSinceVersion()
    {
        return 0;
    }

    public static int subscriptionTagIdEncodingOffset()
    {
        return 40;
    }

    public static int subscriptionTagIdEncodingLength()
    {
        return 8;
    }

    public static String subscriptionTagIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long subscriptionTagIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long subscriptionTagIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long subscriptionTagIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long subscriptionTagId()
    {
        return buffer.getLong(offset + 40, BYTE_ORDER);
    }


    public static int srcControlStreamIdId()
    {
        return 7;
    }

    public static int srcControlStreamIdSinceVersion()
    {
        return 0;
    }

    public static int srcControlStreamIdEncodingOffset()
    {
        return 48;
    }

    public static int srcControlStreamIdEncodingLength()
    {
        return 4;
    }

    public static String srcControlStreamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int srcControlStreamIdNullValue()
    {
        return -2147483648;
    }

    public static int srcControlStreamIdMinValue()
    {
        return -2147483647;
    }

    public static int srcControlStreamIdMaxValue()
    {
        return 2147483647;
    }

    public int srcControlStreamId()
    {
        return buffer.getInt(offset + 48, BYTE_ORDER);
    }


    public static int srcControlChannelId()
    {
        return 8;
    }

    public static int srcControlChannelSinceVersion()
    {
        return 0;
    }

    public static String srcControlChannelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String srcControlChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int srcControlChannelHeaderLength()
    {
        return 4;
    }

    public int srcControlChannelLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
    }

    public int skipSrcControlChannel()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getSrcControlChannel(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getSrcControlChannel(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapSrcControlChannel(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String srcControlChannel()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        return new String(tmp, java.nio.charset.StandardCharsets.US_ASCII);
    }

    public int getSrcControlChannel(final Appendable appendable)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;

        parentMessage.limit(dataOffset + dataLength);
        buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);

        return dataLength;
    }

    public static int liveDestinationId()
    {
        return 9;
    }

    public static int liveDestinationSinceVersion()
    {
        return 0;
    }

    public static String liveDestinationCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String liveDestinationMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int liveDestinationHeaderLength()
    {
        return 4;
    }

    public int liveDestinationLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
    }

    public int skipLiveDestination()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getLiveDestination(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getLiveDestination(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapLiveDestination(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String liveDestination()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        return new String(tmp, java.nio.charset.StandardCharsets.US_ASCII);
    }

    public int getLiveDestination(final Appendable appendable)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;

        parentMessage.limit(dataOffset + dataLength);
        buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);

        return dataLength;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final TaggedReplicateRequestDecoder decoder = new TaggedReplicateRequestDecoder();
        decoder.wrap(buffer, offset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(offset + actingBlockLength);
        builder.append("[TaggedReplicateRequest](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("controlSessionId=");
        builder.append(this.controlSessionId());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("srcRecordingId=");
        builder.append(this.srcRecordingId());
        builder.append('|');
        builder.append("dstRecordingId=");
        builder.append(this.dstRecordingId());
        builder.append('|');
        builder.append("channelTagId=");
        builder.append(this.channelTagId());
        builder.append('|');
        builder.append("subscriptionTagId=");
        builder.append(this.subscriptionTagId());
        builder.append('|');
        builder.append("srcControlStreamId=");
        builder.append(this.srcControlStreamId());
        builder.append('|');
        builder.append("srcControlChannel=");
        builder.append('\'');
        getSrcControlChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("liveDestination=");
        builder.append('\'');
        getLiveDestination(builder);
        builder.append('\'');

        limit(originalLimit);

        return builder;
    }
    
    public TaggedReplicateRequestDecoder sbeSkip()
    {
        sbeRewind();
        skipSrcControlChannel();
        skipLiveDestination();

        return this;
    }
}
