/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.logbuffer.LogBufferDescriptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.agrona.AsciiEncoding;
import org.agrona.collections.ArrayUtil;
import org.agrona.collections.Object2ObjectHashMap;

public final class ChannelUri {
    public static final String AERON_SCHEME = "aeron";
    public static final String SPY_QUALIFIER = "aeron-spy";
    public static final long INVALID_TAG = -1L;
    private static final int CHANNEL_TAG_INDEX = 0;
    private static final int ENTITY_TAG_INDEX = 1;
    private static final String AERON_PREFIX = "aeron:";
    private String prefix;
    private String media;
    private final Object2ObjectHashMap<String, String> params;
    private final String[] tags;

    private ChannelUri(String prefix, String media, Object2ObjectHashMap<String, String> params) {
        this.prefix = prefix;
        this.media = media;
        this.params = params;
        this.tags = ChannelUri.splitTags(params.get("tags"));
    }

    public String prefix() {
        return this.prefix;
    }

    public ChannelUri prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String media() {
        return this.media;
    }

    public ChannelUri media(String media) {
        ChannelUri.validateMedia(media);
        this.media = media;
        return this;
    }

    public boolean isUdp() {
        return "udp".equals(this.media);
    }

    public boolean isIpc() {
        return "ipc".equals(this.media);
    }

    public String scheme() {
        return AERON_SCHEME;
    }

    public String get(String key) {
        return this.params.get(key);
    }

    public String get(String key, String defaultValue) {
        String value = this.params.get(key);
        if (null != value) {
            return value;
        }
        return defaultValue;
    }

    public String put(String key, String value) {
        return this.params.put(key, value);
    }

    public String remove(String key) {
        return this.params.remove(key);
    }

    public boolean containsKey(String key) {
        return this.params.containsKey(key);
    }

    public String channelTag() {
        return this.tags.length > 0 ? this.tags[0] : null;
    }

    public String entityTag() {
        return this.tags.length > 1 ? this.tags[1] : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChannelUri)) {
            return false;
        }
        ChannelUri that = (ChannelUri)o;
        return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.media, that.media) && Objects.equals(this.params, that.params) && Arrays.equals(this.tags, that.tags);
    }

    public int hashCode() {
        int result = 19;
        result = 31 * result + Objects.hashCode(this.prefix);
        result = 31 * result + Objects.hashCode(this.media);
        result = 31 * result + Objects.hashCode(this.params);
        result = 31 * result + Arrays.hashCode(this.tags);
        return result;
    }

    public String toString() {
        StringBuilder sb;
        if (this.prefix == null || this.prefix.isEmpty()) {
            sb = new StringBuilder(this.params.size() * 20 + 10);
        } else {
            sb = new StringBuilder(this.params.size() * 20 + 20);
            sb.append(this.prefix);
            if (!this.prefix.endsWith(":")) {
                sb.append(':');
            }
        }
        sb.append(AERON_PREFIX).append(this.media);
        if (!this.params.isEmpty()) {
            sb.append('?');
            for (Map.Entry entry : this.params.entrySet()) {
                sb.append((String)entry.getKey()).append('=').append((String)entry.getValue()).append('|');
            }
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public void initialPosition(long position, int initialTermId, int termLength) {
        if (position < 0L || 0L != (position & 0x1FL)) {
            throw new IllegalArgumentException("invalid position: " + position);
        }
        int bitsToShift = LogBufferDescriptor.positionBitsToShift(termLength);
        int termId = LogBufferDescriptor.computeTermIdFromPosition(position, bitsToShift, initialTermId);
        int termOffset = (int)(position & (long)(termLength - 1));
        this.put("init-term-id", Integer.toString(initialTermId));
        this.put("term-id", Integer.toString(termId));
        this.put("term-offset", Integer.toString(termOffset));
        this.put("term-length", Integer.toString(termLength));
    }

    public static ChannelUri parse(CharSequence cs) {
        String prefix;
        int position = 0;
        if (ChannelUri.startsWith(cs, 0, "aeron-spy:")) {
            prefix = SPY_QUALIFIER;
            position = "aeron-spy:".length();
        } else {
            prefix = "";
        }
        if (!ChannelUri.startsWith(cs, position, AERON_PREFIX)) {
            throw new IllegalArgumentException("Aeron URIs must start with 'aeron:', found: " + cs);
        }
        position += AERON_PREFIX.length();
        StringBuilder builder = new StringBuilder();
        Object2ObjectHashMap<String, String> params = new Object2ObjectHashMap<String, String>();
        String media = null;
        String key = null;
        State state = State.MEDIA;
        int length = cs.length();
        block13: for (int i = position; i < length; ++i) {
            char c = cs.charAt(i);
            switch (state) {
                case MEDIA: {
                    switch (c) {
                        case '?': {
                            media = builder.toString();
                            builder.setLength(0);
                            state = State.PARAMS_KEY;
                            continue block13;
                        }
                        case ':': 
                        case '=': 
                        case '|': {
                            throw new IllegalArgumentException("encountered '" + c + "' within media definition at index " + i + " in " + cs);
                        }
                    }
                    builder.append(c);
                    continue block13;
                }
                case PARAMS_KEY: {
                    if (c == '=') {
                        if (0 == builder.length()) {
                            throw new IllegalStateException("empty key not allowed at index " + i + " in " + cs);
                        }
                        key = builder.toString();
                        builder.setLength(0);
                        state = State.PARAMS_VALUE;
                        continue block13;
                    }
                    if (c == '|') {
                        throw new IllegalStateException("invalid end of key at index " + i + " in " + cs);
                    }
                    builder.append(c);
                    continue block13;
                }
                case PARAMS_VALUE: {
                    if (c == '|') {
                        params.put(key, builder.toString());
                        builder.setLength(0);
                        state = State.PARAMS_KEY;
                        continue block13;
                    }
                    builder.append(c);
                    continue block13;
                }
                default: {
                    throw new IllegalStateException("unexpected state=" + (Object)((Object)state) + " in " + cs);
                }
            }
        }
        switch (state) {
            case MEDIA: {
                media = builder.toString();
                ChannelUri.validateMedia(media);
                break;
            }
            case PARAMS_VALUE: {
                params.put(key, builder.toString());
                break;
            }
            default: {
                throw new IllegalStateException("no more input found, state=" + (Object)((Object)state) + " in " + cs);
            }
        }
        return new ChannelUri(prefix, media, params);
    }

    public static String addSessionId(String channel, int sessionId) {
        ChannelUri channelUri = ChannelUri.parse(channel);
        channelUri.put("session-id", Integer.toString(sessionId));
        return channelUri.toString();
    }

    public static boolean isTagged(String paramValue) {
        return ChannelUri.startsWith(paramValue, 0, "tag:");
    }

    public static long getTag(String paramValue) {
        return ChannelUri.isTagged(paramValue) ? AsciiEncoding.parseLongAscii(paramValue, 4, paramValue.length() - 4) : -1L;
    }

    public static String createDestinationUri(String channel, String endpoint) {
        ChannelUri channelUri = ChannelUri.parse(channel);
        String uri = AERON_PREFIX + channelUri.media() + "?" + "endpoint" + "=" + endpoint;
        String networkInterface = channelUri.get("interface");
        if (null != networkInterface) {
            return uri + "|" + "interface" + "=" + networkInterface;
        }
        return uri;
    }

    public void replaceEndpointWildcardPort(String resolvedEndpoint) {
        int portSeparatorIndex = Objects.requireNonNull(resolvedEndpoint, "resolvedEndpoint is null").lastIndexOf(58);
        if (-1 == portSeparatorIndex) {
            throw new IllegalArgumentException("No port specified on resolvedEndpoint=" + resolvedEndpoint);
        }
        if (resolvedEndpoint.endsWith(":0")) {
            throw new IllegalArgumentException("Wildcard port specified on resolvedEndpoint=" + resolvedEndpoint);
        }
        String existingEndpoint = this.get("endpoint");
        if (null == existingEndpoint) {
            this.put("endpoint", resolvedEndpoint);
        } else if (existingEndpoint.endsWith(":0")) {
            String endpoint = existingEndpoint.substring(0, existingEndpoint.length() - 2) + resolvedEndpoint.substring(resolvedEndpoint.lastIndexOf(58));
            this.put("endpoint", endpoint);
        }
    }

    public void forEachParameter(BiConsumer<String, String> consumer) {
        this.params.forEach(consumer);
    }

    private static void validateMedia(String media) {
        if ("ipc".equals(media) || "udp".equals(media)) {
            return;
        }
        throw new IllegalArgumentException("unknown media: " + media);
    }

    private static boolean startsWith(CharSequence input, int position, String prefix) {
        if (input.length() - position < prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (input.charAt(position + i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static String[] splitTags(String tagsValue) {
        String[] tags = ArrayUtil.EMPTY_STRING_ARRAY;
        if (null != tagsValue) {
            int tagCount = ChannelUri.countTags(tagsValue);
            if (tagCount == 1) {
                tags = new String[]{tagsValue};
            } else {
                int tagStartPosition = 0;
                int tagIndex = 0;
                tags = new String[tagCount];
                int length = tagsValue.length();
                for (int i = 0; i < length; ++i) {
                    if (tagsValue.charAt(i) != ',') continue;
                    tags[tagIndex++] = tagsValue.substring(tagStartPosition, i);
                    tagStartPosition = i + 1;
                    if (tagIndex < tagCount - 1) continue;
                    tags[tagIndex] = tagsValue.substring(tagStartPosition, length);
                }
            }
        }
        return tags;
    }

    private static int countTags(String tags) {
        int count = 1;
        int length = tags.length();
        for (int i = 0; i < length; ++i) {
            if (tags.charAt(i) != ',') continue;
            ++count;
        }
        return count;
    }

    Map<String, String> diff(ChannelUri that) {
        HashMap<String, String> differingValues = new HashMap<String, String>();
        if (!Objects.equals(this.prefix, that.prefix)) {
            differingValues.put("prefix", this.prefix + " != " + that.prefix);
        }
        if (!Objects.equals(this.media, that.media)) {
            differingValues.put("media", this.media + " != " + that.media);
        }
        if (!Objects.equals(this.params, that.params)) {
            this.params.forEach((key, value) -> {
                String thatValue = that.params.get(key);
                if (!Objects.equals(value, thatValue)) {
                    differingValues.put((String)key, value + " != " + thatValue);
                }
            });
        }
        if (!Arrays.equals(this.tags, that.tags)) {
            differingValues.put("tags", Arrays.toString(this.tags) + " != " + Arrays.toString(that.tags));
        }
        return differingValues;
    }

    private static enum State {
        MEDIA,
        PARAMS_KEY,
        PARAMS_VALUE;

    }
}

