/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.CloseReason;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class SessionCloseEventDecoder {
    public static final int BLOCK_LENGTH = 28;
    public static final int TEMPLATE_ID = 22;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SessionCloseEventDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 28;
    }

    public int sbeTemplateId() {
        return 22;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 12;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public SessionCloseEventDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public SessionCloseEventDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (22 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public SessionCloseEventDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int leadershipTermIdId() {
        return 1;
    }

    public static int leadershipTermIdSinceVersion() {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset() {
        return 0;
    }

    public static int leadershipTermIdEncodingLength() {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long leadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long leadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long leadershipTermId() {
        return this.buffer.getLong(this.offset + 0, BYTE_ORDER);
    }

    public static int clusterSessionIdId() {
        return 2;
    }

    public static int clusterSessionIdSinceVersion() {
        return 0;
    }

    public static int clusterSessionIdEncodingOffset() {
        return 8;
    }

    public static int clusterSessionIdEncodingLength() {
        return 8;
    }

    public static String clusterSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long clusterSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long clusterSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long clusterSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long clusterSessionId() {
        return this.buffer.getLong(this.offset + 8, BYTE_ORDER);
    }

    public static int timestampId() {
        return 3;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 16;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long timestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timestampMinValue() {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public long timestamp() {
        return this.buffer.getLong(this.offset + 16, BYTE_ORDER);
    }

    public static int closeReasonId() {
        return 4;
    }

    public static int closeReasonSinceVersion() {
        return 0;
    }

    public static int closeReasonEncodingOffset() {
        return 24;
    }

    public static int closeReasonEncodingLength() {
        return 4;
    }

    public static String closeReasonMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public int closeReasonRaw() {
        return this.buffer.getInt(this.offset + 24, BYTE_ORDER);
    }

    public CloseReason closeReason() {
        return CloseReason.get(this.buffer.getInt(this.offset + 24, BYTE_ORDER));
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        SessionCloseEventDecoder decoder = new SessionCloseEventDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[SessionCloseEvent](sbeTemplateId=");
        builder.append(22);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 12) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(12);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 28) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(28);
        builder.append("):");
        builder.append("leadershipTermId=");
        builder.append(this.leadershipTermId());
        builder.append('|');
        builder.append("clusterSessionId=");
        builder.append(this.clusterSessionId());
        builder.append('|');
        builder.append("timestamp=");
        builder.append(this.timestamp());
        builder.append('|');
        builder.append("closeReason=");
        builder.append((Object)this.closeReason());
        this.limit(originalLimit);
        return builder;
    }

    public SessionCloseEventDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

