/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ErrorCode;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.CounterMessageFlyweight;
import io.aeron.command.DestinationMessageFlyweight;
import io.aeron.command.PublicationMessageFlyweight;
import io.aeron.command.RemoveMessageFlyweight;
import io.aeron.command.SubscriptionMessageFlyweight;
import io.aeron.command.TerminateDriverFlyweight;
import io.aeron.driver.ClientProxy;
import io.aeron.driver.DriverConductor;
import io.aeron.exceptions.ControlProtocolException;
import io.aeron.exceptions.StorageSpaceException;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.ControlledMessageHandler;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.AtomicCounter;

final class ClientCommandAdapter
implements ControlledMessageHandler {
    private final PublicationMessageFlyweight publicationMsgFlyweight = new PublicationMessageFlyweight();
    private final SubscriptionMessageFlyweight subscriptionMsgFlyweight = new SubscriptionMessageFlyweight();
    private final CorrelatedMessageFlyweight correlatedMsgFlyweight = new CorrelatedMessageFlyweight();
    private final RemoveMessageFlyweight removeMsgFlyweight = new RemoveMessageFlyweight();
    private final DestinationMessageFlyweight destinationMsgFlyweight = new DestinationMessageFlyweight();
    private final CounterMessageFlyweight counterMsgFlyweight = new CounterMessageFlyweight();
    private final TerminateDriverFlyweight terminateDriverFlyweight = new TerminateDriverFlyweight();
    private final DriverConductor conductor;
    private final RingBuffer toDriverCommands;
    private final ClientProxy clientProxy;
    private final AtomicCounter errors;
    private final ErrorHandler errorHandler;

    ClientCommandAdapter(AtomicCounter errors, ErrorHandler errorHandler, RingBuffer toDriverCommands, ClientProxy clientProxy, DriverConductor driverConductor) {
        this.errors = errors;
        this.errorHandler = errorHandler;
        this.toDriverCommands = toDriverCommands;
        this.clientProxy = clientProxy;
        this.conductor = driverConductor;
    }

    int receive() {
        return this.toDriverCommands.controlledRead(this, 1);
    }

    @Override
    public ControlledMessageHandler.Action onMessage(int msgTypeId, MutableDirectBuffer buffer, int index, int length) {
        long correlationId = 0L;
        if (this.conductor.notAcceptingClientCommands()) {
            return ControlledMessageHandler.Action.ABORT;
        }
        try {
            switch (msgTypeId) {
                case 1: {
                    this.publicationMsgFlyweight.wrap(buffer, index);
                    this.publicationMsgFlyweight.validateLength(msgTypeId, length);
                    correlationId = this.publicationMsgFlyweight.correlationId();
                    this.addPublication(correlationId, false);
                    break;
                }
                case 2: {
                    this.removeMsgFlyweight.wrap(buffer, index);
                    this.removeMsgFlyweight.validateLength(msgTypeId, length);
                    correlationId = this.removeMsgFlyweight.correlationId();
                    this.conductor.onRemovePublication(this.removeMsgFlyweight.registrationId(), correlationId);
                    break;
                }
                case 3: {
                    this.publicationMsgFlyweight.wrap(buffer, index);
                    this.publicationMsgFlyweight.validateLength(msgTypeId, length);
                    correlationId = this.publicationMsgFlyweight.correlationId();
                    this.addPublication(correlationId, true);
                    break;
                }
                case 4: {
                    this.subscriptionMsgFlyweight.wrap(buffer, index);
                    this.subscriptionMsgFlyweight.validateLength(msgTypeId, length);
                    correlationId = this.subscriptionMsgFlyweight.correlationId();
                    long clientId = this.subscriptionMsgFlyweight.clientId();
                    int streamId = this.subscriptionMsgFlyweight.streamId();
                    String channel = this.subscriptionMsgFlyweight.channel();
                    if (channel.startsWith("aeron:ipc")) {
                        this.conductor.onAddIpcSubscription(channel, streamId, correlationId, clientId);
                        break;
                    }
                    if (channel.startsWith("aeron-spy")) {
                        this.conductor.onAddSpySubscription(channel, streamId, correlationId, clientId);
                        break;
                    }
                    this.conductor.onAddNetworkSubscription(channel, streamId, correlationId, clientId);
                    break;
                }
                case 5: {
                    this.removeMsgFlyweight.wrap(buffer, index);
                    this.removeMsgFlyweight.validateLength(msgTypeId, length);
                    correlationId = this.removeMsgFlyweight.correlationId();
                    this.conductor.onRemoveSubscription(this.removeMsgFlyweight.registrationId(), correlationId);
                    break;
                }
                case 7: {
                    this.destinationMsgFlyweight.wrap(buffer, index);
                    this.destinationMsgFlyweight.validateLength(msgTypeId, length);
                    correlationId = this.destinationMsgFlyweight.correlationId();
                    long channelRegistrationId = this.destinationMsgFlyweight.registrationCorrelationId();
                    String channel = this.destinationMsgFlyweight.channel();
                    this.conductor.onAddSendDestination(channelRegistrationId, channel, correlationId);
                    break;
                }
                case 8: {
                    this.destinationMsgFlyweight.wrap(buffer, index);
                    this.destinationMsgFlyweight.validateLength(msgTypeId, length);
                    correlationId = this.destinationMsgFlyweight.correlationId();
                    long channelRegistrationId = this.destinationMsgFlyweight.registrationCorrelationId();
                    String channel = this.destinationMsgFlyweight.channel();
                    this.conductor.onRemoveSendDestination(channelRegistrationId, channel, correlationId);
                    break;
                }
                case 6: {
                    this.correlatedMsgFlyweight.wrap(buffer, index);
                    this.correlatedMsgFlyweight.validateLength(msgTypeId, length);
                    this.conductor.onClientKeepalive(this.correlatedMsgFlyweight.clientId());
                    break;
                }
                case 9: {
                    this.counterMsgFlyweight.wrap(buffer, index);
                    this.counterMsgFlyweight.validateLength(msgTypeId, length);
                    correlationId = this.counterMsgFlyweight.correlationId();
                    long clientId = this.counterMsgFlyweight.clientId();
                    this.conductor.onAddCounter(this.counterMsgFlyweight.typeId(), buffer, index + this.counterMsgFlyweight.keyBufferOffset(), this.counterMsgFlyweight.keyBufferLength(), buffer, index + this.counterMsgFlyweight.labelBufferOffset(), this.counterMsgFlyweight.labelBufferLength(), correlationId, clientId);
                    break;
                }
                case 10: {
                    this.removeMsgFlyweight.wrap(buffer, index);
                    this.removeMsgFlyweight.validateLength(msgTypeId, length);
                    correlationId = this.removeMsgFlyweight.correlationId();
                    this.conductor.onRemoveCounter(this.removeMsgFlyweight.registrationId(), correlationId);
                    break;
                }
                case 11: {
                    this.correlatedMsgFlyweight.wrap(buffer, index);
                    this.correlatedMsgFlyweight.validateLength(msgTypeId, length);
                    this.conductor.onClientClose(this.correlatedMsgFlyweight.clientId());
                    break;
                }
                case 12: {
                    this.destinationMsgFlyweight.wrap(buffer, index);
                    this.destinationMsgFlyweight.validateLength(msgTypeId, length);
                    correlationId = this.destinationMsgFlyweight.correlationId();
                    long channelRegistrationId = this.destinationMsgFlyweight.registrationCorrelationId();
                    String channel = this.destinationMsgFlyweight.channel();
                    this.conductor.onAddRcvDestination(channelRegistrationId, channel, correlationId);
                    break;
                }
                case 13: {
                    this.destinationMsgFlyweight.wrap(buffer, index);
                    this.destinationMsgFlyweight.validateLength(msgTypeId, length);
                    correlationId = this.destinationMsgFlyweight.correlationId();
                    long channelRegistrationId = this.destinationMsgFlyweight.registrationCorrelationId();
                    String channel = this.destinationMsgFlyweight.channel();
                    this.conductor.onRemoveRcvDestination(channelRegistrationId, channel, correlationId);
                    break;
                }
                case 14: {
                    this.terminateDriverFlyweight.wrap(buffer, index);
                    this.terminateDriverFlyweight.validateLength(msgTypeId, length);
                    this.conductor.onTerminateDriver(buffer, this.terminateDriverFlyweight.tokenBufferOffset(), this.terminateDriverFlyweight.tokenBufferLength());
                    break;
                }
                default: {
                    ControlProtocolException ex = new ControlProtocolException(ErrorCode.UNKNOWN_COMMAND_TYPE_ID, "command typeId=" + msgTypeId);
                    this.onError(correlationId, ex);
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.onError(correlationId, ex);
        }
        return ControlledMessageHandler.Action.CONTINUE;
    }

    private void addPublication(long correlationId, boolean isExclusive) {
        long clientId = this.publicationMsgFlyweight.clientId();
        int streamId = this.publicationMsgFlyweight.streamId();
        String channel = this.publicationMsgFlyweight.channel();
        if (channel.startsWith("aeron:ipc")) {
            this.conductor.onAddIpcPublication(channel, streamId, correlationId, clientId, isExclusive);
        } else {
            this.conductor.onAddNetworkPublication(channel, streamId, correlationId, clientId, isExclusive);
        }
    }

    void onError(long correlationId, Exception error) {
        if (!this.errors.isClosed()) {
            this.errors.increment();
        }
        this.errorHandler.onError(error);
        if (error instanceof ControlProtocolException) {
            this.clientProxy.onError(correlationId, ((ControlProtocolException)error).errorCode(), error.getMessage());
        } else if (error instanceof StorageSpaceException || StorageSpaceException.isStorageSpaceError(error)) {
            this.clientProxy.onError(correlationId, ErrorCode.STORAGE_SPACE, error.getMessage());
        } else {
            String errorMessage = error.getClass().getName() + " : " + error.getMessage();
            this.clientProxy.onError(correlationId, ErrorCode.GENERIC_ERROR, errorMessage);
        }
    }
}

