/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.ThreadingMode;
import java.util.function.Consumer;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.status.AtomicCounter;

abstract class CommandProxy {
    static final Consumer<Runnable> RUN_TASK = Runnable::run;
    private final ThreadingMode threadingMode;
    private final OneToOneConcurrentArrayQueue<Runnable> commandQueue;
    private final AtomicCounter failCount;
    private final boolean notConcurrent;

    CommandProxy(ThreadingMode threadingMode, OneToOneConcurrentArrayQueue<Runnable> commandQueue, AtomicCounter failCount) {
        this.threadingMode = threadingMode;
        this.commandQueue = commandQueue;
        this.failCount = failCount;
        this.notConcurrent = ThreadingMode.SHARED == threadingMode || ThreadingMode.INVOKER == threadingMode;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{threadingMode=" + (Object)((Object)this.threadingMode) + ", failCount=" + this.failCount + '}';
    }

    final boolean notConcurrent() {
        return this.notConcurrent;
    }

    final ThreadingMode threadingMode() {
        return this.threadingMode;
    }

    final void offer(Runnable cmd) {
        while (!this.commandQueue.offer(cmd)) {
            if (!this.failCount.isClosed()) {
                this.failCount.increment();
            }
            Thread.yield();
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new AgentTerminationException("interrupted");
        }
    }

    final boolean isApplyingBackpressure() {
        return this.commandQueue.remainingCapacity() < 1;
    }
}

