/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.archive;

import io.aeron.ConcurrentPublication;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.archive.status.RecordingPos;
import io.aeron.samples.SampleConfiguration;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.BufferUtil;
import org.agrona.concurrent.SigInt;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.YieldingIdleStrategy;
import org.agrona.concurrent.status.CountersReader;

public class RecordedBasicPublisher {
    private static final int STREAM_ID = SampleConfiguration.STREAM_ID;
    private static final String CHANNEL = SampleConfiguration.CHANNEL;
    private static final long NUMBER_OF_MESSAGES = SampleConfiguration.NUMBER_OF_MESSAGES;
    private static final UnsafeBuffer BUFFER = new UnsafeBuffer(BufferUtil.allocateDirectAligned(256, 64));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws InterruptedException {
        System.out.println("Publishing to " + CHANNEL + " on stream id " + STREAM_ID);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        AeronArchive.Context archiveCtx = new AeronArchive.Context().controlResponseStreamId(AeronArchive.Configuration.controlResponseStreamId() + 1);
        try (AeronArchive archive = AeronArchive.connect(archiveCtx);){
            archive.startRecording(CHANNEL, STREAM_ID, SourceLocation.LOCAL);
            try {
                ConcurrentPublication publication = archive.context().aeron().addPublication(CHANNEL, STREAM_ID);
                Throwable throwable = null;
                YieldingIdleStrategy idleStrategy = YieldingIdleStrategy.INSTANCE;
                CountersReader counters = archive.context().aeron().countersReader();
                long archiveId = archive.archiveId();
                int counterId = RecordingPos.findCounterIdBySession(counters, publication.sessionId(), archiveId);
                {
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
            finally {
                System.out.println("Done sending.");
                archive.stopRecording(CHANNEL, STREAM_ID);
            }
        }
    }

    private static void checkResult(long result) {
        if (result > 0L) {
            System.out.println("yay!");
        } else if (result == -2L) {
            System.out.println("Offer failed due to back pressure");
        } else if (result == -3L) {
            System.out.println("Offer failed because of an administration action in the system");
        } else if (result == -1L) {
            System.out.println("Offer failed because publisher is not connected to subscriber");
        } else if (result == -4L) {
            System.out.println("Offer failed publication is closed");
        } else {
            if (result == -5L) {
                throw new IllegalStateException("Offer failed due to publication reaching max position");
            }
            System.out.println("Offer failed due to unknown result code: " + result);
        }
    }
}

