/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.archive;

import io.aeron.archive.client.RecordingDescriptorConsumer;
import io.aeron.samples.archive.RecordingDescriptor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class RecordingDescriptorCollector {
    private final ArrayList<RecordingDescriptor> descriptors = new ArrayList();
    private final Deque<RecordingDescriptor> pool = new ArrayDeque<RecordingDescriptor>();
    private final int poolSize;
    private final RecordingDescriptorConsumer consumer = new RecordingDescriptorConsumer(){

        @Override
        public void onRecordingDescriptor(long controlSessionId, long correlationId, long recordingId, long startTimestamp, long stopTimestamp, long startPosition, long stopPosition, int initialTermId, int segmentFileLength, int termBufferLength, int mtuLength, int sessionId, int streamId, String strippedChannel, String originalChannel, String sourceIdentity) {
            RecordingDescriptor recordingDescriptor = (RecordingDescriptor)RecordingDescriptorCollector.this.pool.pollLast();
            if (null == recordingDescriptor) {
                recordingDescriptor = new RecordingDescriptor();
            }
            RecordingDescriptorCollector.this.descriptors.add(recordingDescriptor.set(controlSessionId, correlationId, recordingId, startTimestamp, stopTimestamp, startPosition, stopPosition, initialTermId, segmentFileLength, termBufferLength, mtuLength, sessionId, streamId, strippedChannel, originalChannel, sourceIdentity));
        }
    };

    public RecordingDescriptorCollector(int poolSize) {
        this.poolSize = poolSize;
    }

    public RecordingDescriptorConsumer reset() {
        int i = this.descriptors.size();
        while (-1 < --i) {
            RecordingDescriptor removed = this.descriptors.remove(i);
            if (this.pool.size() >= this.poolSize || removed.isRetained()) continue;
            this.pool.addLast(removed.reset());
        }
        return this.consumer;
    }

    public List<RecordingDescriptor> descriptors() {
        return this.descriptors;
    }

    public int poolSize() {
        return this.poolSize;
    }
}

