/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Aeron;
import io.aeron.AeronCounters;
import io.aeron.ChannelUri;
import io.aeron.ChannelUriStringBuilder;
import io.aeron.CommonContext;
import io.aeron.Counter;
import io.aeron.RethrowingErrorHandler;
import io.aeron.archive.ArchiveConductor;
import io.aeron.archive.ArchiveCounters;
import io.aeron.archive.ArchiveMarkFile;
import io.aeron.archive.ArchiveThreadingMode;
import io.aeron.archive.Catalog;
import io.aeron.archive.DedicatedModeArchiveConductor;
import io.aeron.archive.SharedModeArchiveConductor;
import io.aeron.archive.checksum.Checksum;
import io.aeron.archive.checksum.Checksums;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.driver.DutyCycleTracker;
import io.aeron.driver.status.DutyCycleStallTracker;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.ConfigurationException;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.security.AuthenticatorSupplier;
import io.aeron.security.AuthorisationService;
import io.aeron.security.AuthorisationServiceSupplier;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Supplier;
import org.agrona.AsciiEncoding;
import org.agrona.BitUtil;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.MarkFile;
import org.agrona.Strings;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.CountedErrorHandler;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.NoOpLock;
import org.agrona.concurrent.ShutdownSignalBarrier;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.YieldingIdleStrategy;
import org.agrona.concurrent.errors.DistinctErrorLog;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.StatusIndicator;

public final class Archive
implements AutoCloseable {
    private final Context ctx;
    private final AgentRunner conductorRunner;
    private final AgentInvoker conductorInvoker;

    Archive(Context ctx) {
        try {
            ArchiveConductor conductor;
            ctx.conclude();
            this.ctx = ctx;
            ArchiveConductor archiveConductor = conductor = ArchiveThreadingMode.DEDICATED == ctx.threadingMode() ? new DedicatedModeArchiveConductor(ctx) : new SharedModeArchiveConductor(ctx);
            if (ArchiveThreadingMode.INVOKER == ctx.threadingMode()) {
                this.conductorInvoker = new AgentInvoker(ctx.errorHandler(), ctx.errorCounter(), conductor);
                this.conductorRunner = null;
            } else {
                this.conductorInvoker = null;
                this.conductorRunner = new AgentRunner(ctx.idleStrategy(), ctx.errorHandler(), ctx.errorCounter(), conductor);
            }
        }
        catch (ConcurrentConcludeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            CloseHelper.quietClose(ctx::close);
            throw ex;
        }
    }

    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles(args);
        ShutdownSignalBarrier shutdownSignalBarrier = new ShutdownSignalBarrier();
        Context ctx = new Context().errorHandler(throwable -> {
            if (throwable instanceof AgentTerminationException) {
                shutdownSignalBarrier.signal();
            } else if (AeronException.isFatal(throwable)) {
                shutdownSignalBarrier.signal();
            }
        });
        try (Archive ignore = Archive.launch(ctx);){
            shutdownSignalBarrier.await();
            System.out.println("Shutdown Archive...");
        }
    }

    public Context context() {
        return this.ctx;
    }

    @Override
    public void close() {
        CloseHelper.close(this.conductorInvoker);
        CloseHelper.close(this.conductorRunner);
    }

    public AgentInvoker invoker() {
        return this.conductorInvoker;
    }

    public static Archive launch() {
        return Archive.launch(new Context());
    }

    public static Archive launch(Context ctx) {
        Archive archive = new Archive(ctx);
        if (ArchiveThreadingMode.INVOKER == ctx.threadingMode()) {
            archive.conductorInvoker.start();
        } else {
            AgentRunner.startOnThread(archive.conductorRunner, ctx.threadFactory());
        }
        return archive;
    }

    static String segmentFileName(long recordingId, long segmentBasePosition) {
        return recordingId + "-" + segmentBasePosition + ".rec";
    }

    static FileChannel channelForDirectorySync(File directory, int fileSyncLevel) {
        if (fileSyncLevel > 0) {
            try {
                return FileChannel.open(directory.toPath(), new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final class Context
    implements Cloneable {
        private static final AtomicIntegerFieldUpdater<Context> IS_CONCLUDED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Context.class, "isConcluded");
        private volatile int isConcluded;
        private boolean deleteArchiveOnStart = Configuration.deleteArchiveOnStart();
        private boolean ownsAeronClient = false;
        private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
        private Aeron aeron;
        private File archiveDir;
        private File markFileDir;
        private String archiveDirectoryName = Configuration.archiveDirName();
        private FileChannel archiveDirChannel;
        private FileStore archiveFileStore;
        private Catalog catalog;
        private ArchiveMarkFile markFile;
        private AeronArchive.Context archiveClientContext;
        private AgentInvoker mediaDriverAgentInvoker;
        private boolean controlChannelEnabled = Configuration.controlChannelEnabled();
        private String controlChannel = AeronArchive.Configuration.controlChannel();
        private int controlStreamId = AeronArchive.Configuration.controlStreamId();
        private String localControlChannel = AeronArchive.Configuration.localControlChannel();
        private int localControlStreamId = AeronArchive.Configuration.localControlStreamId();
        private boolean controlTermBufferSparse = AeronArchive.Configuration.controlTermBufferSparse();
        private int controlTermBufferLength = AeronArchive.Configuration.controlTermBufferLength();
        private int controlMtuLength = AeronArchive.Configuration.controlMtuLength();
        private String recordingEventsChannel = AeronArchive.Configuration.recordingEventsChannel();
        private int recordingEventsStreamId = AeronArchive.Configuration.recordingEventsStreamId();
        private boolean recordingEventsEnabled = AeronArchive.Configuration.recordingEventsEnabled();
        private String replicationChannel = Configuration.replicationChannel();
        private long connectTimeoutNs = Configuration.connectTimeoutNs();
        private long replayLingerTimeoutNs = Configuration.replayLingerTimeoutNs();
        private long conductorCycleThresholdNs = Configuration.conductorCycleThresholdNs();
        private long recorderCycleThresholdNs = Configuration.recorderCycleThresholdNs();
        private long replayerCycleThresholdNs = Configuration.replayerCycleThresholdNs();
        private long catalogCapacity = Configuration.catalogCapacity();
        private long lowStorageSpaceThreshold = Configuration.lowStorageSpaceThreshold();
        private int segmentFileLength = Configuration.segmentFileLength();
        private int fileSyncLevel = Configuration.fileSyncLevel();
        private int catalogFileSyncLevel = Configuration.catalogFileSyncLevel();
        private int maxConcurrentRecordings = Configuration.maxConcurrentRecordings();
        private int maxConcurrentReplays = Configuration.maxConcurrentReplays();
        private int fileIoMaxLength = Configuration.fileIoMaxLength();
        private long archiveId = Configuration.archiveId();
        private ArchiveThreadingMode threadingMode = Configuration.threadingMode();
        private ThreadFactory threadFactory;
        private ThreadFactory recorderThreadFactory;
        private ThreadFactory replayerThreadFactory;
        private CountDownLatch abortLatch;
        private Supplier<IdleStrategy> idleStrategySupplier;
        private Supplier<IdleStrategy> replayerIdleStrategySupplier;
        private Supplier<IdleStrategy> recorderIdleStrategySupplier;
        private EpochClock epochClock;
        private NanoClock nanoClock;
        private AuthenticatorSupplier authenticatorSupplier;
        private AuthorisationServiceSupplier authorisationServiceSupplier;
        private Counter controlSessionsCounter;
        private Counter recordingSessionCounter;
        private Counter replaySessionCounter;
        private int errorBufferLength = Configuration.errorBufferLength();
        private ErrorHandler errorHandler;
        private AtomicCounter errorCounter;
        private CountedErrorHandler countedErrorHandler;
        private Checksum recordChecksum;
        private Checksum replayChecksum;
        private UnsafeBuffer dataBuffer;
        private UnsafeBuffer replayBuffer;
        private UnsafeBuffer recordChecksumBuffer;
        private DutyCycleTracker conductorDutyCycleTracker;
        private DutyCycleTracker recorderDutyCycleTracker;
        private DutyCycleTracker replayerDutyCycleTracker;
        private Counter totalWriteBytesCounter;
        private Counter totalWriteTimeCounter;
        private Counter maxWriteTimeCounter;
        private Counter totalReadBytesCounter;
        private Counter totalReadTimeCounter;
        private Counter maxReadTimeCounter;

        public Context clone() {
            try {
                return (Context)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void conclude() {
            if (0 != IS_CONCLUDED_UPDATER.getAndSet(this, 1)) {
                throw new ConcurrentConcludeException();
            }
            if (this.catalogFileSyncLevel < this.fileSyncLevel) {
                throw new ConfigurationException("catalogFileSyncLevel " + this.catalogFileSyncLevel + " < fileSyncLevel " + this.fileSyncLevel);
            }
            if (this.fileIoMaxLength < 65536 || !BitUtil.isPowerOfTwo(this.fileIoMaxLength)) {
                throw new ConfigurationException("invalid fileIoMaxLength=" + this.fileIoMaxLength);
            }
            io.aeron.driver.Configuration.validateMtuLength(this.controlMtuLength);
            LogBufferDescriptor.checkTermLength(this.controlTermBufferLength);
            if (this.controlChannelEnabled) {
                if (null == this.controlChannel) {
                    throw new ConfigurationException("Archive.Context.controlChannel must be set");
                }
                if (!this.controlChannel.startsWith("aeron:udp")) {
                    throw new ConfigurationException("Archive.Context.controlChannel must be UDP media: uri=" + this.controlChannel);
                }
            }
            if (!this.localControlChannel.startsWith("aeron:ipc")) {
                throw new ConfigurationException("local control channel must be IPC media: uri=" + this.localControlChannel);
            }
            if (null == this.replicationChannel) {
                throw new ConfigurationException("Archive.Context.replicationChannel must be set");
            }
            if (this.recordingEventsEnabled() && null == this.recordingEventsChannel()) {
                throw new ConfigurationException("Archive.Context.recordingEventsChannel must be set if Archive.Context.recordingEventsEnabled is true");
            }
            if (null == this.archiveDir) {
                this.archiveDir = new File(this.archiveDirectoryName);
            }
            if (null == this.markFileDir) {
                String markFileDirPath = Configuration.markFileDir();
                this.markFileDir = !Strings.isEmpty(markFileDirPath) ? new File(markFileDirPath) : this.archiveDir;
            }
            try {
                this.archiveDir = this.archiveDir.getCanonicalFile();
                this.archiveDirectoryName = this.archiveDir.getAbsolutePath();
                this.markFileDir = this.markFileDir.getCanonicalFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (this.deleteArchiveOnStart) {
                IoUtil.delete(this.archiveDir, false);
            }
            IoUtil.ensureDirectoryExists(this.archiveDir, "archive");
            IoUtil.ensureDirectoryExists(this.markFileDir, "mark file");
            this.archiveDirChannel = Archive.channelForDirectorySync(this.archiveDir, this.catalogFileSyncLevel);
            if (null == this.archiveFileStore) {
                try {
                    this.archiveFileStore = Files.getFileStore(this.archiveDir.toPath());
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            if (null == this.epochClock) {
                this.epochClock = SystemEpochClock.INSTANCE;
            }
            if (null == this.nanoClock) {
                this.nanoClock = SystemNanoClock.INSTANCE;
            }
            if (null != this.aeron) {
                this.aeronDirectoryName = this.aeron.context().aeronDirectoryName();
            }
            if (null == this.markFile) {
                if (this.errorBufferLength < 0x100000 || this.errorBufferLength > 0x7FFFDFFF) {
                    throw new ConfigurationException("invalid errorBufferLength=" + this.errorBufferLength);
                }
                this.markFile = new ArchiveMarkFile(this);
            }
            try {
                MarkFile.ensureMarkFileLink(this.archiveDir, new File(this.markFile.parentDirectory(), "archive-mark.dat"), "archive-mark.lnk");
                this.errorHandler = CommonContext.setupErrorHandler(this.errorHandler, new DistinctErrorLog(this.markFile.errorBuffer(), this.epochClock, StandardCharsets.US_ASCII));
                ExpandableArrayBuffer tempBuffer = new ExpandableArrayBuffer();
                if (null == this.aeron) {
                    this.ownsAeronClient = true;
                    this.aeron = Aeron.connect(new Aeron.Context().aeronDirectoryName(this.aeronDirectoryName).epochClock(this.epochClock).nanoClock(this.nanoClock).errorHandler(RethrowingErrorHandler.INSTANCE).driverAgentInvoker(this.mediaDriverAgentInvoker).useConductorAgentInvoker(true).subscriberErrorHandler(RethrowingErrorHandler.INSTANCE).awaitingIdleStrategy(YieldingIdleStrategy.INSTANCE).clientLock(NoOpLock.INSTANCE).clientName(-1L != this.archiveId ? "archive-" + this.archiveId : "archive"));
                    if (null == this.errorCounter) {
                        this.concludeArchiveId();
                        if (-1 != ArchiveCounters.find(this.aeron.countersReader(), 101, this.archiveId)) {
                            throw new ArchiveException("found existing archive for archiveId=" + this.archiveId);
                        }
                        this.errorCounter = ArchiveCounters.allocateErrorCounter(this.aeron, tempBuffer, this.archiveId);
                    }
                } else if (!this.aeron.context().useConductorAgentInvoker()) {
                    throw new ArchiveException("Aeron client instance must set Aeron.Context.useConductorInvoker(true)");
                }
                this.concludeArchiveId();
                if (!(this.aeron.context().subscriberErrorHandler() instanceof RethrowingErrorHandler)) {
                    throw new ArchiveException("Aeron client must use a RethrowingErrorHandler");
                }
                Objects.requireNonNull(this.errorCounter, "Error counter must be supplied if aeron client is");
                if (null == this.countedErrorHandler) {
                    this.countedErrorHandler = new CountedErrorHandler(this.errorHandler, this.errorCounter);
                }
                if (null == this.threadFactory) {
                    this.threadFactory = Thread::new;
                }
                if (null == this.recorderThreadFactory) {
                    this.recorderThreadFactory = this.threadFactory;
                }
                if (null == this.replayerThreadFactory) {
                    this.replayerThreadFactory = this.threadFactory;
                }
                if (null == this.idleStrategySupplier) {
                    this.idleStrategySupplier = Configuration.idleStrategySupplier(null);
                }
                if (null == this.conductorDutyCycleTracker) {
                    this.conductorDutyCycleTracker = new DutyCycleStallTracker(ArchiveCounters.allocate(this.aeron, tempBuffer, 103, "archive-conductor max cycle time in ns: " + this.threadingMode.name(), this.archiveId), ArchiveCounters.allocate(this.aeron, tempBuffer, 104, "archive-conductor work cycle time exceeded count: threshold=" + this.conductorCycleThresholdNs + "ns " + this.threadingMode.name(), this.archiveId), this.conductorCycleThresholdNs);
                }
                if (ArchiveThreadingMode.DEDICATED == this.threadingMode) {
                    if (null == this.recorderIdleStrategySupplier) {
                        this.recorderIdleStrategySupplier = Configuration.recorderIdleStrategySupplier(null);
                        if (null == this.recorderIdleStrategySupplier) {
                            this.recorderIdleStrategySupplier = this.idleStrategySupplier;
                        }
                    }
                    if (null == this.replayerIdleStrategySupplier) {
                        this.replayerIdleStrategySupplier = Configuration.replayerIdleStrategySupplier(null);
                        if (null == this.replayerIdleStrategySupplier) {
                            this.replayerIdleStrategySupplier = this.idleStrategySupplier;
                        }
                    }
                    if (null == this.recorderDutyCycleTracker) {
                        this.recorderDutyCycleTracker = new DutyCycleStallTracker(ArchiveCounters.allocate(this.aeron, tempBuffer, 103, "archive-recorder max cycle time in ns", this.archiveId), ArchiveCounters.allocate(this.aeron, tempBuffer, 104, "archive-recorder work cycle time exceeded count: threshold=" + this.recorderCycleThresholdNs + "ns", this.archiveId), this.recorderCycleThresholdNs);
                    }
                    if (null == this.replayerDutyCycleTracker) {
                        this.replayerDutyCycleTracker = new DutyCycleStallTracker(ArchiveCounters.allocate(this.aeron, tempBuffer, 103, "archive-replayer max cycle time in ns", this.archiveId), ArchiveCounters.allocate(this.aeron, tempBuffer, 104, "archive-replayer work cycle time exceeded count: threshold=" + this.replayerCycleThresholdNs + "ns", this.archiveId), this.replayerCycleThresholdNs);
                    }
                }
                if (!BitUtil.isPowerOfTwo(this.segmentFileLength)) {
                    throw new ArchiveException("segment file length not a power of 2: " + this.segmentFileLength);
                }
                if (this.segmentFileLength < 65536 || this.segmentFileLength > 0x40000000) {
                    throw new ArchiveException("segment file length not in valid range: " + this.segmentFileLength);
                }
                if (null == this.authenticatorSupplier) {
                    this.authenticatorSupplier = Configuration.authenticatorSupplier();
                }
                if (null == this.authorisationServiceSupplier) {
                    this.authorisationServiceSupplier = Configuration.authorisationServiceSupplier();
                }
                this.concludeRecordChecksum();
                this.concludeReplayChecksum();
                if (null == this.catalog) {
                    this.catalog = new Catalog(this.archiveDir, this.archiveDirChannel, this.catalogFileSyncLevel, this.catalogCapacity, this.epochClock, this.recordChecksum, null != this.recordChecksum ? this.recordChecksumBuffer() : this.dataBuffer());
                }
                if (null == this.archiveClientContext) {
                    this.archiveClientContext = new AeronArchive.Context();
                }
                if (null == this.archiveClientContext.controlResponseChannel()) {
                    if (this.controlChannelEnabled) {
                        int separatorIndex;
                        ChannelUri controlChannelUri = ChannelUri.parse(this.controlChannel);
                        String endpoint = controlChannelUri.get("endpoint");
                        if (null == endpoint || -1 == (separatorIndex = endpoint.lastIndexOf(58))) {
                            throw new ConfigurationException("Unable to derive Archive.Context.archiveClientContext.controlResponseChannel as Archive.Context.controlChannel.endpoint=" + endpoint + " and is not in the <host>:<port> format");
                        }
                        String responseEndpoint = endpoint.substring(0, separatorIndex) + ":0";
                        String responseChannel = new ChannelUriStringBuilder().media("udp").endpoint(responseEndpoint).build();
                        this.archiveClientContext.controlResponseChannel(responseChannel);
                    } else {
                        throw new ConfigurationException("Archive.Context.archiveClientContext.controlResponseChannel must be set if Archive.Context.controlChannelEnabled is false");
                    }
                }
                this.archiveClientContext.aeron(this.aeron).lock(NoOpLock.INSTANCE).errorHandler(this.errorHandler);
                if (null == this.controlSessionsCounter) {
                    this.controlSessionsCounter = ArchiveCounters.allocate(this.aeron, tempBuffer, 102, "Archive Control Sessions", this.archiveId);
                }
                AeronCounters.validateCounterTypeId(this.aeron, this.controlSessionsCounter, 102);
                if (null == this.recordingSessionCounter) {
                    this.recordingSessionCounter = ArchiveCounters.allocate(this.aeron, tempBuffer, 111, "Archive Recording Sessions", this.archiveId);
                }
                AeronCounters.validateCounterTypeId(this.aeron, this.recordingSessionCounter, 111);
                if (null == this.replaySessionCounter) {
                    this.replaySessionCounter = ArchiveCounters.allocate(this.aeron, tempBuffer, 112, "Archive Replay Sessions", this.archiveId);
                }
                AeronCounters.validateCounterTypeId(this.aeron, this.replaySessionCounter, 112);
                if (null == this.maxWriteTimeCounter) {
                    int counterId = ArchiveCounters.find(this.aeron.countersReader(), 105, this.archiveId);
                    if (-1 != counterId) {
                        throw new ConfigurationException("existing max write time counter detected for archiveId=" + this.archiveId);
                    }
                    this.maxWriteTimeCounter = ArchiveCounters.allocate(this.aeron, tempBuffer, 105, "archive-recorder max write time in ns", this.archiveId);
                }
                AeronCounters.validateCounterTypeId(this.aeron, this.maxWriteTimeCounter, 105);
                if (null == this.totalWriteBytesCounter) {
                    this.totalWriteBytesCounter = ArchiveCounters.allocate(this.aeron, tempBuffer, 106, "archive-recorder total write bytes", this.archiveId);
                }
                AeronCounters.validateCounterTypeId(this.aeron, this.totalWriteBytesCounter, 106);
                if (null == this.totalWriteTimeCounter) {
                    this.totalWriteTimeCounter = ArchiveCounters.allocate(this.aeron, tempBuffer, 107, "archive-recorder total write time in ns", this.archiveId);
                }
                AeronCounters.validateCounterTypeId(this.aeron, this.totalWriteTimeCounter, 107);
                if (null == this.maxReadTimeCounter) {
                    this.maxReadTimeCounter = ArchiveCounters.allocate(this.aeron, tempBuffer, 108, "archive-replayer max read time in ns", this.archiveId);
                }
                AeronCounters.validateCounterTypeId(this.aeron, this.maxReadTimeCounter, 108);
                if (null == this.totalReadBytesCounter) {
                    this.totalReadBytesCounter = ArchiveCounters.allocate(this.aeron, tempBuffer, 109, "archive-replayer total read bytes", this.archiveId);
                }
                AeronCounters.validateCounterTypeId(this.aeron, this.totalReadBytesCounter, 109);
                if (null == this.totalReadTimeCounter) {
                    this.totalReadTimeCounter = ArchiveCounters.allocate(this.aeron, tempBuffer, 110, "archive-replayer total read time in ns", this.archiveId);
                }
                AeronCounters.validateCounterTypeId(this.aeron, this.totalReadTimeCounter, 110);
                int expectedCount = ArchiveThreadingMode.DEDICATED == this.threadingMode ? 2 : 0;
                this.abortLatch = new CountDownLatch(expectedCount += this.aeron.conductorAgentInvoker() == null ? 1 : 0);
                this.markFile.updateActivityTimestamp(this.epochClock.time());
            }
            finally {
                this.markFile.signalReady();
                this.markFile.force();
            }
            if (io.aeron.driver.Configuration.printConfigurationOnStart()) {
                System.out.println(this);
            }
        }

        public boolean isConcluded() {
            return 1 == this.isConcluded;
        }

        public Context deleteArchiveOnStart(boolean deleteArchiveOnStart) {
            this.deleteArchiveOnStart = deleteArchiveOnStart;
            return this;
        }

        public boolean deleteArchiveOnStart() {
            return this.deleteArchiveOnStart;
        }

        public Context archiveDirectoryName(String archiveDirectoryName) {
            this.archiveDirectoryName = archiveDirectoryName;
            return this;
        }

        public String archiveDirectoryName() {
            return this.archiveDirectoryName;
        }

        public File archiveDir() {
            return this.archiveDir;
        }

        public Context archiveDir(File archiveDir) {
            this.archiveDir = archiveDir;
            return this;
        }

        public File markFileDir() {
            return this.markFileDir;
        }

        public Context markFileDir(File markFileDir) {
            this.markFileDir = markFileDir;
            return this;
        }

        public FileStore archiveFileStore() {
            return this.archiveFileStore;
        }

        public Context archiveFileStore(FileStore fileStore) {
            this.archiveFileStore = fileStore;
            return this;
        }

        public FileChannel archiveDirChannel() {
            return this.archiveDirChannel;
        }

        Context archiveDirChannel(FileChannel archiveDirChannel) {
            this.archiveDirChannel = archiveDirChannel;
            return this;
        }

        public Context archiveClientContext(AeronArchive.Context archiveContext) {
            this.archiveClientContext = archiveContext;
            return this;
        }

        public AeronArchive.Context archiveClientContext() {
            return this.archiveClientContext;
        }

        public boolean controlChannelEnabled() {
            return this.controlChannelEnabled;
        }

        public Context controlChannelEnabled(boolean controlChannelEnabled) {
            this.controlChannelEnabled = controlChannelEnabled;
            return this;
        }

        public String controlChannel() {
            return this.controlChannel;
        }

        public Context controlChannel(String controlChannel) {
            this.controlChannel = controlChannel;
            return this;
        }

        public int controlStreamId() {
            return this.controlStreamId;
        }

        public Context controlStreamId(int controlStreamId) {
            this.controlStreamId = controlStreamId;
            return this;
        }

        public String localControlChannel() {
            return this.localControlChannel;
        }

        public Context localControlChannel(String controlChannel) {
            this.localControlChannel = controlChannel;
            return this;
        }

        public int localControlStreamId() {
            return this.localControlStreamId;
        }

        public Context controlTermBufferSparse(boolean controlTermBufferSparse) {
            this.controlTermBufferSparse = controlTermBufferSparse;
            return this;
        }

        public boolean controlTermBufferSparse() {
            return this.controlTermBufferSparse;
        }

        public Context controlTermBufferLength(int controlTermBufferLength) {
            this.controlTermBufferLength = controlTermBufferLength;
            return this;
        }

        public int controlTermBufferLength() {
            return this.controlTermBufferLength;
        }

        public Context controlMtuLength(int controlMtuLength) {
            this.controlMtuLength = controlMtuLength;
            return this;
        }

        public int controlMtuLength() {
            return this.controlMtuLength;
        }

        public Context localControlStreamId(int controlStreamId) {
            this.localControlStreamId = controlStreamId;
            return this;
        }

        public String recordingEventsChannel() {
            return this.recordingEventsChannel;
        }

        public Context recordingEventsChannel(String recordingEventsChannel) {
            this.recordingEventsChannel = recordingEventsChannel;
            return this;
        }

        public int recordingEventsStreamId() {
            return this.recordingEventsStreamId;
        }

        public Context recordingEventsStreamId(int recordingEventsStreamId) {
            this.recordingEventsStreamId = recordingEventsStreamId;
            return this;
        }

        public boolean recordingEventsEnabled() {
            return this.recordingEventsEnabled;
        }

        public Context recordingEventsEnabled(boolean recordingEventsEnabled) {
            this.recordingEventsEnabled = recordingEventsEnabled;
            return this;
        }

        public String replicationChannel() {
            return this.replicationChannel;
        }

        public Context replicationChannel(String replicationChannel) {
            this.replicationChannel = replicationChannel;
            return this;
        }

        public Context connectTimeoutNs(long connectTimeoutNs) {
            this.connectTimeoutNs = connectTimeoutNs;
            return this;
        }

        public long connectTimeoutNs() {
            return this.connectTimeoutNs;
        }

        public Context replayLingerTimeoutNs(long replayLingerTimeoutNs) {
            this.replayLingerTimeoutNs = replayLingerTimeoutNs;
            return this;
        }

        public long replayLingerTimeoutNs() {
            return this.replayLingerTimeoutNs;
        }

        public Context conductorCycleThresholdNs(long thresholdNs) {
            this.conductorCycleThresholdNs = thresholdNs;
            return this;
        }

        public long conductorCycleThresholdNs() {
            return this.conductorCycleThresholdNs;
        }

        public Context recorderCycleThresholdNs(long thresholdNs) {
            this.recorderCycleThresholdNs = thresholdNs;
            return this;
        }

        public long recorderCycleThresholdNs() {
            return this.recorderCycleThresholdNs;
        }

        public Context replayerCycleThresholdNs(long thresholdNs) {
            this.replayerCycleThresholdNs = thresholdNs;
            return this;
        }

        public long replayerCycleThresholdNs() {
            return this.replayerCycleThresholdNs;
        }

        public Context conductorDutyCycleTracker(DutyCycleTracker dutyCycleTracker) {
            this.conductorDutyCycleTracker = dutyCycleTracker;
            return this;
        }

        public DutyCycleTracker conductorDutyCycleTracker() {
            return this.conductorDutyCycleTracker;
        }

        public Context recorderDutyCycleTracker(DutyCycleTracker dutyCycleTracker) {
            this.recorderDutyCycleTracker = dutyCycleTracker;
            return this;
        }

        public DutyCycleTracker recorderDutyCycleTracker() {
            return this.recorderDutyCycleTracker;
        }

        public Context replayerDutyCycleTracker(DutyCycleTracker dutyCycleTracker) {
            this.replayerDutyCycleTracker = dutyCycleTracker;
            return this;
        }

        public DutyCycleTracker replayerDutyCycleTracker() {
            return this.replayerDutyCycleTracker;
        }

        public Context recordChecksum(Checksum recordChecksum) {
            this.recordChecksum = recordChecksum;
            return this;
        }

        public Checksum recordChecksum() {
            return this.recordChecksum;
        }

        public Context replayChecksum(Checksum replayChecksum) {
            this.replayChecksum = replayChecksum;
            return this;
        }

        public Checksum replayChecksum() {
            return this.replayChecksum;
        }

        public Context idleStrategySupplier(Supplier<IdleStrategy> idleStrategySupplier) {
            this.idleStrategySupplier = idleStrategySupplier;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategySupplier.get();
        }

        public Context recorderIdleStrategySupplier(Supplier<IdleStrategy> idleStrategySupplier) {
            this.recorderIdleStrategySupplier = idleStrategySupplier;
            return this;
        }

        public IdleStrategy recorderIdleStrategy() {
            return this.recorderIdleStrategySupplier.get();
        }

        public Context replayerIdleStrategySupplier(Supplier<IdleStrategy> idleStrategySupplier) {
            this.replayerIdleStrategySupplier = idleStrategySupplier;
            return this;
        }

        public IdleStrategy replayerIdleStrategy() {
            return this.replayerIdleStrategySupplier.get();
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public Context nanoClock(NanoClock clock) {
            this.nanoClock = clock;
            return this;
        }

        public NanoClock nanoClock() {
            return this.nanoClock;
        }

        int segmentFileLength() {
            return this.segmentFileLength;
        }

        public Context segmentFileLength(int segmentFileLength) {
            this.segmentFileLength = segmentFileLength;
            return this;
        }

        int fileSyncLevel() {
            return this.fileSyncLevel;
        }

        public Context fileSyncLevel(int syncLevel) {
            this.fileSyncLevel = syncLevel;
            return this;
        }

        int catalogFileSyncLevel() {
            return this.catalogFileSyncLevel;
        }

        public Context catalogFileSyncLevel(int syncLevel) {
            this.catalogFileSyncLevel = syncLevel;
            return this;
        }

        AgentInvoker mediaDriverAgentInvoker() {
            return this.mediaDriverAgentInvoker;
        }

        public Context mediaDriverAgentInvoker(AgentInvoker mediaDriverAgentInvoker) {
            this.mediaDriverAgentInvoker = mediaDriverAgentInvoker;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Context countedErrorHandler(CountedErrorHandler countedErrorHandler) {
            this.countedErrorHandler = countedErrorHandler;
            return this;
        }

        public CountedErrorHandler countedErrorHandler() {
            return this.countedErrorHandler;
        }

        public ArchiveThreadingMode threadingMode() {
            return this.threadingMode;
        }

        public Context threadingMode(ArchiveThreadingMode threadingMode) {
            this.threadingMode = threadingMode;
            return this;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        public Context threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public ThreadFactory recorderThreadFactory() {
            return this.recorderThreadFactory;
        }

        public Context recorderThreadFactory(ThreadFactory threadFactory) {
            this.recorderThreadFactory = threadFactory;
            return this;
        }

        public ThreadFactory replayerThreadFactory() {
            return this.replayerThreadFactory;
        }

        public Context replayerThreadFactory(ThreadFactory threadFactory) {
            this.replayerThreadFactory = threadFactory;
            return this;
        }

        public Context errorBufferLength(int errorBufferLength) {
            this.errorBufferLength = errorBufferLength;
            return this;
        }

        public int errorBufferLength() {
            return this.errorBufferLength;
        }

        public Context archiveId(long archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public long archiveId() {
            return this.archiveId;
        }

        public AtomicCounter errorCounter() {
            return this.errorCounter;
        }

        public Context errorCounter(AtomicCounter errorCounter) {
            this.errorCounter = errorCounter;
            return this;
        }

        public Counter controlSessionsCounter() {
            return this.controlSessionsCounter;
        }

        public Context controlSessionsCounter(Counter controlSessionsCounter) {
            this.controlSessionsCounter = controlSessionsCounter;
            return this;
        }

        public Counter recordingSessionCounter() {
            return this.recordingSessionCounter;
        }

        public Context recordingSessionCounter(Counter counter) {
            this.recordingSessionCounter = counter;
            return this;
        }

        public Counter replaySessionCounter() {
            return this.replaySessionCounter;
        }

        public Context replaySessionCounter(Counter counter) {
            this.replaySessionCounter = counter;
            return this;
        }

        public Counter totalWriteBytesCounter() {
            return this.totalWriteBytesCounter;
        }

        public Context totalWriteBytesCounter(Counter counter) {
            this.totalWriteBytesCounter = counter;
            return this;
        }

        public Counter totalWriteTimeCounter() {
            return this.totalWriteTimeCounter;
        }

        public Context totalWriteTimeCounter(Counter counter) {
            this.totalWriteTimeCounter = counter;
            return this;
        }

        public Counter maxWriteTimeCounter() {
            return this.maxWriteTimeCounter;
        }

        public Context maxWriteTimeCounter(Counter counter) {
            this.maxWriteTimeCounter = counter;
            return this;
        }

        public Counter totalReadBytesCounter() {
            return this.totalReadBytesCounter;
        }

        public Context totalReadBytesCounter(Counter counter) {
            this.totalReadBytesCounter = counter;
            return this;
        }

        public Counter totalReadTimeCounter() {
            return this.totalReadTimeCounter;
        }

        public Context totalReadTimeCounter(Counter counter) {
            this.totalReadTimeCounter = counter;
            return this;
        }

        public Counter maxReadTimeCounter() {
            return this.maxReadTimeCounter;
        }

        public Context maxReadTimeCounter(Counter counter) {
            this.maxReadTimeCounter = counter;
            return this;
        }

        public int maxConcurrentRecordings() {
            return this.maxConcurrentRecordings;
        }

        public Context maxConcurrentRecordings(int maxConcurrentRecordings) {
            this.maxConcurrentRecordings = maxConcurrentRecordings;
            return this;
        }

        public int maxConcurrentReplays() {
            return this.maxConcurrentReplays;
        }

        public Context maxConcurrentReplays(int maxConcurrentReplays) {
            this.maxConcurrentReplays = maxConcurrentReplays;
            return this;
        }

        public int fileIoMaxLength() {
            return this.fileIoMaxLength;
        }

        public Context fileIoMaxLength(int fileIoMaxLength) {
            this.fileIoMaxLength = fileIoMaxLength;
            return this;
        }

        public Context lowStorageSpaceThreshold(long lowStorageSpaceThreshold) {
            this.lowStorageSpaceThreshold = lowStorageSpaceThreshold;
            return this;
        }

        public long lowStorageSpaceThreshold() {
            return this.lowStorageSpaceThreshold;
        }

        @Deprecated
        public void deleteArchiveDirectory() {
            this.deleteDirectory();
        }

        public void deleteDirectory() {
            if (null != this.archiveDir) {
                IoUtil.delete(this.archiveDir, false);
            }
        }

        public Context aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Context aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public Aeron aeron() {
            return this.aeron;
        }

        public Context ownsAeronClient(boolean ownsAeronClient) {
            this.ownsAeronClient = ownsAeronClient;
            return this;
        }

        public boolean ownsAeronClient() {
            return this.ownsAeronClient;
        }

        Context catalog(Catalog catalog) {
            this.catalog = catalog;
            return this;
        }

        Catalog catalog() {
            return this.catalog;
        }

        public Context archiveMarkFile(ArchiveMarkFile archiveMarkFile) {
            this.markFile = archiveMarkFile;
            return this;
        }

        public ArchiveMarkFile archiveMarkFile() {
            return this.markFile;
        }

        @Deprecated
        public Context maxCatalogEntries(long maxCatalogEntries) {
            return this;
        }

        @Deprecated
        public long maxCatalogEntries() {
            return -1L;
        }

        public Context catalogCapacity(long catalogCapacity) {
            this.catalogCapacity = catalogCapacity;
            return this;
        }

        public long catalogCapacity() {
            return this.catalogCapacity;
        }

        public AuthenticatorSupplier authenticatorSupplier() {
            return this.authenticatorSupplier;
        }

        public Context authenticatorSupplier(AuthenticatorSupplier authenticatorSupplier) {
            this.authenticatorSupplier = authenticatorSupplier;
            return this;
        }

        public AuthorisationServiceSupplier authorisationServiceSupplier() {
            return this.authorisationServiceSupplier;
        }

        public Context authorisationServiceSupplier(AuthorisationServiceSupplier authorisationServiceSupplier) {
            this.authorisationServiceSupplier = authorisationServiceSupplier;
            return this;
        }

        CountDownLatch abortLatch() {
            return this.abortLatch;
        }

        void concludeRecordChecksum() {
            String checksumClass;
            if (null == this.recordChecksum && !Strings.isEmpty(checksumClass = Configuration.recordChecksum())) {
                this.recordChecksum = Checksums.newInstance(checksumClass);
            }
        }

        void concludeReplayChecksum() {
            String checksumClass;
            if (null == this.replayChecksum && !Strings.isEmpty(checksumClass = Configuration.replayChecksum())) {
                this.replayChecksum = Checksums.newInstance(checksumClass);
            }
        }

        Context dataBuffer(UnsafeBuffer dataBuffer) {
            this.dataBuffer = dataBuffer;
            return this;
        }

        UnsafeBuffer dataBuffer() {
            if (null == this.dataBuffer) {
                this.dataBuffer = new UnsafeBuffer(BufferUtil.allocateDirectAligned(this.fileIoMaxLength, 64));
            }
            return this.dataBuffer;
        }

        Context replayBuffer(UnsafeBuffer replayBuffer) {
            this.replayBuffer = replayBuffer;
            return this;
        }

        UnsafeBuffer replayBuffer() {
            if (ArchiveThreadingMode.DEDICATED != this.threadingMode) {
                return this.dataBuffer();
            }
            if (null == this.replayBuffer) {
                this.replayBuffer = new UnsafeBuffer(BufferUtil.allocateDirectAligned(this.fileIoMaxLength, 64));
            }
            return this.replayBuffer;
        }

        Context recordChecksumBuffer(UnsafeBuffer recordChecksumBuffer) {
            this.recordChecksumBuffer = recordChecksumBuffer;
            return this;
        }

        UnsafeBuffer recordChecksumBuffer() {
            if (null == this.recordChecksum) {
                return null;
            }
            if (ArchiveThreadingMode.DEDICATED != this.threadingMode) {
                return this.dataBuffer();
            }
            if (null == this.recordChecksumBuffer) {
                this.recordChecksumBuffer = new UnsafeBuffer(BufferUtil.allocateDirectAligned(this.fileIoMaxLength, 64));
            }
            return this.recordChecksumBuffer;
        }

        public void close() {
            CloseHelper.close(this.countedErrorHandler, this.archiveDirChannel);
            CloseHelper.close(this.countedErrorHandler, this.catalog);
            if (this.ownsAeronClient) {
                CloseHelper.close(this.aeron);
            } else {
                CloseHelper.close(this.countedErrorHandler, this.controlSessionsCounter);
                CloseHelper.close(this.countedErrorHandler, this.recordingSessionCounter);
                CloseHelper.close(this.countedErrorHandler, this.replaySessionCounter);
                CloseHelper.close(this.countedErrorHandler, this.totalWriteBytesCounter);
                CloseHelper.close(this.countedErrorHandler, this.totalWriteTimeCounter);
                CloseHelper.close(this.countedErrorHandler, this.maxWriteTimeCounter);
                CloseHelper.close(this.countedErrorHandler, this.totalReadBytesCounter);
                CloseHelper.close(this.countedErrorHandler, this.totalReadTimeCounter);
                CloseHelper.close(this.countedErrorHandler, this.maxReadTimeCounter);
                this.closeDutyCycleCounters(this.conductorDutyCycleTracker);
                this.closeDutyCycleCounters(this.recorderDutyCycleTracker);
                this.closeDutyCycleCounters(this.replayerDutyCycleTracker);
                CloseHelper.close(this.errorCounter);
            }
            if (this.errorHandler instanceof AutoCloseable) {
                CloseHelper.close((AutoCloseable)((Object)this.errorHandler));
            }
            CloseHelper.close(this.markFile);
        }

        private void closeDutyCycleCounters(DutyCycleTracker dutyCycleTracker) {
            if (dutyCycleTracker instanceof DutyCycleStallTracker) {
                DutyCycleStallTracker dutyCycleStallTracker = (DutyCycleStallTracker)dutyCycleTracker;
                CloseHelper.close(this.countedErrorHandler, dutyCycleStallTracker.maxCycleTime());
                CloseHelper.close(this.countedErrorHandler, dutyCycleStallTracker.cycleTimeThresholdExceededCount());
            }
        }

        private void concludeArchiveId() {
            if (-1L == this.archiveId) {
                this.archiveId = this.aeron.clientId();
            }
        }

        public String toString() {
            return "Archive.Context\n{\n    isConcluded=" + this.isConcluded() + "\n    deleteArchiveOnStart=" + this.deleteArchiveOnStart + "\n    ownsAeronClient=" + this.ownsAeronClient + "\n    aeronDirectoryName='" + this.aeronDirectoryName + '\'' + "\n    aeron=" + this.aeron + "\n    archiveDir=" + this.archiveDir + "\n    archiveDirectoryName='" + this.archiveDirectoryName + '\'' + "\n    archiveDirChannel=" + this.archiveDirChannel + "\n    archiveFileStore=" + this.archiveFileStore + "\n    archiveId=" + this.archiveId + "\n    catalog=" + this.catalog + "\n    markFile=" + this.markFile + "\n    archiveClientContext=" + this.archiveClientContext + "\n    mediaDriverAgentInvoker=" + this.mediaDriverAgentInvoker + "\n    controlChannel='" + this.controlChannel + '\'' + "\n    controlStreamId=" + this.controlStreamId + "\n    localControlChannel='" + this.localControlChannel + '\'' + "\n    localControlStreamId=" + this.localControlStreamId + "\n    controlTermBufferSparse=" + this.controlTermBufferSparse + "\n    controlTermBufferLength=" + this.controlTermBufferLength + "\n    controlMtuLength=" + this.controlMtuLength + "\n    recordingEventsChannel='" + this.recordingEventsChannel + '\'' + "\n    recordingEventsStreamId=" + this.recordingEventsStreamId + "\n    recordingEventsEnabled=" + this.recordingEventsEnabled + "\n    replicationChannel='" + this.replicationChannel + '\'' + "\n    connectTimeoutNs=" + this.connectTimeoutNs + "\n    replayLingerTimeoutNs=" + this.replayLingerTimeoutNs + "\n    maxCatalogEntries=" + -1 + "\n    catalogCapacity=" + this.catalogCapacity + "\n    lowStorageSpaceThreshold=" + this.lowStorageSpaceThreshold + "\n    segmentFileLength=" + this.segmentFileLength + "\n    fileSyncLevel=" + this.fileSyncLevel + "\n    catalogFileSyncLevel=" + this.catalogFileSyncLevel + "\n    maxConcurrentRecordings=" + this.maxConcurrentRecordings + "\n    maxConcurrentReplays=" + this.maxConcurrentReplays + "\n    fileIoMaxLength=" + this.fileIoMaxLength + "\n    threadingMode=" + (Object)((Object)this.threadingMode) + "\n    threadFactory=" + this.threadFactory + "\n    abortLatch=" + this.abortLatch + "\n    idleStrategySupplier=" + this.idleStrategySupplier + "\n    replayerIdleStrategySupplier=" + this.replayerIdleStrategySupplier + "\n    recorderIdleStrategySupplier=" + this.recorderIdleStrategySupplier + "\n    epochClock=" + this.epochClock + "\n    authenticatorSupplier=" + this.authenticatorSupplier + "\n    controlSessionsCounter=" + this.controlSessionsCounter + "\n    recordingSessionCounter=" + this.recordingSessionCounter + "\n    replaySessionCounter=" + this.replaySessionCounter + "\n    errorBufferLength=" + this.errorBufferLength + "\n    errorHandler=" + this.errorHandler + "\n    errorCounter=" + this.errorCounter + "\n    countedErrorHandler=" + this.countedErrorHandler + "\n    recordChecksum=" + this.recordChecksum + "\n    replayChecksum=" + this.replayChecksum + "\n    dataBuffer=" + this.dataBuffer + "\n    replayBuffer=" + this.replayBuffer + "\n    recordChecksumBuffer=" + this.recordChecksumBuffer + "\n    conductorCycleThresholdNs=" + this.conductorCycleThresholdNs + "\n    recorderCycleThresholdNs=" + this.recorderCycleThresholdNs + "\n    replayerCycleThresholdNs=" + this.replayerCycleThresholdNs + "\n    conductorDutyCycleTracker=" + this.conductorDutyCycleTracker + "\n    recorderDutyCycleTracker=" + this.recorderDutyCycleTracker + "\n    replayerDutyCycleTracker=" + this.replayerDutyCycleTracker + "\n    totalWriteBytesCounter=" + this.totalWriteBytesCounter + "\n    totalWriteTimeCounter=" + this.totalWriteTimeCounter + "\n    maxWriteTimeCounter=" + this.maxWriteTimeCounter + "\n    totalReadBytesCounter=" + this.totalReadBytesCounter + "\n    totalReadTimeCounter=" + this.totalReadTimeCounter + "\n    maxReadTimeCounter=" + this.maxReadTimeCounter + "\n}";
        }
    }

    public static final class Configuration {
        static final String CATALOG_FILE_NAME = "archive.catalog";
        static final String RECORDING_SEGMENT_SUFFIX = ".rec";
        public static final int FILE_IO_MAX_LENGTH_DEFAULT = 0x100000;
        public static final String FILE_IO_MAX_LENGTH_PROP_NAME = "aeron.archive.file.io.max.length";
        public static final String ARCHIVE_DIR_PROP_NAME = "aeron.archive.dir";
        public static final String ARCHIVE_DIR_DEFAULT = "aeron-archive";
        public static final String MARK_FILE_DIR_PROP_NAME = "aeron.archive.mark.file.dir";
        public static final String SEGMENT_FILE_LENGTH_PROP_NAME = "aeron.archive.segment.file.length";
        public static final int SEGMENT_FILE_LENGTH_DEFAULT = 0x8000000;
        public static final String LOW_STORAGE_SPACE_THRESHOLD_PROP_NAME = "aeron.archive.low.storage.space.threshold";
        public static final int LOW_STORAGE_SPACE_THRESHOLD_DEFAULT = 0x8000000;
        public static final String FILE_SYNC_LEVEL_PROP_NAME = "aeron.archive.file.sync.level";
        public static final int FILE_SYNC_LEVEL_DEFAULT = 0;
        public static final String CATALOG_FILE_SYNC_LEVEL_PROP_NAME = "aeron.archive.catalog.file.sync.level";
        public static final int CATALOG_FILE_SYNC_LEVEL_DEFAULT = 0;
        public static final String THREADING_MODE_PROP_NAME = "aeron.archive.threading.mode";
        public static final String ARCHIVE_IDLE_STRATEGY_PROP_NAME = "aeron.archive.idle.strategy";
        public static final String ARCHIVE_RECORDER_IDLE_STRATEGY_PROP_NAME = "aeron.archive.recorder.idle.strategy";
        public static final String ARCHIVE_REPLAYER_IDLE_STRATEGY_PROP_NAME = "aeron.archive.replayer.idle.strategy";
        public static final String DEFAULT_IDLE_STRATEGY = "org.agrona.concurrent.BackoffIdleStrategy";
        public static final String MAX_CONCURRENT_RECORDINGS_PROP_NAME = "aeron.archive.max.concurrent.recordings";
        public static final int MAX_CONCURRENT_RECORDINGS_DEFAULT = 20;
        public static final String MAX_CONCURRENT_REPLAYS_PROP_NAME = "aeron.archive.max.concurrent.replays";
        public static final int MAX_CONCURRENT_REPLAYS_DEFAULT = 20;
        @Deprecated
        public static final String MAX_CATALOG_ENTRIES_PROP_NAME = "aeron.archive.max.catalog.entries";
        @Deprecated
        public static final long MAX_CATALOG_ENTRIES_DEFAULT = 8192L;
        public static final String CATALOG_CAPACITY_PROP_NAME = "aeron.archive.catalog.capacity";
        public static final long CATALOG_CAPACITY_DEFAULT = 0x100000L;
        public static final String CONNECT_TIMEOUT_PROP_NAME = "aeron.archive.connect.timeout";
        public static final long CONNECT_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(5L);
        public static final String REPLAY_LINGER_TIMEOUT_PROP_NAME = "aeron.archive.replay.linger.timeout";
        public static final long REPLAY_LINGER_TIMEOUT_DEFAULT_NS = io.aeron.driver.Configuration.publicationLingerTimeoutNs();
        public static final String CONDUCTOR_CYCLE_THRESHOLD_PROP_NAME = "aeron.archive.conductor.cycle.threshold";
        public static final long CONDUCTOR_CYCLE_THRESHOLD_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(1000L);
        public static final String RECORDER_CYCLE_THRESHOLD_PROP_NAME = "aeron.archive.recorder.cycle.threshold";
        public static final long RECORDER_CYCLE_THRESHOLD_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(1000L);
        public static final String REPLAYER_CYCLE_THRESHOLD_PROP_NAME = "aeron.archive.replayer.cycle.threshold";
        public static final long REPLAYER_CYCLE_THRESHOLD_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(1000L);
        public static final String ARCHIVE_DIR_DELETE_ON_START_PROP_NAME = "aeron.archive.dir.delete.on.start";
        public static final String REPLICATION_CHANNEL_PROP_NAME = "aeron.archive.replication.channel";
        public static final String AUTHENTICATOR_SUPPLIER_PROP_NAME = "aeron.archive.authenticator.supplier";
        public static final String AUTHENTICATOR_SUPPLIER_DEFAULT = "io.aeron.security.DefaultAuthenticatorSupplier";
        public static final String AUTHORISATION_SERVICE_SUPPLIER_PROP_NAME = "aeron.archive.authorisation.service.supplier";
        public static final AuthorisationServiceSupplier DEFAULT_AUTHORISATION_SERVICE_SUPPLIER = () -> AuthorisationService.ALLOW_ALL;
        public static final int ARCHIVE_ERROR_COUNT_TYPE_ID = 101;
        public static final int ARCHIVE_CONTROL_SESSIONS_TYPE_ID = 102;
        public static final String ERROR_BUFFER_LENGTH_PROP_NAME = "aeron.archive.error.buffer.length";
        public static final int ERROR_BUFFER_LENGTH_DEFAULT = 0x100000;
        public static final String RECORD_CHECKSUM_PROP_NAME = "aeron.archive.record.checksum";
        public static final String REPLAY_CHECKSUM_PROP_NAME = "aeron.archive.replay.checksum";
        public static final String ARCHIVE_ID_PROP_NAME = "aeron.archive.id";
        public static final String CONTROL_CHANNEL_ENABLED_PROP_NAME = "aeron.archive.control.channel.enabled";
        static final long MARK_FILE_UPDATE_INTERVAL_MS = TimeUnit.SECONDS.toMillis(1L);
        static final long LIVENESS_TIMEOUT_MS = 10L * MARK_FILE_UPDATE_INTERVAL_MS;

        public static String archiveDirName() {
            return System.getProperty(ARCHIVE_DIR_PROP_NAME, ARCHIVE_DIR_DEFAULT);
        }

        public static String markFileDir() {
            return System.getProperty(MARK_FILE_DIR_PROP_NAME);
        }

        public static int fileIoMaxLength() {
            return SystemUtil.getSizeAsInt(FILE_IO_MAX_LENGTH_PROP_NAME, 0x100000);
        }

        public static int segmentFileLength() {
            return SystemUtil.getSizeAsInt(SEGMENT_FILE_LENGTH_PROP_NAME, 0x8000000);
        }

        public static long lowStorageSpaceThreshold() {
            return SystemUtil.getSizeAsLong(LOW_STORAGE_SPACE_THRESHOLD_PROP_NAME, 0x8000000L);
        }

        public static int fileSyncLevel() {
            return Integer.getInteger(FILE_SYNC_LEVEL_PROP_NAME, 0);
        }

        public static int catalogFileSyncLevel() {
            return Integer.getInteger(CATALOG_FILE_SYNC_LEVEL_PROP_NAME, 0);
        }

        public static ArchiveThreadingMode threadingMode() {
            return ArchiveThreadingMode.valueOf(System.getProperty(THREADING_MODE_PROP_NAME, ArchiveThreadingMode.DEDICATED.name()));
        }

        public static Supplier<IdleStrategy> idleStrategySupplier(StatusIndicator controllableStatus) {
            return () -> {
                String name = System.getProperty(ARCHIVE_IDLE_STRATEGY_PROP_NAME, DEFAULT_IDLE_STRATEGY);
                return io.aeron.driver.Configuration.agentIdleStrategy(name, controllableStatus);
            };
        }

        public static Supplier<IdleStrategy> recorderIdleStrategySupplier(StatusIndicator controllableStatus) {
            String name = System.getProperty(ARCHIVE_RECORDER_IDLE_STRATEGY_PROP_NAME);
            if (null == name) {
                return null;
            }
            return () -> io.aeron.driver.Configuration.agentIdleStrategy(name, controllableStatus);
        }

        public static Supplier<IdleStrategy> replayerIdleStrategySupplier(StatusIndicator controllableStatus) {
            String name = System.getProperty(ARCHIVE_REPLAYER_IDLE_STRATEGY_PROP_NAME);
            if (null == name) {
                return null;
            }
            return () -> io.aeron.driver.Configuration.agentIdleStrategy(name, controllableStatus);
        }

        public static int maxConcurrentRecordings() {
            return Integer.getInteger(MAX_CONCURRENT_RECORDINGS_PROP_NAME, 20);
        }

        public static int maxConcurrentReplays() {
            return Integer.getInteger(MAX_CONCURRENT_REPLAYS_PROP_NAME, 20);
        }

        @Deprecated
        public static long maxCatalogEntries() {
            return SystemUtil.getSizeAsLong(MAX_CATALOG_ENTRIES_PROP_NAME, 8192L);
        }

        public static long catalogCapacity() {
            return SystemUtil.getSizeAsLong(CATALOG_CAPACITY_PROP_NAME, 0x100000L);
        }

        public static long connectTimeoutNs() {
            return SystemUtil.getDurationInNanos(CONNECT_TIMEOUT_PROP_NAME, CONNECT_TIMEOUT_DEFAULT_NS);
        }

        public static long replayLingerTimeoutNs() {
            return SystemUtil.getDurationInNanos(REPLAY_LINGER_TIMEOUT_PROP_NAME, REPLAY_LINGER_TIMEOUT_DEFAULT_NS);
        }

        public static long conductorCycleThresholdNs() {
            return SystemUtil.getDurationInNanos(CONDUCTOR_CYCLE_THRESHOLD_PROP_NAME, CONDUCTOR_CYCLE_THRESHOLD_DEFAULT_NS);
        }

        public static long recorderCycleThresholdNs() {
            return SystemUtil.getDurationInNanos(RECORDER_CYCLE_THRESHOLD_PROP_NAME, RECORDER_CYCLE_THRESHOLD_DEFAULT_NS);
        }

        public static long replayerCycleThresholdNs() {
            return SystemUtil.getDurationInNanos(REPLAYER_CYCLE_THRESHOLD_PROP_NAME, REPLAYER_CYCLE_THRESHOLD_DEFAULT_NS);
        }

        public static boolean deleteArchiveOnStart() {
            return "true".equals(System.getProperty(ARCHIVE_DIR_DELETE_ON_START_PROP_NAME, "false"));
        }

        public static String replicationChannel() {
            return System.getProperty(REPLICATION_CHANNEL_PROP_NAME);
        }

        public static int errorBufferLength() {
            return SystemUtil.getSizeAsInt(ERROR_BUFFER_LENGTH_PROP_NAME, 0x100000);
        }

        public static AuthenticatorSupplier authenticatorSupplier() {
            String supplierClassName = System.getProperty(AUTHENTICATOR_SUPPLIER_PROP_NAME, AUTHENTICATOR_SUPPLIER_DEFAULT);
            AuthenticatorSupplier supplier = null;
            try {
                supplier = (AuthenticatorSupplier)Class.forName(supplierClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked(ex);
            }
            return supplier;
        }

        public static AuthorisationServiceSupplier authorisationServiceSupplier() {
            String supplierClassName = System.getProperty(AUTHORISATION_SERVICE_SUPPLIER_PROP_NAME);
            if (Strings.isEmpty(supplierClassName)) {
                return DEFAULT_AUTHORISATION_SERVICE_SUPPLIER;
            }
            try {
                return (AuthorisationServiceSupplier)Class.forName(supplierClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked(ex);
                return null;
            }
        }

        public static String recordChecksum() {
            return System.getProperty(RECORD_CHECKSUM_PROP_NAME);
        }

        public static String replayChecksum() {
            return System.getProperty(REPLAY_CHECKSUM_PROP_NAME);
        }

        public static boolean controlChannelEnabled() {
            return "true".equals(System.getProperty(CONTROL_CHANNEL_ENABLED_PROP_NAME, "true"));
        }

        public static long archiveId() {
            String prop = System.getProperty(ARCHIVE_ID_PROP_NAME);
            if (!Strings.isEmpty(prop)) {
                return AsciiEncoding.parseLongAscii(prop, 0, prop.length());
            }
            return -1L;
        }
    }
}

