/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.config.validation;

import io.aeron.config.ConfigInfo;
import io.aeron.config.DefaultType;
import io.aeron.config.ExpectedCConfig;
import io.aeron.config.validation.Validation;
import io.aeron.config.validation.ValidationReport;
import io.aeron.validation.Grep;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

final class Validator {
    private final String sourceDir;
    private final ScriptEngine scriptEngine;
    private final ValidationReport report;

    static ValidationReport validate(Collection<ConfigInfo> configInfoCollection, String sourceDir) {
        return new Validator((String)sourceDir).validate(configInfoCollection).report;
    }

    private Validator(String sourceDir) {
        this.sourceDir = sourceDir;
        this.scriptEngine = new ScriptEngineManager().getEngineByName("JavaScript");
        this.report = new ValidationReport();
    }

    private Validator validate(Collection<ConfigInfo> configInfoCollection) {
        configInfoCollection.forEach(this::validateCExpectations);
        return this;
    }

    private void validateCExpectations(ConfigInfo configInfo) {
        this.report.addEntry(configInfo, this::validateCEnvVar, this::validateCDefault);
    }

    private void validateCEnvVar(Validation validation, ExpectedCConfig c) {
        if (Objects.isNull(c.envVarFieldName)) {
            return;
        }
        String pattern = "#define[ \t]+" + c.envVarFieldName + "[ \t]+\"" + c.envVar + "\"";
        Grep grep = Grep.execute(pattern, this.sourceDir);
        if (grep.success()) {
            validation.valid("Expected Env Var found in " + grep.getFilenameAndLine());
        } else {
            validation.invalid("Expected Env Var NOT found.  `grep` command:\n" + grep.getCommandString());
        }
    }

    private void validateCDefault(Validation validation, ExpectedCConfig c) {
        if (Objects.isNull(c.defaultFieldName)) {
            return;
        }
        String pattern = "#define[ \t]+" + c.defaultFieldName;
        Grep grep = Grep.execute(pattern, this.sourceDir);
        if (!grep.success()) {
            validation.invalid("Expected Default NOT found.  `grep` command:\n" + grep.getCommandString());
            return;
        }
        String location = grep.getFilenameAndLine();
        Matcher matcher = Pattern.compile(pattern + "(.*)$").matcher(grep.getOutput());
        if (!matcher.find()) {
            validation.invalid("Found Default but the pattern doesn't match at " + location);
            return;
        }
        String originalFoundDefaultString = matcher.group(1).trim();
        if (c.defaultValueType == DefaultType.STRING) {
            this.validateCDefaultString(validation, c, originalFoundDefaultString, location);
        } else if (c.defaultValueType == DefaultType.BOOLEAN) {
            this.validateCDefaultBoolean(validation, c, originalFoundDefaultString, location);
        } else if (c.defaultValueType.isNumeric()) {
            this.validateCDefaultNumeric(validation, c, originalFoundDefaultString, location);
        } else {
            validation.invalid("bad default type");
        }
    }

    private void validateCDefaultString(Validation validation, ExpectedCConfig c, String originalFoundDefaultString, String location) {
        String foundDefaultString = originalFoundDefaultString.replaceFirst("^\\(", "").replaceFirst("\\)$", "").replaceFirst("^\"", "").replaceFirst("\"$", "");
        if (foundDefaultString.equals(c.defaultValue)) {
            validation.valid("Expected Default (\"" + foundDefaultString + "\") found in " + location);
        } else {
            validation.invalid("Expected Default string doesn't match.  Expected '" + c.defaultValue + "' but found '" + foundDefaultString + "' in " + location);
        }
    }

    private void validateCDefaultBoolean(Validation validation, ExpectedCConfig c, String originalFoundDefaultString, String location) {
        String foundDefaultString = originalFoundDefaultString.replaceFirst("^\\(", "").replaceFirst("\\)$", "");
        if (foundDefaultString.equals(c.defaultValue)) {
            validation.valid("Expected Default '" + foundDefaultString + "' found in " + location);
        } else {
            validation.invalid("boolean doesn't match: " + location);
        }
    }

    private void validateCDefaultNumeric(Validation validation, ExpectedCConfig c, String originalFoundDefaultString, String location) {
        String foundDefaultString = originalFoundDefaultString.replaceAll("INT64_C", "").replaceAll("UINT32_C", "").replaceAll("([0-9]+)LL", "$1").replaceAll("([0-9]+)L", "$1");
        try {
            String evaluatedFoundDefaultString = this.scriptEngine.eval("AERON_TERM_BUFFER_LENGTH_DEFAULT = (16 * 1024 * 1024);\n(" + foundDefaultString + ").toFixed(0)").toString();
            if (evaluatedFoundDefaultString.equals(c.defaultValue)) {
                validation.valid("Expected Default '" + foundDefaultString + "'" + (foundDefaultString.equals(evaluatedFoundDefaultString) ? "" : " (" + evaluatedFoundDefaultString + ")") + " found in " + location);
            } else {
                validation.invalid("found " + foundDefaultString + " (" + evaluatedFoundDefaultString + ") but expected " + c.defaultValue);
            }
        }
        catch (ScriptException e) {
            validation.invalid("Expected Default - unable to evaluate expression '" + originalFoundDefaultString + "' in " + location);
            e.printStackTrace(validation.out());
        }
    }
}

