/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.archive;

import io.aeron.security.Authenticator;
import io.aeron.security.SessionProxy;
import java.nio.charset.StandardCharsets;
import org.agrona.collections.ArrayUtil;
import org.agrona.collections.Long2ObjectHashMap;

public final class SampleAuthenticator
implements Authenticator {
    private static final String CREDENTIALS_STRING_NO_CHALLENGE = "admin:admin";
    private static final String CREDENTIALS_STRING_REQUIRING_CHALLENGE = "admin:adminC";
    private static final String CHALLENGE_CREDENTIALS_STRING = "admin:CSadmin";
    private static final String CHALLENGE_STRING = "challenge!";
    public static final String PRINCIPAL = "admin";
    private final Long2ObjectHashMap<SessionState> sessionIdToStateMap = new Long2ObjectHashMap();

    public byte[] encodedPrincipal() {
        return PRINCIPAL.getBytes(StandardCharsets.US_ASCII);
    }

    @Override
    public void onConnectRequest(long sessionId, byte[] encodedCredentials, long nowMs) {
        String credentialsString = new String(encodedCredentials, StandardCharsets.US_ASCII);
        if (credentialsString.equals(CREDENTIALS_STRING_NO_CHALLENGE)) {
            this.sessionIdToStateMap.put(sessionId, SessionState.AUTHENTICATED);
        } else if (credentialsString.equals(CREDENTIALS_STRING_REQUIRING_CHALLENGE)) {
            this.sessionIdToStateMap.put(sessionId, SessionState.CHALLENGE);
        } else {
            this.sessionIdToStateMap.put(sessionId, SessionState.REJECT);
        }
    }

    @Override
    public void onChallengeResponse(long sessionId, byte[] encodedCredentials, long nowMs) {
        String credentialsString = new String(encodedCredentials, StandardCharsets.US_ASCII);
        SessionState sessionState = this.sessionIdToStateMap.get(sessionId);
        if (SessionState.CHALLENGE == sessionState && credentialsString.equals(CHALLENGE_CREDENTIALS_STRING)) {
            this.sessionIdToStateMap.put(sessionId, SessionState.AUTHENTICATED);
        } else if (!credentialsString.equals(CHALLENGE_CREDENTIALS_STRING)) {
            this.sessionIdToStateMap.put(sessionId, SessionState.REJECT);
        }
    }

    @Override
    public void onConnectedSession(SessionProxy sessionProxy, long nowMs) {
        long sessionId = sessionProxy.sessionId();
        SessionState sessionState = this.sessionIdToStateMap.get(sessionId);
        if (null != sessionState) {
            switch (sessionState) {
                case CHALLENGE: {
                    sessionProxy.challenge(CHALLENGE_STRING.getBytes());
                    break;
                }
                case AUTHENTICATED: {
                    if (!sessionProxy.authenticate(this.encodedPrincipal())) break;
                    this.sessionIdToStateMap.remove(sessionId);
                    break;
                }
                case REJECT: {
                    sessionProxy.reject();
                    this.sessionIdToStateMap.remove(sessionId);
                }
            }
        }
    }

    @Override
    public void onChallengedSession(SessionProxy sessionProxy, long nowMs) {
        long sessionId = sessionProxy.sessionId();
        SessionState sessionState = this.sessionIdToStateMap.get(sessionId);
        if (null != sessionState) {
            switch (sessionState) {
                case CHALLENGE: {
                    break;
                }
                case AUTHENTICATED: {
                    if (!sessionProxy.authenticate(ArrayUtil.EMPTY_BYTE_ARRAY)) break;
                    this.sessionIdToStateMap.remove(sessionId);
                    break;
                }
                case REJECT: {
                    sessionProxy.reject();
                    this.sessionIdToStateMap.remove(sessionId);
                }
            }
        }
    }

    static enum SessionState {
        CHALLENGE,
        AUTHENTICATED,
        REJECT;

    }
}

