/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.archive;

import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.samples.LogInspector;
import io.aeron.samples.SamplesUtil;
import java.io.File;
import java.io.PrintStream;
import java.nio.MappedByteBuffer;
import java.util.Date;
import org.agrona.BitUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class SegmentInspector {
    public static void main(String[] args) {
        PrintStream out = System.out;
        if (args.length < 1) {
            out.println("Usage: SegmentInspector <segmentFileName> [dump limit in bytes per message]");
            return;
        }
        String fileName = args[0];
        int messageDumpLimit = args.length >= 2 ? Integer.parseInt(args[1]) : Integer.MAX_VALUE;
        File file = new File(fileName);
        MappedByteBuffer byteBuffer = SamplesUtil.mapExistingFileReadOnly(file);
        UnsafeBuffer segmentBuffer = new UnsafeBuffer(byteBuffer);
        out.println("======================================================================");
        out.format("%s Inspection dump for %s%n", new Date(), fileName);
        out.println("======================================================================");
        out.println();
        SegmentInspector.dumpSegment(out, messageDumpLimit, segmentBuffer);
    }

    public static void dumpSegment(PrintStream out, int messageDumpLimit, UnsafeBuffer buffer) {
        int frameLength;
        DataHeaderFlyweight dataHeaderFlyweight = new DataHeaderFlyweight();
        int length = buffer.capacity();
        for (int offset = 0; offset < length; offset += BitUtil.align(frameLength, 32)) {
            dataHeaderFlyweight.wrap(buffer, offset, length - offset);
            frameLength = dataHeaderFlyweight.frameLength();
            if (frameLength < 32) break;
            out.println(offset + ": " + dataHeaderFlyweight);
            int limit = Math.min(frameLength - 32, messageDumpLimit);
            out.println(LogInspector.formatBytes(buffer, offset + 32, limit));
        }
    }
}

