/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;


/**
 * Notify node(s) of the creation of a snapshot taken on a remote node
 */
@SuppressWarnings("all")
public final class StandbySnapshotDecoder
{
    public static final int BLOCK_LENGTH = 16;
    public static final int TEMPLATE_ID = 81;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final StandbySnapshotDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public StandbySnapshotDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public StandbySnapshotDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public StandbySnapshotDecoder sbeRewind()
    {
        return wrap(buffer, offset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int actingVersion()
    {
        return actingVersion;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int correlationIdId()
    {
        return 1;
    }

    public static int correlationIdSinceVersion()
    {
        return 0;
    }

    public static int correlationIdEncodingOffset()
    {
        return 0;
    }

    public static int correlationIdEncodingLength()
    {
        return 8;
    }

    public static String correlationIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long correlationIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long correlationIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long correlationId()
    {
        return buffer.getLong(offset + 0, BYTE_ORDER);
    }


    public static int versionId()
    {
        return 2;
    }

    public static int versionSinceVersion()
    {
        return 0;
    }

    public static int versionEncodingOffset()
    {
        return 8;
    }

    public static int versionEncodingLength()
    {
        return 4;
    }

    public static String versionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int versionNullValue()
    {
        return -2147483648;
    }

    public static int versionMinValue()
    {
        return -2147483647;
    }

    public static int versionMaxValue()
    {
        return 2147483647;
    }

    public int version()
    {
        return buffer.getInt(offset + 8, BYTE_ORDER);
    }


    public static int responseStreamIdId()
    {
        return 3;
    }

    public static int responseStreamIdSinceVersion()
    {
        return 0;
    }

    public static int responseStreamIdEncodingOffset()
    {
        return 12;
    }

    public static int responseStreamIdEncodingLength()
    {
        return 4;
    }

    public static String responseStreamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int responseStreamIdNullValue()
    {
        return -2147483648;
    }

    public static int responseStreamIdMinValue()
    {
        return -2147483647;
    }

    public static int responseStreamIdMaxValue()
    {
        return 2147483647;
    }

    public int responseStreamId()
    {
        return buffer.getInt(offset + 12, BYTE_ORDER);
    }


    private final SnapshotsDecoder snapshots = new SnapshotsDecoder(this);

    public static long snapshotsDecoderId()
    {
        return 4;
    }

    public static int snapshotsDecoderSinceVersion()
    {
        return 0;
    }

    public SnapshotsDecoder snapshots()
    {
        snapshots.wrap(buffer);
        return snapshots;
    }

    public static final class SnapshotsDecoder
        implements Iterable<SnapshotsDecoder>, java.util.Iterator<SnapshotsDecoder>
    {
        public static final int HEADER_SIZE = 4;
        private final StandbySnapshotDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        SnapshotsDecoder(final StandbySnapshotDecoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final DirectBuffer buffer)
        {
            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + HEADER_SIZE);
            blockLength = (buffer.getShort(limit + 0, BYTE_ORDER) & 0xFFFF);
            count = (buffer.getShort(limit + 2, BYTE_ORDER) & 0xFFFF);
        }

        public SnapshotsDecoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + blockLength);
            ++index;

            return this;
        }

        public static int countMinValue()
        {
            return 0;
        }

        public static int countMaxValue()
        {
            return 65534;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 44;
        }

        public int actingBlockLength()
        {
            return blockLength;
        }

        public int actingVersion()
        {
            return parentMessage.actingVersion;
        }

        public int count()
        {
            return count;
        }

        public java.util.Iterator<SnapshotsDecoder> iterator()
        {
            return this;
        }

        public void remove()
        {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext()
        {
            return index < count;
        }

        public static int recordingIdId()
        {
            return 5;
        }

        public static int recordingIdSinceVersion()
        {
            return 0;
        }

        public static int recordingIdEncodingOffset()
        {
            return 0;
        }

        public static int recordingIdEncodingLength()
        {
            return 8;
        }

        public static String recordingIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long recordingIdNullValue()
        {
            return -9223372036854775808L;
        }

        public static long recordingIdMinValue()
        {
            return -9223372036854775807L;
        }

        public static long recordingIdMaxValue()
        {
            return 9223372036854775807L;
        }

        public long recordingId()
        {
            return buffer.getLong(offset + 0, BYTE_ORDER);
        }


        public static int leadershipTermIdId()
        {
            return 6;
        }

        public static int leadershipTermIdSinceVersion()
        {
            return 0;
        }

        public static int leadershipTermIdEncodingOffset()
        {
            return 8;
        }

        public static int leadershipTermIdEncodingLength()
        {
            return 8;
        }

        public static String leadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long leadershipTermIdNullValue()
        {
            return -9223372036854775808L;
        }

        public static long leadershipTermIdMinValue()
        {
            return -9223372036854775807L;
        }

        public static long leadershipTermIdMaxValue()
        {
            return 9223372036854775807L;
        }

        public long leadershipTermId()
        {
            return buffer.getLong(offset + 8, BYTE_ORDER);
        }


        public static int termBaseLogPositionId()
        {
            return 7;
        }

        public static int termBaseLogPositionSinceVersion()
        {
            return 0;
        }

        public static int termBaseLogPositionEncodingOffset()
        {
            return 16;
        }

        public static int termBaseLogPositionEncodingLength()
        {
            return 8;
        }

        public static String termBaseLogPositionMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long termBaseLogPositionNullValue()
        {
            return -9223372036854775808L;
        }

        public static long termBaseLogPositionMinValue()
        {
            return -9223372036854775807L;
        }

        public static long termBaseLogPositionMaxValue()
        {
            return 9223372036854775807L;
        }

        public long termBaseLogPosition()
        {
            return buffer.getLong(offset + 16, BYTE_ORDER);
        }


        public static int logPositionId()
        {
            return 8;
        }

        public static int logPositionSinceVersion()
        {
            return 0;
        }

        public static int logPositionEncodingOffset()
        {
            return 24;
        }

        public static int logPositionEncodingLength()
        {
            return 8;
        }

        public static String logPositionMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long logPositionNullValue()
        {
            return -9223372036854775808L;
        }

        public static long logPositionMinValue()
        {
            return -9223372036854775807L;
        }

        public static long logPositionMaxValue()
        {
            return 9223372036854775807L;
        }

        public long logPosition()
        {
            return buffer.getLong(offset + 24, BYTE_ORDER);
        }


        public static int timestampId()
        {
            return 9;
        }

        public static int timestampSinceVersion()
        {
            return 0;
        }

        public static int timestampEncodingOffset()
        {
            return 32;
        }

        public static int timestampEncodingLength()
        {
            return 8;
        }

        public static String timestampMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long timestampNullValue()
        {
            return -9223372036854775808L;
        }

        public static long timestampMinValue()
        {
            return -9223372036854775807L;
        }

        public static long timestampMaxValue()
        {
            return 9223372036854775807L;
        }

        public long timestamp()
        {
            return buffer.getLong(offset + 32, BYTE_ORDER);
        }


        public static int serviceIdId()
        {
            return 10;
        }

        public static int serviceIdSinceVersion()
        {
            return 0;
        }

        public static int serviceIdEncodingOffset()
        {
            return 40;
        }

        public static int serviceIdEncodingLength()
        {
            return 4;
        }

        public static String serviceIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int serviceIdNullValue()
        {
            return -2147483648;
        }

        public static int serviceIdMinValue()
        {
            return -2147483647;
        }

        public static int serviceIdMaxValue()
        {
            return 2147483647;
        }

        public int serviceId()
        {
            return buffer.getInt(offset + 40, BYTE_ORDER);
        }


        public static int archiveEndpointId()
        {
            return 11;
        }

        public static int archiveEndpointSinceVersion()
        {
            return 0;
        }

        public static String archiveEndpointCharacterEncoding()
        {
            return java.nio.charset.StandardCharsets.US_ASCII.name();
        }

        public static String archiveEndpointMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int archiveEndpointHeaderLength()
        {
            return 4;
        }

        public int archiveEndpointLength()
        {
            final int limit = parentMessage.limit();
            return (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        }

        public int skipArchiveEndpoint()
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            final int dataOffset = limit + headerLength;
            parentMessage.limit(dataOffset + dataLength);

            return dataLength;
        }

        public int getArchiveEndpoint(final MutableDirectBuffer dst, final int dstOffset, final int length)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            final int bytesCopied = Math.min(length, dataLength);
            parentMessage.limit(limit + headerLength + dataLength);
            buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

            return bytesCopied;
        }

        public int getArchiveEndpoint(final byte[] dst, final int dstOffset, final int length)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            final int bytesCopied = Math.min(length, dataLength);
            parentMessage.limit(limit + headerLength + dataLength);
            buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

            return bytesCopied;
        }

        public void wrapArchiveEndpoint(final DirectBuffer wrapBuffer)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            parentMessage.limit(limit + headerLength + dataLength);
            wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
        }

        public String archiveEndpoint()
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            parentMessage.limit(limit + headerLength + dataLength);

            if (0 == dataLength)
            {
                return "";
            }

            final byte[] tmp = new byte[dataLength];
            buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

            return new String(tmp, java.nio.charset.StandardCharsets.US_ASCII);
        }

        public int getArchiveEndpoint(final Appendable appendable)
        {
            final int headerLength = 4;
            final int limit = parentMessage.limit();
            final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
            final int dataOffset = limit + headerLength;

            parentMessage.limit(dataOffset + dataLength);
            buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);

            return dataLength;
        }

        public StringBuilder appendTo(final StringBuilder builder)
        {
            if (null == buffer)
            {
                return builder;
            }

            builder.append('(');
            builder.append("recordingId=");
            builder.append(this.recordingId());
            builder.append('|');
            builder.append("leadershipTermId=");
            builder.append(this.leadershipTermId());
            builder.append('|');
            builder.append("termBaseLogPosition=");
            builder.append(this.termBaseLogPosition());
            builder.append('|');
            builder.append("logPosition=");
            builder.append(this.logPosition());
            builder.append('|');
            builder.append("timestamp=");
            builder.append(this.timestamp());
            builder.append('|');
            builder.append("serviceId=");
            builder.append(this.serviceId());
            builder.append('|');
            builder.append("archiveEndpoint=");
            builder.append('\'');
            getArchiveEndpoint(builder);
            builder.append('\'');
            builder.append(')');

            return builder;
        }
        
        public SnapshotsDecoder sbeSkip()
        {
            skipArchiveEndpoint();

            return this;
        }
    }

    public static int responseChannelId()
    {
        return 12;
    }

    public static int responseChannelSinceVersion()
    {
        return 0;
    }

    public static String responseChannelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String responseChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int responseChannelHeaderLength()
    {
        return 4;
    }

    public int responseChannelLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
    }

    public int skipResponseChannel()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getResponseChannel(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getResponseChannel(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapResponseChannel(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String responseChannel()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        return new String(tmp, java.nio.charset.StandardCharsets.US_ASCII);
    }

    public int getResponseChannel(final Appendable appendable)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;

        parentMessage.limit(dataOffset + dataLength);
        buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);

        return dataLength;
    }

    public static int encodedCredentialsId()
    {
        return 13;
    }

    public static int encodedCredentialsSinceVersion()
    {
        return 0;
    }

    public static String encodedCredentialsMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int encodedCredentialsHeaderLength()
    {
        return 4;
    }

    public int encodedCredentialsLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
    }

    public int skipEncodedCredentials()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getEncodedCredentials(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getEncodedCredentials(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapEncodedCredentials(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final StandbySnapshotDecoder decoder = new StandbySnapshotDecoder();
        decoder.wrap(buffer, offset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(offset + actingBlockLength);
        builder.append("[StandbySnapshot](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("version=");
        builder.append(this.version());
        builder.append('|');
        builder.append("responseStreamId=");
        builder.append(this.responseStreamId());
        builder.append('|');
        builder.append("snapshots=[");
        final int snapshotsOriginalOffset = snapshots.offset;
        final int snapshotsOriginalIndex = snapshots.index;
        final SnapshotsDecoder snapshots = this.snapshots();
        if (snapshots.count() > 0)
        {
            while (snapshots.hasNext())
            {
                snapshots.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        snapshots.offset = snapshotsOriginalOffset;
        snapshots.index = snapshotsOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("responseChannel=");
        builder.append('\'');
        getResponseChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("encodedCredentials=");
        builder.append(skipEncodedCredentials()).append(" bytes of raw data");

        limit(originalLimit);

        return builder;
    }
    
    public StandbySnapshotDecoder sbeSkip()
    {
        sbeRewind();
        SnapshotsDecoder snapshots = this.snapshots();
        if (snapshots.count() > 0)
        {
            while (snapshots.hasNext())
            {
                snapshots.next();
                snapshots.sbeSkip();
            }
        }
        skipResponseChannel();
        skipEncodedCredentials();

        return this;
    }
}
