/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.DirectBufferVector;
import io.aeron.LogBuffers;
import io.aeron.ReservedValueSupplier;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.HeaderWriter;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.status.LocalSocketAddressStatus;
import java.util.List;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.ReadablePosition;

public abstract class Publication
implements AutoCloseable {
    public static final long NOT_CONNECTED = -1L;
    public static final long BACK_PRESSURED = -2L;
    public static final long ADMIN_ACTION = -3L;
    public static final long CLOSED = -4L;
    public static final long MAX_POSITION_EXCEEDED = -5L;
    final long originalRegistrationId;
    final long registrationId;
    final long maxPossiblePosition;
    final int channelStatusId;
    final int streamId;
    final int sessionId;
    final int maxMessageLength;
    final int maxFramedLength;
    final int initialTermId;
    final int maxPayloadLength;
    final int positionBitsToShift;
    final int termBufferLength;
    volatile boolean isClosed = false;
    final ReadablePosition positionLimit;
    final UnsafeBuffer[] termBuffers;
    final UnsafeBuffer logMetaDataBuffer;
    final HeaderWriter headerWriter;
    final LogBuffers logBuffers;
    final ClientConductor conductor;
    final String channel;

    Publication(ClientConductor clientConductor, String channel, int streamId, int sessionId, ReadablePosition positionLimit, int channelStatusId, LogBuffers logBuffers, long originalRegistrationId, long registrationId) {
        UnsafeBuffer logMetaDataBuffer = logBuffers.metaDataBuffer();
        this.termBufferLength = logBuffers.termLength();
        this.maxMessageLength = FrameDescriptor.computeMaxMessageLength(this.termBufferLength);
        this.maxPayloadLength = LogBufferDescriptor.mtuLength(logMetaDataBuffer) - 32;
        this.maxFramedLength = LogBufferDescriptor.computeFragmentedFrameLength(this.maxMessageLength, this.maxPayloadLength);
        this.maxPossiblePosition = (long)this.termBufferLength * 0x80000000L;
        this.conductor = clientConductor;
        this.channel = channel;
        this.streamId = streamId;
        this.sessionId = sessionId;
        this.initialTermId = LogBufferDescriptor.initialTermId(logMetaDataBuffer);
        this.termBuffers = logBuffers.duplicateTermBuffers();
        this.logMetaDataBuffer = logMetaDataBuffer;
        this.logBuffers = logBuffers;
        this.originalRegistrationId = originalRegistrationId;
        this.registrationId = registrationId;
        this.positionLimit = positionLimit;
        this.channelStatusId = channelStatusId;
        this.positionBitsToShift = LogBufferDescriptor.positionBitsToShift(this.termBufferLength);
        this.headerWriter = HeaderWriter.newInstance(LogBufferDescriptor.defaultFrameHeader(logMetaDataBuffer));
        for (int i = 0; i < 3; ++i) {
            int tailCounterOffset = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + i * 8;
            logMetaDataBuffer.boundsCheck(tailCounterOffset, 8);
        }
    }

    public int positionBitsToShift() {
        return this.positionBitsToShift;
    }

    public int termBufferLength() {
        return this.termBufferLength;
    }

    public long maxPossiblePosition() {
        return this.maxPossiblePosition;
    }

    public String channel() {
        return this.channel;
    }

    public int streamId() {
        return this.streamId;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int initialTermId() {
        return this.initialTermId;
    }

    public int maxMessageLength() {
        return this.maxMessageLength;
    }

    public int maxPayloadLength() {
        return this.maxPayloadLength;
    }

    public long originalRegistrationId() {
        return this.originalRegistrationId;
    }

    public boolean isOriginal() {
        return this.originalRegistrationId == this.registrationId;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public boolean isConnected() {
        return !this.isClosed && LogBufferDescriptor.isConnected(this.logMetaDataBuffer);
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.conductor.removePublication(this);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public long channelStatus() {
        if (this.isClosed) {
            return -1L;
        }
        return this.conductor.channelStatus(this.channelStatusId);
    }

    public int channelStatusId() {
        return this.channelStatusId;
    }

    public List<String> localSocketAddresses() {
        return LocalSocketAddressStatus.findAddresses(this.conductor.countersReader(), this.channelStatus(), this.channelStatusId);
    }

    public long position() {
        if (this.isClosed) {
            return -4L;
        }
        long rawTail = LogBufferDescriptor.rawTailVolatile(this.logMetaDataBuffer);
        int termOffset = LogBufferDescriptor.termOffset(rawTail, this.termBufferLength);
        return LogBufferDescriptor.computePosition(LogBufferDescriptor.termId(rawTail), termOffset, this.positionBitsToShift, this.initialTermId);
    }

    public long positionLimit() {
        if (this.isClosed) {
            return -4L;
        }
        return this.positionLimit.getVolatile();
    }

    public int positionLimitId() {
        return this.positionLimit.id();
    }

    public abstract long availableWindow();

    public final long offer(DirectBuffer buffer) {
        return this.offer(buffer, 0, buffer.capacity());
    }

    public final long offer(DirectBuffer buffer, int offset, int length) {
        return this.offer(buffer, offset, length, null);
    }

    public abstract long offer(DirectBuffer var1, int var2, int var3, ReservedValueSupplier var4);

    public final long offer(DirectBuffer bufferOne, int offsetOne, int lengthOne, DirectBuffer bufferTwo, int offsetTwo, int lengthTwo) {
        return this.offer(bufferOne, offsetOne, lengthOne, bufferTwo, offsetTwo, lengthTwo, null);
    }

    public abstract long offer(DirectBuffer var1, int var2, int var3, DirectBuffer var4, int var5, int var6, ReservedValueSupplier var7);

    public final long offer(DirectBufferVector[] vectors) {
        return this.offer(vectors, null);
    }

    public abstract long offer(DirectBufferVector[] var1, ReservedValueSupplier var2);

    public abstract long tryClaim(int var1, BufferClaim var2);

    public void addDestination(String endpointChannel) {
        if (this.isClosed) {
            throw new AeronException("Publication is closed");
        }
        this.conductor.addDestination(this.originalRegistrationId, endpointChannel);
    }

    public void removeDestination(String endpointChannel) {
        if (this.isClosed) {
            throw new AeronException("Publication is closed");
        }
        this.conductor.removeDestination(this.originalRegistrationId, endpointChannel);
    }

    public long asyncAddDestination(String endpointChannel) {
        if (this.isClosed) {
            throw new AeronException("Publication is closed");
        }
        return this.conductor.asyncAddDestination(this.registrationId, endpointChannel);
    }

    public long asyncRemoveDestination(String endpointChannel) {
        if (this.isClosed) {
            throw new AeronException("Publication is closed");
        }
        return this.conductor.asyncRemoveDestination(this.registrationId, endpointChannel);
    }

    void internalClose() {
        this.isClosed = true;
    }

    LogBuffers logBuffers() {
        return this.logBuffers;
    }

    final long backPressureStatus(long currentPosition, int messageLength) {
        if (currentPosition + (long)BitUtil.align(messageLength + 32, 32) >= this.maxPossiblePosition) {
            return -5L;
        }
        if (LogBufferDescriptor.isConnected(this.logMetaDataBuffer)) {
            return -2L;
        }
        return -1L;
    }

    final void checkPositiveLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("invalid length: " + length);
        }
    }

    final void checkPayloadLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("invalid length: " + length);
        }
        if (length > this.maxPayloadLength) {
            throw new IllegalArgumentException("claim exceeds maxPayloadLength of " + this.maxPayloadLength + ", length=" + length);
        }
    }

    final void checkMaxMessageLength(int length) {
        if (length > this.maxMessageLength) {
            throw new IllegalArgumentException("message exceeds maxMessageLength of " + this.maxMessageLength + ", length=" + length);
        }
    }

    static int validateAndComputeLength(int lengthOne, int lengthTwo) {
        if (lengthOne < 0) {
            throw new IllegalArgumentException("lengthOne < 0: " + lengthOne);
        }
        if (lengthTwo < 0) {
            throw new IllegalArgumentException("lengthTwo < 0: " + lengthTwo);
        }
        int totalLength = lengthOne + lengthTwo;
        if (totalLength < 0) {
            throw new IllegalArgumentException("overflow totalLength=" + totalLength);
        }
        return totalLength;
    }

    public static String errorString(long position) {
        if (-5L <= position && position < 0L) {
            int errorCode = (int)position;
            switch (errorCode) {
                case -1: {
                    return "NOT_CONNECTED";
                }
                case -2: {
                    return "BACK_PRESSURED";
                }
                case -3: {
                    return "ADMIN_ACTION";
                }
                case -4: {
                    return "CLOSED";
                }
                case -5: {
                    return "MAX_POSITION_EXCEEDED";
                }
            }
            return "UNKNOWN";
        }
        if (0L <= position) {
            return "NONE";
        }
        return "UNKNOWN";
    }

    public String toString() {
        return "Publication{originalRegistrationId=" + this.originalRegistrationId + ", registrationId=" + this.registrationId + ", isClosed=" + this.isClosed + ", isConnected=" + this.isConnected() + ", initialTermId=" + this.initialTermId + ", termBufferLength=" + this.termBufferLength + ", sessionId=" + this.sessionId + ", streamId=" + this.streamId + ", channel='" + this.channel + '\'' + ", position=" + this.position() + '}';
    }
}

