/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class TaggedReplicateRequestDecoder {
    public static final int BLOCK_LENGTH = 52;
    public static final int TEMPLATE_ID = 62;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 10;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final TaggedReplicateRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 52;
    }

    public int sbeTemplateId() {
        return 62;
    }

    public int sbeSchemaId() {
        return 101;
    }

    public int sbeSchemaVersion() {
        return 10;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public TaggedReplicateRequestDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public TaggedReplicateRequestDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (62 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public TaggedReplicateRequestDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int controlSessionIdId() {
        return 1;
    }

    public static int controlSessionIdSinceVersion() {
        return 0;
    }

    public static int controlSessionIdEncodingOffset() {
        return 0;
    }

    public static int controlSessionIdEncodingLength() {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long controlSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long controlSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long controlSessionId() {
        return this.buffer.getLong(this.offset + 0, BYTE_ORDER);
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 8, BYTE_ORDER);
    }

    public static int srcRecordingIdId() {
        return 3;
    }

    public static int srcRecordingIdSinceVersion() {
        return 0;
    }

    public static int srcRecordingIdEncodingOffset() {
        return 16;
    }

    public static int srcRecordingIdEncodingLength() {
        return 8;
    }

    public static String srcRecordingIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long srcRecordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long srcRecordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long srcRecordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long srcRecordingId() {
        return this.buffer.getLong(this.offset + 16, BYTE_ORDER);
    }

    public static int dstRecordingIdId() {
        return 4;
    }

    public static int dstRecordingIdSinceVersion() {
        return 0;
    }

    public static int dstRecordingIdEncodingOffset() {
        return 24;
    }

    public static int dstRecordingIdEncodingLength() {
        return 8;
    }

    public static String dstRecordingIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long dstRecordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long dstRecordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long dstRecordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long dstRecordingId() {
        return this.buffer.getLong(this.offset + 24, BYTE_ORDER);
    }

    public static int channelTagIdId() {
        return 5;
    }

    public static int channelTagIdSinceVersion() {
        return 0;
    }

    public static int channelTagIdEncodingOffset() {
        return 32;
    }

    public static int channelTagIdEncodingLength() {
        return 8;
    }

    public static String channelTagIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long channelTagIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long channelTagIdMinValue() {
        return -9223372036854775807L;
    }

    public static long channelTagIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long channelTagId() {
        return this.buffer.getLong(this.offset + 32, BYTE_ORDER);
    }

    public static int subscriptionTagIdId() {
        return 6;
    }

    public static int subscriptionTagIdSinceVersion() {
        return 0;
    }

    public static int subscriptionTagIdEncodingOffset() {
        return 40;
    }

    public static int subscriptionTagIdEncodingLength() {
        return 8;
    }

    public static String subscriptionTagIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long subscriptionTagIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long subscriptionTagIdMinValue() {
        return -9223372036854775807L;
    }

    public static long subscriptionTagIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long subscriptionTagId() {
        return this.buffer.getLong(this.offset + 40, BYTE_ORDER);
    }

    public static int srcControlStreamIdId() {
        return 7;
    }

    public static int srcControlStreamIdSinceVersion() {
        return 0;
    }

    public static int srcControlStreamIdEncodingOffset() {
        return 48;
    }

    public static int srcControlStreamIdEncodingLength() {
        return 4;
    }

    public static String srcControlStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int srcControlStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int srcControlStreamIdMinValue() {
        return -2147483647;
    }

    public static int srcControlStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int srcControlStreamId() {
        return this.buffer.getInt(this.offset + 48, BYTE_ORDER);
    }

    public static int srcControlChannelId() {
        return 8;
    }

    public static int srcControlChannelSinceVersion() {
        return 0;
    }

    public static String srcControlChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String srcControlChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int srcControlChannelHeaderLength() {
        return 4;
    }

    public int srcControlChannelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
    }

    public int skipSrcControlChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getSrcControlChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSrcControlChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapSrcControlChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String srcControlChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getSrcControlChannel(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public static int liveDestinationId() {
        return 9;
    }

    public static int liveDestinationSinceVersion() {
        return 0;
    }

    public static String liveDestinationCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String liveDestinationMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int liveDestinationHeaderLength() {
        return 4;
    }

    public int liveDestinationLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
    }

    public int skipLiveDestination() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getLiveDestination(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getLiveDestination(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapLiveDestination(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String liveDestination() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getLiveDestination(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        TaggedReplicateRequestDecoder decoder = new TaggedReplicateRequestDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[TaggedReplicateRequest](sbeTemplateId=");
        builder.append(62);
        builder.append("|sbeSchemaId=");
        builder.append(101);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 10) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(10);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 52) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(52);
        builder.append("):");
        builder.append("controlSessionId=");
        builder.append(this.controlSessionId());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("srcRecordingId=");
        builder.append(this.srcRecordingId());
        builder.append('|');
        builder.append("dstRecordingId=");
        builder.append(this.dstRecordingId());
        builder.append('|');
        builder.append("channelTagId=");
        builder.append(this.channelTagId());
        builder.append('|');
        builder.append("subscriptionTagId=");
        builder.append(this.subscriptionTagId());
        builder.append('|');
        builder.append("srcControlStreamId=");
        builder.append(this.srcControlStreamId());
        builder.append('|');
        builder.append("srcControlChannel=");
        builder.append('\'');
        this.getSrcControlChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("liveDestination=");
        builder.append('\'');
        this.getLiveDestination(builder);
        builder.append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public TaggedReplicateRequestDecoder sbeSkip() {
        this.sbeRewind();
        this.skipSrcControlChannel();
        this.skipLiveDestination();
        return this;
    }
}

