/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.ChannelUriStringBuilder;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.ConsensusPublisher;
import io.aeron.cluster.ElectionState;
import io.aeron.cluster.LogReplay;
import io.aeron.cluster.RecordingLog;
import io.aeron.cluster.RecordingReplication;
import io.aeron.cluster.client.ClusterEvent;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.service.Cluster;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.TimeoutException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.AgentTerminationException;

class Election {
    private final boolean isNodeStartup;
    private final long initialLogLeadershipTermId;
    private final long initialTermBaseLogPosition;
    private boolean isFirstInit = true;
    private boolean isLeaderStartup;
    private boolean isExtendedCanvass;
    private int logSessionId = -1;
    private long timeOfLastStateChangeNs;
    private long timeOfLastUpdateNs;
    private long timeOfLastCommitPositionUpdateNs;
    private final long initialTimeOfLastUpdateNs;
    private long nominationDeadlineNs;
    private long logPosition;
    private long appendPosition;
    private long catchupJoinPosition = -1L;
    private long catchupCommitPosition = 0L;
    private long replicationLeadershipTermId = -1L;
    private long replicationStopPosition = -1L;
    private long leaderRecordingId = -1L;
    private long leadershipTermId;
    private long logLeadershipTermId;
    private long candidateTermId;
    private ClusterMember leaderMember = null;
    private ElectionState state = ElectionState.INIT;
    private Subscription logSubscription = null;
    private LogReplay logReplay = null;
    private final ClusterMember[] clusterMembers;
    private final ClusterMember thisMember;
    private final Int2ObjectHashMap<ClusterMember> clusterMemberByIdMap;
    private final ConsensusPublisher consensusPublisher;
    private final ConsensusModule.Context ctx;
    private final ConsensusModuleAgent consensusModuleAgent;
    private RecordingReplication logReplication = null;
    private long replicationCommitPosition = 0L;
    private long replicationDeadlineNs = 0L;
    private long replicationTermBaseLogPosition;
    private long lastPublishedCommitPosition;
    private int gracefulClosedLeaderId;

    Election(boolean isNodeStartup, int gracefulClosedLeaderId, long leadershipTermId, long termBaseLogPosition, long logPosition, long appendPosition, ClusterMember[] clusterMembers, Int2ObjectHashMap<ClusterMember> clusterMemberByIdMap, ClusterMember thisMember, ConsensusPublisher consensusPublisher, ConsensusModule.Context ctx, ConsensusModuleAgent consensusModuleAgent) {
        this.isNodeStartup = isNodeStartup;
        this.isExtendedCanvass = isNodeStartup;
        this.gracefulClosedLeaderId = gracefulClosedLeaderId;
        this.logPosition = logPosition;
        this.appendPosition = appendPosition;
        this.logLeadershipTermId = leadershipTermId;
        this.initialLogLeadershipTermId = leadershipTermId;
        this.initialTermBaseLogPosition = termBaseLogPosition;
        this.leadershipTermId = leadershipTermId;
        this.candidateTermId = leadershipTermId;
        this.clusterMembers = clusterMembers;
        this.clusterMemberByIdMap = clusterMemberByIdMap;
        this.thisMember = thisMember;
        this.consensusPublisher = consensusPublisher;
        this.ctx = ctx;
        this.consensusModuleAgent = consensusModuleAgent;
        long nowNs = ctx.clusterClock().timeNanos();
        this.timeOfLastUpdateNs = this.initialTimeOfLastUpdateNs = nowNs - TimeUnit.DAYS.toNanos(1L);
        this.timeOfLastCommitPositionUpdateNs = this.initialTimeOfLastUpdateNs;
        Objects.requireNonNull(thisMember);
        ctx.electionStateCounter().setOrdered(ElectionState.INIT.code());
        ctx.electionCounter().incrementOrdered();
        if (clusterMembers.length == 1 && thisMember.id() == clusterMembers[0].id()) {
            this.leadershipTermId = this.candidateTermId = Math.max(leadershipTermId + 1L, ctx.nodeStateFile().candidateTerm().candidateTermId() + 1L);
            this.leaderMember = thisMember;
            ctx.nodeStateFile().updateCandidateTermId(this.candidateTermId, logPosition, ctx.epochClock().time());
            this.state(ElectionState.LEADER_LOG_REPLICATION, nowNs, "");
        }
    }

    ClusterMember leader() {
        return this.leaderMember;
    }

    int logSessionId() {
        return this.logSessionId;
    }

    long leadershipTermId() {
        return this.leadershipTermId;
    }

    long logPosition() {
        return this.logPosition;
    }

    boolean isLeaderStartup() {
        return this.isLeaderStartup;
    }

    int thisMemberId() {
        return this.thisMember.id();
    }

    int doWork(long nowNs) {
        int workCount = 0;
        switch (this.state) {
            case INIT: {
                workCount += this.init(nowNs);
                break;
            }
            case CANVASS: {
                workCount += this.canvass(nowNs);
                break;
            }
            case NOMINATE: {
                workCount += this.nominate(nowNs);
                break;
            }
            case CANDIDATE_BALLOT: {
                workCount += this.candidateBallot(nowNs);
                break;
            }
            case FOLLOWER_BALLOT: {
                workCount += this.followerBallot(nowNs);
                break;
            }
            case LEADER_LOG_REPLICATION: {
                workCount += this.leaderLogReplication(nowNs);
                break;
            }
            case LEADER_REPLAY: {
                workCount += this.leaderReplay(nowNs);
                break;
            }
            case LEADER_INIT: {
                workCount += this.leaderInit(nowNs);
                break;
            }
            case LEADER_READY: {
                workCount += this.leaderReady(nowNs);
                break;
            }
            case FOLLOWER_LOG_REPLICATION: {
                workCount += this.followerLogReplication(nowNs);
                break;
            }
            case FOLLOWER_REPLAY: {
                workCount += this.followerReplay(nowNs);
                break;
            }
            case FOLLOWER_CATCHUP_INIT: {
                workCount += this.followerCatchupInit(nowNs);
                break;
            }
            case FOLLOWER_CATCHUP_AWAIT: {
                workCount += this.followerCatchupAwait(nowNs);
                break;
            }
            case FOLLOWER_CATCHUP: {
                workCount += this.followerCatchup(nowNs);
                break;
            }
            case FOLLOWER_LOG_INIT: {
                workCount += this.followerLogInit(nowNs);
                break;
            }
            case FOLLOWER_LOG_AWAIT: {
                workCount += this.followerLogAwait(nowNs);
                break;
            }
            case FOLLOWER_READY: {
                workCount += this.followerReady(nowNs);
                break;
            }
        }
        return workCount;
    }

    void handleError(long nowNs, Throwable ex) {
        this.ctx.countedErrorHandler().onError(ex);
        this.logPosition = this.ctx.commitPositionCounter().getWeak();
        this.state(ElectionState.INIT, nowNs, ex.getMessage());
        if (ex instanceof AgentTerminationException || ex instanceof InterruptedException) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    void onRecordingSignal(long correlationId, long recordingId, long position, RecordingSignal signal) {
        if (ElectionState.INIT == this.state) {
            return;
        }
        if (null != this.logReplication) {
            this.logReplication.onSignal(correlationId, recordingId, position, signal);
            this.consensusModuleAgent.logRecordingId(this.logReplication.recordingId());
        }
    }

    void onCanvassPosition(long logLeadershipTermId, long logPosition, long leadershipTermId, int followerMemberId, int protocolVersion) {
        ClusterMember follower;
        if (ElectionState.INIT == this.state) {
            return;
        }
        if (followerMemberId == this.gracefulClosedLeaderId) {
            this.gracefulClosedLeaderId = -1;
        }
        if (null != (follower = this.clusterMemberByIdMap.get(followerMemberId)) && this.thisMember.id() != followerMemberId) {
            follower.leadershipTermId(logLeadershipTermId).logPosition(logPosition);
            if (logLeadershipTermId < this.leadershipTermId) {
                if (Cluster.Role.LEADER == this.consensusModuleAgent.role()) {
                    this.publishNewLeadershipTerm(follower, logLeadershipTermId, this.ctx.clusterClock().time());
                }
            } else if (logLeadershipTermId > this.leadershipTermId) {
                switch (this.state) {
                    case LEADER_LOG_REPLICATION: 
                    case LEADER_READY: {
                        throw new ClusterEvent("potential new election in progress");
                    }
                }
            }
        }
    }

    void onRequestVote(long logLeadershipTermId, long logPosition, long candidateTermId, int candidateId, int protocolVersion) {
        if (ElectionState.INIT == this.state) {
            return;
        }
        if (this.isPassiveMember() || candidateId == this.thisMember.id()) {
            return;
        }
        if (candidateTermId <= this.candidateTermId) {
            this.placeVote(candidateTermId, candidateId, false);
        } else if (ClusterMember.compareLog(this.logLeadershipTermId, this.appendPosition, logLeadershipTermId, logPosition) > 0) {
            this.candidateTermId = this.ctx.nodeStateFile().proposeMaxCandidateTermId(candidateTermId, logPosition, this.ctx.epochClock().time());
            this.placeVote(candidateTermId, candidateId, false);
            ClusterMember candidateMember = this.clusterMemberByIdMap.get(candidateId);
            if (null != candidateMember && Cluster.Role.LEADER == this.consensusModuleAgent.role()) {
                this.publishNewLeadershipTerm(candidateMember, logLeadershipTermId, this.ctx.clusterClock().time());
            }
        } else if (ElectionState.CANVASS == this.state || ElectionState.NOMINATE == this.state || ElectionState.CANDIDATE_BALLOT == this.state || ElectionState.FOLLOWER_BALLOT == this.state) {
            this.candidateTermId = this.ctx.nodeStateFile().proposeMaxCandidateTermId(candidateTermId, logPosition, this.ctx.epochClock().time());
            this.placeVote(candidateTermId, candidateId, true);
            this.state(ElectionState.FOLLOWER_BALLOT, this.ctx.clusterClock().timeNanos(), "");
        }
    }

    void onVote(long candidateTermId, long logLeadershipTermId, long logPosition, int candidateMemberId, int followerMemberId, boolean vote) {
        ClusterMember follower;
        if (ElectionState.INIT == this.state) {
            return;
        }
        if (ElectionState.CANDIDATE_BALLOT == this.state && candidateTermId == this.candidateTermId && candidateMemberId == this.thisMember.id() && null != (follower = this.clusterMemberByIdMap.get(followerMemberId))) {
            follower.candidateTermId(candidateTermId).leadershipTermId(logLeadershipTermId).logPosition(logPosition).vote(vote ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void onNewLeadershipTerm(long logLeadershipTermId, long nextLeadershipTermId, long nextTermBaseLogPosition, long nextLogPosition, long leadershipTermId, long termBaseLogPosition, long logPosition, long leaderRecordingId, long timestamp, int leaderMemberId, int logSessionId, boolean isStartup) {
        if (ElectionState.INIT == this.state) {
            return;
        }
        ClusterMember leader = this.clusterMemberByIdMap.get(leaderMemberId);
        if (null == leader || leaderMemberId == this.thisMember.id() && leadershipTermId == this.leadershipTermId) {
            return;
        }
        if (leaderMemberId == this.gracefulClosedLeaderId) {
            this.gracefulClosedLeaderId = -1;
        }
        if ((ElectionState.FOLLOWER_BALLOT == this.state || ElectionState.CANDIDATE_BALLOT == this.state) && leadershipTermId == this.candidateTermId || ElectionState.CANVASS == this.state) {
            if (logLeadershipTermId == this.logLeadershipTermId) {
                if (-1L != nextTermBaseLogPosition && nextTermBaseLogPosition < this.appendPosition) {
                    this.onTruncateLogEntry(this.thisMember.id(), this.state, logLeadershipTermId, this.leadershipTermId, this.candidateTermId, this.ctx.commitPositionCounter().getWeak(), this.logPosition, this.appendPosition, logPosition, nextTermBaseLogPosition);
                }
                this.leaderMember = leader;
                this.isLeaderStartup = isStartup;
                this.leadershipTermId = leadershipTermId;
                this.candidateTermId = Math.max(leadershipTermId, this.candidateTermId);
                this.logSessionId = logSessionId;
                this.leaderRecordingId = leaderRecordingId;
                long l = this.catchupJoinPosition = this.appendPosition < logPosition ? logPosition : -1L;
                if (this.appendPosition < termBaseLogPosition) {
                    if (-1L == nextLeadershipTermId) throw new ClusterException("invalid newLeadershipTerm - this.appendPosition=" + this.appendPosition + " < termBaseLogPosition=" + termBaseLogPosition + " and nextLeadershipTermId=" + nextLeadershipTermId + ", logLeadershipTermId=" + logLeadershipTermId + ", nextTermBaseLogPosition=" + nextTermBaseLogPosition + ", nextLogPosition=" + nextLogPosition + ", leadershipTermId=" + leadershipTermId + ", termBaseLogPosition=" + termBaseLogPosition + ", logPosition=" + logPosition + ", leaderRecordingId=" + leaderRecordingId + ", leaderMemberId=" + leaderMemberId + ", logSessionId=" + logSessionId + ", isStartup=" + isStartup);
                    if (this.appendPosition < nextTermBaseLogPosition) {
                        this.replicationLeadershipTermId = logLeadershipTermId;
                        this.replicationStopPosition = nextTermBaseLogPosition;
                        this.replicationTermBaseLogPosition = -1L;
                        this.state(ElectionState.FOLLOWER_LOG_REPLICATION, this.ctx.clusterClock().timeNanos(), "");
                    } else if (this.appendPosition == nextTermBaseLogPosition && -1L != nextLogPosition) {
                        this.replicationLeadershipTermId = nextLeadershipTermId;
                        this.replicationStopPosition = nextLogPosition;
                        this.replicationTermBaseLogPosition = nextTermBaseLogPosition;
                        this.state(ElectionState.FOLLOWER_LOG_REPLICATION, this.ctx.clusterClock().timeNanos(), "");
                    }
                } else {
                    this.state(ElectionState.FOLLOWER_REPLAY, this.ctx.clusterClock().timeNanos(), "");
                }
            } else {
                this.state(ElectionState.CANVASS, this.ctx.clusterClock().timeNanos(), "");
            }
        }
        if (this.state != ElectionState.FOLLOWER_LOG_REPLICATION || leaderMemberId != this.leaderMember.id()) return;
        this.replicationDeadlineNs = this.ctx.clusterClock().timeNanos() + this.ctx.leaderHeartbeatTimeoutNs();
    }

    void onAppendPosition(long leadershipTermId, long logPosition, int followerMemberId, short flags) {
        ClusterMember follower;
        if (ElectionState.INIT == this.state) {
            return;
        }
        if (leadershipTermId <= this.leadershipTermId && null != (follower = this.clusterMemberByIdMap.get(followerMemberId))) {
            follower.leadershipTermId(leadershipTermId).logPosition(logPosition).timeOfLastAppendPositionNs(this.ctx.clusterClock().timeNanos());
            this.consensusModuleAgent.trackCatchupCompletion(follower, leadershipTermId, flags);
        }
    }

    void onCommitPosition(long leadershipTermId, long logPosition, int leaderMemberId) {
        if (ElectionState.INIT == this.state) {
            return;
        }
        if (leadershipTermId == this.leadershipTermId && -1L != this.catchupJoinPosition && ElectionState.FOLLOWER_CATCHUP == this.state && leaderMemberId == this.leaderMember.id()) {
            this.catchupCommitPosition = Math.max(this.catchupCommitPosition, logPosition);
        } else if (ElectionState.FOLLOWER_LOG_REPLICATION == this.state && leaderMemberId == this.leaderMember.id()) {
            this.replicationCommitPosition = Math.max(this.replicationCommitPosition, logPosition);
            this.replicationDeadlineNs = this.ctx.clusterClock().timeNanos() + this.ctx.leaderHeartbeatTimeoutNs();
        } else if (leadershipTermId > this.leadershipTermId && ElectionState.LEADER_READY == this.state) {
            throw new ClusterEvent("new leader detected due to commit position");
        }
    }

    void onReplayNewLeadershipTermEvent(long leadershipTermId, long logPosition, long timestamp, long termBaseLogPosition) {
        if (ElectionState.INIT == this.state) {
            return;
        }
        if (ElectionState.FOLLOWER_CATCHUP == this.state || ElectionState.FOLLOWER_REPLAY == this.state) {
            long nowNs = this.ctx.clusterClock().timeUnit().toNanos(timestamp);
            this.ensureRecordingLogCoherent(leadershipTermId, termBaseLogPosition, -1L, nowNs);
            this.logPosition = logPosition;
            this.logLeadershipTermId = leadershipTermId;
        }
    }

    void onTruncateLogEntry(int memberId, ElectionState state, long logLeadershipTermId, long leadershipTermId, long candidateTermId, long commitPosition, long logPosition, long appendPosition, long oldPosition, long newPosition) {
        this.consensusModuleAgent.truncateLogEntry(logLeadershipTermId, newPosition);
        throw new ClusterEvent("Truncating Cluster Log - memberId=" + memberId + " state=" + (Object)((Object)state) + " this.logLeadershipTermId=" + logLeadershipTermId + " this.leadershipTermId=" + leadershipTermId + " this.candidateTermId=" + candidateTermId + " this.commitPosition=" + commitPosition + " this.logPosition=" + logPosition + " this.appendPosition=" + appendPosition + " oldPosition=" + oldPosition + " newPosition=" + newPosition);
    }

    private int init(long nowNs) {
        if (this.isFirstInit) {
            this.isFirstInit = false;
            if (!this.isNodeStartup) {
                this.prepareForNewLeadership(nowNs);
            }
        } else {
            this.stopLogReplication();
            this.stopCatchup();
            this.prepareForNewLeadership(nowNs);
            this.logSessionId = -1;
            this.stopReplay();
            if (null != this.logSubscription) {
                CloseHelper.close(this.logSubscription);
                this.consensusModuleAgent.awaitLocalSocketsClosed(this.logSubscription.registrationId());
                this.logSubscription = null;
            }
        }
        this.candidateTermId = Math.max(this.ctx.nodeStateFile().candidateTerm().candidateTermId(), this.leadershipTermId);
        if (this.clusterMembers.length == 1 && this.thisMember.id() == this.clusterMembers[0].id()) {
            this.state(ElectionState.LEADER_LOG_REPLICATION, nowNs, "");
        } else {
            this.state(ElectionState.CANVASS, nowNs, "");
        }
        return 1;
    }

    private int canvass(long nowNs) {
        long deadlineNs;
        int workCount = 0;
        if (this.hasUpdateIntervalExpired(nowNs, this.ctx.electionStatusIntervalNs())) {
            this.timeOfLastUpdateNs = nowNs;
            for (ClusterMember member : this.clusterMembers) {
                if (member.id() == this.thisMember.id()) continue;
                if (null == member.publication()) {
                    ClusterMember.tryAddPublication(member, this.ctx.consensusStreamId(), this.ctx.aeron(), this.ctx.countedErrorHandler());
                }
                this.consensusPublisher.canvassPosition(member.publication(), this.logLeadershipTermId, this.appendPosition, this.leadershipTermId, this.thisMember.id());
            }
            ++workCount;
        }
        if (this.isPassiveMember() || this.ctx.appointedLeaderId() != -1 && this.ctx.appointedLeaderId() != this.thisMember.id()) {
            return workCount;
        }
        long l = deadlineNs = this.isExtendedCanvass ? this.timeOfLastStateChangeNs + this.ctx.startupCanvassTimeoutNs() : this.consensusModuleAgent.timeOfLastLeaderUpdateNs() + this.ctx.leaderHeartbeatTimeoutNs();
        if (ClusterMember.isUnanimousCandidate(this.clusterMembers, this.thisMember, this.gracefulClosedLeaderId) || nowNs >= deadlineNs && ClusterMember.isQuorumCandidate(this.clusterMembers, this.thisMember)) {
            long delayNs = (long)(this.ctx.random().nextDouble() * (double)(this.ctx.electionTimeoutNs() >> 1));
            this.nominationDeadlineNs = nowNs + delayNs;
            this.state(ElectionState.NOMINATE, nowNs, "");
            ++workCount;
        }
        return workCount;
    }

    private int nominate(long nowNs) {
        if (nowNs >= this.nominationDeadlineNs) {
            this.candidateTermId = this.ctx.nodeStateFile().proposeMaxCandidateTermId(this.candidateTermId + 1L, this.logPosition, this.ctx.epochClock().time());
            ClusterMember.becomeCandidate(this.clusterMembers, this.candidateTermId, this.thisMember.id());
            this.state(ElectionState.CANDIDATE_BALLOT, nowNs, "");
            return 1;
        }
        return 0;
    }

    private int candidateBallot(long nowNs) {
        int workCount = 0;
        if (ClusterMember.isUnanimousLeader(this.clusterMembers, this.candidateTermId, this.gracefulClosedLeaderId)) {
            this.leaderMember = this.thisMember;
            this.leadershipTermId = this.candidateTermId;
            this.state(ElectionState.LEADER_LOG_REPLICATION, nowNs, "");
            ++workCount;
        } else if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.electionTimeoutNs()) {
            if (ClusterMember.isQuorumLeader(this.clusterMembers, this.candidateTermId)) {
                this.leaderMember = this.thisMember;
                this.leadershipTermId = this.candidateTermId;
                this.state(ElectionState.LEADER_LOG_REPLICATION, nowNs, "");
            } else {
                this.state(ElectionState.CANVASS, nowNs, "");
            }
            ++workCount;
        } else {
            for (ClusterMember member : this.clusterMembers) {
                if (member.isBallotSent()) continue;
                ++workCount;
                member.isBallotSent(this.consensusPublisher.requestVote(member.publication(), this.logLeadershipTermId, this.appendPosition, this.candidateTermId, this.thisMember.id()));
            }
        }
        return workCount;
    }

    private int followerBallot(long nowNs) {
        int workCount = 0;
        if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.electionTimeoutNs()) {
            this.state(ElectionState.CANVASS, nowNs, "");
            ++workCount;
        }
        return workCount;
    }

    private int leaderLogReplication(long nowNs) {
        int workCount = 0;
        this.thisMember.logPosition(this.appendPosition).timeOfLastAppendPositionNs(nowNs);
        long quorumPosition = this.consensusModuleAgent.quorumPosition();
        workCount += this.publishNewLeadershipTermOnInterval(nowNs);
        workCount += this.publishCommitPositionOnInterval(quorumPosition, nowNs);
        if (quorumPosition >= this.appendPosition) {
            ++workCount;
            this.state(ElectionState.LEADER_REPLAY, nowNs, "");
        }
        return workCount;
    }

    private int leaderReplay(long nowNs) {
        int workCount = 0;
        if (null == this.logReplay) {
            if (this.logPosition < this.appendPosition) {
                this.logReplay = this.consensusModuleAgent.newLogReplay(this.logPosition, this.appendPosition);
            } else {
                this.state(ElectionState.LEADER_INIT, nowNs, "");
            }
            ++workCount;
            this.isLeaderStartup = this.isNodeStartup;
            ClusterMember.resetLogPositions(this.clusterMembers, -1L);
            this.thisMember.leadershipTermId(this.leadershipTermId).logPosition(this.appendPosition);
        } else {
            workCount += this.logReplay.doWork();
            if (this.logReplay.isDone()) {
                this.stopReplay();
                this.logPosition = this.appendPosition;
                this.state(ElectionState.LEADER_INIT, nowNs, "");
            }
        }
        workCount += this.publishNewLeadershipTermOnInterval(nowNs);
        return workCount += this.publishCommitPositionOnInterval(this.consensusModuleAgent.quorumPosition(), nowNs);
    }

    private int leaderInit(long nowNs) {
        this.consensusModuleAgent.joinLogAsLeader(this.leadershipTermId, this.logPosition, this.logSessionId, this.isLeaderStartup);
        this.updateRecordingLog(nowNs);
        this.state(ElectionState.LEADER_READY, nowNs, "");
        return 1;
    }

    private int leaderReady(long nowNs) {
        int workCount = this.consensusModuleAgent.updateLeaderPosition(nowNs, this.appendPosition);
        workCount += this.publishNewLeadershipTermOnInterval(nowNs);
        if ((ClusterMember.hasVotersAtPosition(this.clusterMembers, this.logPosition, this.leadershipTermId) || nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs() && ClusterMember.hasQuorumAtPosition(this.clusterMembers, this.logPosition, this.leadershipTermId)) && this.consensusModuleAgent.appendNewLeadershipTermEvent(nowNs)) {
            this.consensusModuleAgent.electionComplete(nowNs);
            this.state(ElectionState.CLOSED, nowNs, "");
            ++workCount;
        }
        return workCount;
    }

    private int followerLogReplication(long nowNs) {
        int workCount = 0;
        if (null == this.logReplication) {
            if (this.appendPosition < this.replicationStopPosition) {
                this.logReplication = this.consensusModuleAgent.newLogReplication(this.leaderMember.archiveEndpoint(), this.leaderMember.archiveResponseEndpoint(), this.leaderRecordingId, this.replicationStopPosition, nowNs);
                this.replicationDeadlineNs = nowNs + this.ctx.leaderHeartbeatTimeoutNs();
                ++workCount;
            } else {
                this.updateRecordingLogForReplication(this.replicationLeadershipTermId, this.replicationTermBaseLogPosition, this.replicationStopPosition, nowNs);
                this.state(ElectionState.CANVASS, nowNs, "");
            }
        } else {
            workCount += this.consensusModuleAgent.pollArchiveEvents();
            this.logReplication.poll(nowNs);
            boolean replicationDone = this.logReplication.hasReplicationEnded() && this.logReplication.hasStopped();
            workCount += this.publishFollowerReplicationPosition(nowNs);
            if (replicationDone) {
                if (this.replicationCommitPosition >= this.appendPosition) {
                    ConsensusModuleAgent.logReplicationEnded(this.thisMember.id(), "ELECTION", this.logReplication.srcArchiveChannel(), this.logReplication.recordingId(), this.leaderRecordingId, this.logReplication.position(), this.logReplication.hasSynced());
                    this.appendPosition = this.logReplication.position();
                    this.stopLogReplication();
                    this.updateRecordingLogForReplication(this.replicationLeadershipTermId, this.replicationTermBaseLogPosition, this.replicationStopPosition, nowNs);
                    this.state(ElectionState.CANVASS, nowNs, "");
                    ++workCount;
                } else if (nowNs >= this.replicationDeadlineNs) {
                    throw new TimeoutException("timeout awaiting commit position", AeronException.Category.WARN);
                }
            }
        }
        return workCount;
    }

    private int followerReplay(long nowNs) {
        int workCount = 0;
        if (null == this.logReplay) {
            ++workCount;
            if (this.logPosition < this.appendPosition) {
                this.logReplay = this.consensusModuleAgent.newLogReplay(this.logPosition, this.appendPosition);
            } else {
                this.state(-1L != this.catchupJoinPosition ? ElectionState.FOLLOWER_CATCHUP_INIT : ElectionState.FOLLOWER_LOG_INIT, nowNs, "");
            }
        } else {
            workCount += this.logReplay.doWork();
            if (this.logReplay.isDone()) {
                this.stopReplay();
                this.logPosition = this.appendPosition;
                this.state(-1L != this.catchupJoinPosition ? ElectionState.FOLLOWER_CATCHUP_INIT : ElectionState.FOLLOWER_LOG_INIT, nowNs, "");
            }
        }
        return workCount;
    }

    private int followerCatchupInit(long nowNs) {
        if (null == this.logSubscription) {
            this.logSubscription = this.addFollowerSubscription();
            this.addCatchupLogDestination();
        }
        String catchupEndpoint = null;
        String endpoint = this.thisMember.catchupEndpoint();
        if (endpoint.endsWith(":0")) {
            String resolvedEndpoint = this.logSubscription.resolvedEndpoint();
            if (null != resolvedEndpoint) {
                int i = resolvedEndpoint.lastIndexOf(58);
                catchupEndpoint = endpoint.substring(0, endpoint.length() - 2) + resolvedEndpoint.substring(i);
            }
        } else {
            catchupEndpoint = endpoint;
        }
        if (null != catchupEndpoint && this.sendCatchupPosition(catchupEndpoint)) {
            this.timeOfLastUpdateNs = nowNs;
            this.consensusModuleAgent.catchupInitiated(nowNs);
            this.state(ElectionState.FOLLOWER_CATCHUP_AWAIT, nowNs, "");
        } else if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs()) {
            throw new TimeoutException("failed to send catchup position", AeronException.Category.WARN);
        }
        return 1;
    }

    private int followerCatchupAwait(long nowNs) {
        int workCount = 0;
        Image image = this.logSubscription.imageBySessionId(this.logSessionId);
        if (null != image) {
            this.verifyLogJoinPosition("followerCatchupAwait", image.joinPosition());
            if (this.consensusModuleAgent.tryJoinLogAsFollower(image, this.isLeaderStartup, nowNs)) {
                this.state(ElectionState.FOLLOWER_CATCHUP, nowNs, "");
                ++workCount;
            } else {
                if (-1L == this.logSubscription.channelStatus()) {
                    String message = "failed to add catchup log as follower - " + this.logSubscription.channel();
                    throw new ClusterException(message, AeronException.Category.WARN);
                }
                if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs()) {
                    throw new TimeoutException("failed to join catchup log as follower", AeronException.Category.WARN);
                }
            }
        } else if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs()) {
            throw new TimeoutException("failed to join catchup log", AeronException.Category.WARN);
        }
        return workCount;
    }

    private int followerCatchup(long nowNs) {
        long position;
        int workCount = this.consensusModuleAgent.catchupPoll(this.catchupCommitPosition, nowNs);
        if (null == this.consensusModuleAgent.liveLogDestination() && this.consensusModuleAgent.isCatchupNearLive(Math.max(this.catchupJoinPosition, this.catchupCommitPosition))) {
            this.addLiveLogDestination();
            ++workCount;
        }
        if ((position = this.ctx.commitPositionCounter().getWeak()) >= this.catchupJoinPosition && position >= this.catchupCommitPosition && null == this.consensusModuleAgent.catchupLogDestination() && ConsensusModule.State.SNAPSHOT != this.consensusModuleAgent.state()) {
            this.appendPosition = position;
            this.logPosition = position;
            this.state(ElectionState.FOLLOWER_LOG_INIT, nowNs, "");
            ++workCount;
        }
        return workCount;
    }

    private int followerLogInit(long nowNs) {
        if (null == this.logSubscription) {
            if (-1 != this.logSessionId) {
                this.logSubscription = this.addFollowerSubscription();
                this.addLiveLogDestination();
                this.state(ElectionState.FOLLOWER_LOG_AWAIT, nowNs, "");
            }
        } else {
            this.state(ElectionState.FOLLOWER_READY, nowNs, "");
        }
        return 1;
    }

    private int followerLogAwait(long nowNs) {
        int workCount = 0;
        Image image = this.logSubscription.imageBySessionId(this.logSessionId);
        if (null != image) {
            this.verifyLogJoinPosition("followerLogAwait", image.joinPosition());
            if (this.consensusModuleAgent.tryJoinLogAsFollower(image, this.isLeaderStartup, nowNs)) {
                this.appendPosition = image.joinPosition();
                this.logPosition = image.joinPosition();
                this.updateRecordingLog(nowNs);
                this.state(ElectionState.FOLLOWER_READY, nowNs, "");
                ++workCount;
            } else if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs()) {
                throw new TimeoutException("failed to join live log as follower", AeronException.Category.WARN);
            }
        } else {
            if (-1L == this.logSubscription.channelStatus()) {
                String message = "failed to add live log as follower - " + this.logSubscription.channel();
                throw new ClusterException(message, AeronException.Category.WARN);
            }
            if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs()) {
                throw new TimeoutException("failed to join live log", AeronException.Category.WARN);
            }
        }
        return workCount;
    }

    private int followerReady(long nowNs) {
        if (this.consensusPublisher.appendPosition(this.leaderMember.publication(), this.leadershipTermId, this.logPosition, this.thisMember.id(), (short)0)) {
            this.consensusModuleAgent.electionComplete(nowNs);
            this.state(ElectionState.CLOSED, nowNs, "");
        } else if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs()) {
            throw new TimeoutException("ready follower failed to notify leader", AeronException.Category.WARN);
        }
        return 1;
    }

    private void placeVote(long candidateTermId, int candidateId, boolean vote) {
        ClusterMember candidate = this.clusterMemberByIdMap.get(candidateId);
        if (null != candidate) {
            this.consensusPublisher.placeVote(candidate.publication(), candidateTermId, this.logLeadershipTermId, this.appendPosition, candidateId, this.thisMember.id(), vote);
        }
    }

    private int publishNewLeadershipTermOnInterval(long nowNs) {
        int workCount = 0;
        if (this.hasUpdateIntervalExpired(nowNs, this.ctx.leaderHeartbeatIntervalNs())) {
            this.timeOfLastUpdateNs = nowNs;
            this.publishNewLeadershipTerm(this.ctx.clusterClock().timeUnit().convert(nowNs, TimeUnit.NANOSECONDS));
            ++workCount;
        }
        return workCount;
    }

    private int publishCommitPositionOnInterval(long quorumPosition, long nowNs) {
        int workCount = 0;
        if (this.lastPublishedCommitPosition < quorumPosition || this.lastPublishedCommitPosition == quorumPosition && this.hasIntervalExpired(nowNs, this.timeOfLastCommitPositionUpdateNs, this.ctx.leaderHeartbeatIntervalNs())) {
            this.timeOfLastCommitPositionUpdateNs = nowNs;
            this.lastPublishedCommitPosition = quorumPosition;
            this.consensusModuleAgent.publishCommitPosition(quorumPosition);
            ++workCount;
        }
        return workCount;
    }

    private void publishNewLeadershipTerm(long timestamp) {
        for (ClusterMember member : this.clusterMembers) {
            this.publishNewLeadershipTerm(member, this.logLeadershipTermId, timestamp);
        }
    }

    private void publishNewLeadershipTerm(ClusterMember member, long logLeadershipTermId, long timestamp) {
        if (member.id() != this.thisMember.id() && -1 != this.logSessionId) {
            long nextTermBaseLogPosition;
            RecordingLog.Entry logNextTermEntry = this.ctx.recordingLog().findTermEntry(logLeadershipTermId + 1L);
            long nextLeadershipTermId = null != logNextTermEntry ? logNextTermEntry.leadershipTermId : this.leadershipTermId;
            long l = nextTermBaseLogPosition = null != logNextTermEntry ? logNextTermEntry.termBaseLogPosition : this.appendPosition;
            long nextLogPosition = null != logNextTermEntry ? (-1L != logNextTermEntry.logPosition ? logNextTermEntry.logPosition : this.appendPosition) : -1L;
            this.consensusPublisher.newLeadershipTerm(member.publication(), logLeadershipTermId, nextLeadershipTermId, nextTermBaseLogPosition, nextLogPosition, this.leadershipTermId, this.appendPosition, this.appendPosition, this.consensusModuleAgent.logRecordingId(), timestamp, this.thisMember.id(), this.logSessionId, this.isLeaderStartup);
        }
    }

    private int publishFollowerReplicationPosition(long nowNs) {
        long position = this.logReplication.position();
        if ((position > this.appendPosition || position == this.appendPosition && this.hasUpdateIntervalExpired(nowNs, this.ctx.leaderHeartbeatIntervalNs())) && this.consensusPublisher.appendPosition(this.leaderMember.publication(), this.leadershipTermId, position, this.thisMember.id(), (short)0)) {
            this.appendPosition = position;
            this.timeOfLastUpdateNs = nowNs;
            return 1;
        }
        return 0;
    }

    private boolean sendCatchupPosition(String catchupEndpoint) {
        return this.consensusPublisher.catchupPosition(this.leaderMember.publication(), this.leadershipTermId, this.logPosition, this.thisMember.id(), catchupEndpoint);
    }

    private void addCatchupLogDestination() {
        String destination = ChannelUri.createDestinationUri(this.ctx.logChannel(), this.thisMember.catchupEndpoint());
        this.logSubscription.addDestination(destination);
        this.consensusModuleAgent.catchupLogDestination(destination);
    }

    private void addLiveLogDestination() {
        String destination = this.ctx.isLogMdc() ? ChannelUri.createDestinationUri(this.ctx.logChannel(), this.thisMember.logEndpoint()) : this.ctx.logChannel();
        this.logSubscription.addDestination(destination);
        this.consensusModuleAgent.liveLogDestination(destination);
    }

    private Subscription addFollowerSubscription() {
        Aeron aeron = this.ctx.aeron();
        ChannelUri logChannelUri = ChannelUri.parse(this.ctx.logChannel());
        String channel = new ChannelUriStringBuilder().media("udp").tags(aeron.nextCorrelationId() + "," + aeron.nextCorrelationId()).controlMode("manual").sessionId(this.logSessionId).group(Boolean.TRUE).rejoin(Boolean.FALSE).socketRcvbufLength(logChannelUri).receiverWindowLength(logChannelUri).alias("log-cm").build();
        return aeron.addSubscription(channel, this.ctx.logStreamId());
    }

    private void state(ElectionState newState, long nowNs, String reason) {
        if (newState != this.state) {
            if (ElectionState.CANVASS == this.state) {
                this.isExtendedCanvass = false;
            }
            switch (newState) {
                case CANVASS: {
                    this.resetMembers();
                    this.consensusModuleAgent.role(Cluster.Role.FOLLOWER);
                    break;
                }
                case CANDIDATE_BALLOT: {
                    this.consensusModuleAgent.role(Cluster.Role.CANDIDATE);
                    break;
                }
                case LEADER_LOG_REPLICATION: {
                    this.consensusModuleAgent.role(Cluster.Role.LEADER);
                    this.logSessionId = this.consensusModuleAgent.addLogPublication(this.appendPosition);
                    break;
                }
                case FOLLOWER_LOG_REPLICATION: 
                case FOLLOWER_REPLAY: {
                    this.consensusModuleAgent.role(Cluster.Role.FOLLOWER);
                    break;
                }
            }
            this.logStateChange(this.thisMember.id(), this.state, newState, null != this.leaderMember ? this.leaderMember.id() : -1, this.candidateTermId, this.leadershipTermId, this.logPosition, this.logLeadershipTermId, this.appendPosition, this.catchupJoinPosition, reason);
            this.state = newState;
            this.ctx.electionStateCounter().setOrdered(newState.code());
            this.timeOfLastStateChangeNs = nowNs;
            this.timeOfLastUpdateNs = this.initialTimeOfLastUpdateNs;
            this.timeOfLastCommitPositionUpdateNs = this.initialTimeOfLastUpdateNs;
        }
    }

    private void stopCatchup() {
        this.consensusModuleAgent.stopAllCatchups();
        this.catchupJoinPosition = -1L;
        this.catchupCommitPosition = 0L;
    }

    private void resetMembers() {
        ClusterMember.reset(this.clusterMembers);
        this.thisMember.leadershipTermId(this.leadershipTermId).logPosition(this.appendPosition);
        this.leaderMember = null;
    }

    private void stopReplay() {
        if (null != this.logReplay) {
            this.logReplay.close();
            this.logReplay = null;
        }
    }

    private void stopLogReplication() {
        if (null != this.logReplication) {
            this.logReplication.close();
            this.logReplication = null;
        }
        this.replicationCommitPosition = 0L;
        this.replicationDeadlineNs = 0L;
        this.lastPublishedCommitPosition = 0L;
    }

    private boolean isPassiveMember() {
        return null == ClusterMember.findMember(this.clusterMembers, this.thisMember.id());
    }

    private void ensureRecordingLogCoherent(long leadershipTermId, long termBaseLogPosition, long logPosition, long nowNs) {
        Election.ensureRecordingLogCoherent(this.ctx, this.consensusModuleAgent.logRecordingId(), this.initialLogLeadershipTermId, this.initialTermBaseLogPosition, leadershipTermId, termBaseLogPosition, logPosition, nowNs);
    }

    static void ensureRecordingLogCoherent(ConsensusModule.Context ctx, long recordingId, long initialLogLeadershipTermId, long initialTermBaseLogPosition, long leadershipTermId, long termBaseLogPosition, long logPosition, long nowNs) {
        if (-1L == recordingId) {
            return;
        }
        long timestamp = ctx.clusterClock().timeUnit().convert(nowNs, TimeUnit.NANOSECONDS);
        RecordingLog recordingLog = ctx.recordingLog();
        recordingLog.ensureCoherent(recordingId, initialLogLeadershipTermId, initialTermBaseLogPosition, leadershipTermId, -1L != termBaseLogPosition ? termBaseLogPosition : initialTermBaseLogPosition, logPosition, nowNs, timestamp, ctx.fileSyncLevel());
    }

    private void updateRecordingLog(long nowNs) {
        this.ensureRecordingLogCoherent(this.leadershipTermId, this.logPosition, -1L, nowNs);
        this.logLeadershipTermId = this.leadershipTermId;
    }

    private void updateRecordingLogForReplication(long leadershipTermId, long termBaseLogPosition, long logPosition, long nowNs) {
        this.ensureRecordingLogCoherent(leadershipTermId, termBaseLogPosition, logPosition, nowNs);
        this.logLeadershipTermId = leadershipTermId;
    }

    private void verifyLogJoinPosition(String state, long joinPosition) {
        if (joinPosition != this.logPosition) {
            String inequality = joinPosition < this.logPosition ? " less " : " greater ";
            throw new ClusterEvent(state + " - joinPosition=" + joinPosition + inequality + "than logPosition=" + this.logPosition);
        }
    }

    private boolean hasUpdateIntervalExpired(long nowNs, long intervalNs) {
        return this.hasIntervalExpired(nowNs, this.timeOfLastUpdateNs, intervalNs);
    }

    private boolean hasIntervalExpired(long nowNs, long previousTimestampForIntervalNs, long intervalNs) {
        return nowNs - previousTimestampForIntervalNs >= intervalNs;
    }

    private void logStateChange(int memberId, ElectionState oldState, ElectionState newState, int leaderId, long candidateTermId, long leadershipTermId, long logPosition, long logLeadershipTermId, long appendPosition, long catchupPosition, String reason) {
    }

    private void prepareForNewLeadership(long nowNs) {
        long lastAppendPosition = this.consensusModuleAgent.prepareForNewLeadership(this.logPosition, nowNs);
        if (-1L != lastAppendPosition) {
            this.appendPosition = lastAppendPosition;
        }
    }

    public String toString() {
        return "Election{isNodeStartup=" + this.isNodeStartup + ", isLeaderStartup=" + this.isLeaderStartup + ", isExtendedCanvass=" + this.isExtendedCanvass + ", logSessionId=" + this.logSessionId + ", timeOfLastStateChangeNs=" + this.timeOfLastStateChangeNs + ", timeOfLastUpdateNs=" + this.timeOfLastUpdateNs + ", nominationDeadlineNs=" + this.nominationDeadlineNs + ", logPosition=" + this.logPosition + ", appendPosition=" + this.appendPosition + ", catchupJoinPosition=" + this.catchupJoinPosition + ", catchupCommitPosition=" + this.catchupCommitPosition + ", replicationStopPosition=" + this.replicationStopPosition + ", leaderRecordingId=" + this.leaderRecordingId + ", leadershipTermId=" + this.leadershipTermId + ", logLeadershipTermId=" + this.logLeadershipTermId + ", candidateTermId=" + this.candidateTermId + ", leaderMember=" + this.leaderMember + ", state=" + (Object)((Object)this.state) + ", logSubscription=" + this.logSubscription + ", logReplay=" + this.logReplay + ", clusterMembers=" + Arrays.toString(this.clusterMembers) + ", thisMember=" + this.thisMember + ", clusterMemberByIdMap=" + this.clusterMemberByIdMap + ", logReplication=" + this.logReplication + ", ctx=" + this.ctx + '}';
    }
}

