/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.CommonContext;
import io.aeron.cluster.ClusterControl;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.service.ClusterCounters;
import io.aeron.cluster.service.ClusteredServiceContainer;
import java.io.File;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;

public class NodeControl {
    public static final int CONTROL_TOGGLE_TYPE_ID = 233;

    public static AtomicCounter findControlToggle(CountersReader counters, int clusterId) {
        int counterId = ClusterCounters.find(counters, 233, clusterId);
        if (-1 != counterId) {
            return new AtomicCounter(counters.valuesBuffer(), counterId, null);
        }
        return null;
    }

    public static void main(String[] args) {
        NodeControl.checkUsage(args);
        ToggleState toggleState = ToggleState.valueOf(args[0].toUpperCase());
        File cncFile = CommonContext.newDefaultCncFile();
        System.out.println("Command `n Control file " + cncFile);
        CountersReader countersReader = ClusterControl.mapCounters(cncFile);
        int clusterId = ClusteredServiceContainer.Configuration.clusterId();
        AtomicCounter controlToggle = NodeControl.findControlToggle(countersReader, clusterId);
        if (null == controlToggle) {
            System.out.println("Failed to find control toggle");
            System.exit(0);
        }
        if (toggleState.toggle(controlToggle)) {
            System.out.println((Object)((Object)toggleState) + " toggled successfully");
        } else {
            System.out.println((Object)((Object)toggleState) + " did NOT toggle: current state=" + (Object)((Object)ToggleState.get(controlToggle)));
        }
    }

    private static void checkUsage(String[] args) {
        if (1 != args.length) {
            System.out.format("Usage: [-Daeron.dir=<directory containing CnC file> -Daeron.cluster.id=<id>] " + NodeControl.class.getName() + " <action>%n", new Object[0]);
            System.exit(0);
        }
    }

    public static enum ToggleState {
        INACTIVE(0),
        NEUTRAL(1),
        REPLICATE_STANDBY_SNAPSHOT(2);

        private final int code;
        private static final ToggleState[] STATES;

        private ToggleState(int code) {
            if (code != this.ordinal()) {
                throw new IllegalArgumentException(this.name() + " - code must equal ordinal value: code=" + code);
            }
            this.code = code;
        }

        public final int code() {
            return this.code;
        }

        public final boolean toggle(AtomicCounter controlToggle) {
            return controlToggle.compareAndSet(NEUTRAL.code(), this.code());
        }

        public static void reset(AtomicCounter controlToggle) {
            controlToggle.set(NEUTRAL.code());
        }

        public static void activate(AtomicCounter controlToggle) {
            controlToggle.set(NEUTRAL.code());
        }

        public static void deactivate(AtomicCounter controlToggle) {
            controlToggle.set(INACTIVE.code());
        }

        public static ToggleState get(AtomicCounter controlToggle) {
            if (controlToggle.isClosed()) {
                throw new ClusterException("counter is closed");
            }
            long toggleValue = controlToggle.get();
            if (toggleValue < 0L || toggleValue > (long)(STATES.length - 1)) {
                throw new ClusterException("invalid toggle value: " + toggleValue);
            }
            return STATES[(int)toggleValue];
        }

        static {
            STATES = ToggleState.values();
        }
    }
}

