/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.stress;

import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class CRC64 {
    private static final long POLY = -3932672073523589310L;
    private static final long[] TABLE = new long[256];
    private long value = 0L;

    long recalculate(byte[] b, int offset, int length) {
        this.value = 0L;
        this.update(b, offset, length);
        return this.value;
    }

    long recalculate(DirectBuffer b, int offset, int length) {
        this.value = 0L;
        this.update(b, offset, length);
        return this.value;
    }

    public void update(byte[] b, int offset, int len) {
        int idx = offset;
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
        for (int remaining = len; remaining > 0; --remaining) {
            this.value = TABLE[(int)(this.value ^ (long)b[idx]) & 0xFF] ^ this.value >>> 8;
            ++idx;
        }
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
    }

    public void update(DirectBuffer b, int offset, int len) {
        int idx = offset;
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
        for (int remaining = len; remaining > 0; --remaining) {
            this.value = TABLE[(int)(this.value ^ (long)b.getByte(idx)) & 0xFF] ^ this.value >>> 8;
            ++idx;
        }
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
    }

    private static void test(byte[] b, int len, long crcValue) throws Exception {
        CRC64 crc = new CRC64();
        long recalculate = crc.recalculate(new UnsafeBuffer(b), 0, len);
        if (recalculate != crcValue) {
            throw new Exception("mismatch: " + String.format("%016x", recalculate) + " should be " + String.format("%016x", crcValue));
        }
    }

    public static void main(String[] args) throws Exception {
        byte[] test1 = "123456789".getBytes();
        int testlen1 = 9;
        long testcrc1 = -7395533204333446662L;
        CRC64.test(test1, 9, -7395533204333446662L);
        byte[] test2 = "This is a test of the emergency broadcast system.".getBytes();
        int testlen2 = 49;
        long testcrc2 = 2871916124362751090L;
        CRC64.test(test2, 49, 2871916124362751090L);
        byte[] test3 = "IHATEMATH".getBytes();
        int testlen3 = 9;
        long testcrc3 = 4116537408385638600L;
        CRC64.test(test3, 9, 4116537408385638600L);
    }

    static {
        for (int n = 0; n < 256; ++n) {
            long crc = n;
            for (int k = 0; k < 8; ++k) {
                if ((crc & 1L) == 1L) {
                    crc = crc >>> 1 ^ 0xC96C5795D7870F42L;
                    continue;
                }
                crc >>>= 1;
            }
            CRC64.TABLE[n] = crc;
        }
    }
}

