/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.status;

import org.agrona.BitUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.CountersReader;

public class HeartbeatTimestamp {
    public static final int HEARTBEAT_TYPE_ID = 11;
    public static final int REGISTRATION_ID_OFFSET = 0;

    public static AtomicCounter allocate(MutableDirectBuffer tempBuffer, String name, int typeId, CountersManager countersManager, long registrationId) {
        return new AtomicCounter(countersManager.valuesBuffer(), HeartbeatTimestamp.allocateCounterId(tempBuffer, name, typeId, countersManager, registrationId), countersManager);
    }

    public static int allocateCounterId(MutableDirectBuffer tempBuffer, String name, int typeId, CountersManager countersManager, long registrationId) {
        tempBuffer.putLong(0, registrationId);
        int keyLength = 8;
        int labelOffset = BitUtil.align(8, 4);
        int labelLength = 0;
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, name);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, ": id=");
        labelLength += tempBuffer.putLongAscii(labelOffset + labelLength, registrationId);
        return countersManager.allocate(typeId, tempBuffer, 0, 8, tempBuffer, labelOffset, labelLength);
    }

    public static int findCounterIdByRegistrationId(CountersReader countersReader, int counterTypeId, long registrationId) {
        AtomicBuffer buffer = countersReader.metaDataBuffer();
        int size = countersReader.maxCounterId();
        for (int i = 0; i < size; ++i) {
            int counterState = countersReader.getCounterState(i);
            if (counterState == 1) {
                if (countersReader.getCounterTypeId(i) != counterTypeId || buffer.getLong(CountersReader.metaDataOffset(i) + 16 + 0) != registrationId) continue;
                return i;
            }
            if (0 == counterState) break;
        }
        return -1;
    }

    public static boolean isActive(CountersReader countersReader, int counterId, int counterTypeId, long registrationId) {
        AtomicBuffer buffer = countersReader.metaDataBuffer();
        int recordOffset = CountersReader.metaDataOffset(counterId);
        return countersReader.getCounterTypeId(counterId) == counterTypeId && buffer.getLong(recordOffset + 16 + 0) == registrationId && countersReader.getCounterState(counterId) == 1;
    }
}

