/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.utility;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public abstract class Processor
extends AbstractProcessor {
    private boolean enabled = false;
    private boolean printNotes = false;
    private Diagnostic.Kind errorKind;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.enabled = System.getProperty(this.getEnabledPropertyName(), "true").equalsIgnoreCase("true");
        this.printNotes = System.getProperty(this.getPrintNotesPropertyName(), "false").equalsIgnoreCase("true");
        this.errorKind = System.getProperty(this.getFailOnErrorPropertyName(), "false").equalsIgnoreCase("true") ? Diagnostic.Kind.ERROR : Diagnostic.Kind.NOTE;
        super.init(processingEnv);
    }

    protected abstract String getEnabledPropertyName();

    protected abstract String getPrintNotesPropertyName();

    protected abstract String getFailOnErrorPropertyName();

    protected abstract void doProcess(Set<? extends TypeElement> var1, RoundEnvironment var2);

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.enabled) {
            this.doProcess(annotations, roundEnv);
        }
        return false;
    }

    protected String getDocComment(Element element) {
        String description = this.processingEnv.getElementUtils().getDocComment(element);
        if (description == null) {
            this.error("no javadoc found", element);
            return "NO DESCRIPTION FOUND";
        }
        return description.trim();
    }

    protected void error(String errMsg) {
        this.error(errMsg, null);
    }

    protected void error(String errMsg, Element element) {
        this.printMessage(this.errorKind, errMsg, element);
    }

    protected void note(String msg) {
        this.note(msg, null);
    }

    protected void note(String msg, Element element) {
        if (this.printNotes) {
            this.printMessage(Diagnostic.Kind.NOTE, msg, element);
        }
    }

    private void printMessage(Diagnostic.Kind kind, String msg, Element element) {
        this.processingEnv.getMessager().printMessage(kind, msg, element);
    }
}

