/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.AvailableImageHandler;
import io.aeron.ChannelUri;
import io.aeron.ClientConductor;
import io.aeron.Image;
import io.aeron.SubscriptionFields;
import io.aeron.UnavailableImageHandler;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.BlockHandler;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.RawBlockHandler;
import io.aeron.status.LocalSocketAddressStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.agrona.collections.ArrayUtil;

public final class Subscription
extends SubscriptionFields
implements AutoCloseable {
    byte p064;
    byte p065;
    byte p066;
    byte p067;
    byte p068;
    byte p069;
    byte p070;
    byte p071;
    byte p072;
    byte p073;
    byte p074;
    byte p075;
    byte p076;
    byte p077;
    byte p078;
    byte p079;
    byte p080;
    byte p081;
    byte p082;
    byte p083;
    byte p084;
    byte p085;
    byte p086;
    byte p087;
    byte p088;
    byte p089;
    byte p090;
    byte p091;
    byte p092;
    byte p093;
    byte p094;
    byte p095;
    byte p096;
    byte p097;
    byte p098;
    byte p099;
    byte p100;
    byte p101;
    byte p102;
    byte p103;
    byte p104;
    byte p105;
    byte p106;
    byte p107;
    byte p108;
    byte p109;
    byte p110;
    byte p111;
    byte p112;
    byte p113;
    byte p114;
    byte p115;
    byte p116;
    byte p117;
    byte p118;
    byte p119;
    byte p120;
    byte p121;
    byte p122;
    byte p123;
    byte p124;
    byte p125;
    byte p126;
    byte p127;

    Subscription(ClientConductor conductor, String channel, int streamId, long registrationId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        super(registrationId, streamId, conductor, channel, availableImageHandler, unavailableImageHandler);
    }

    public String channel() {
        return this.channel;
    }

    public int streamId() {
        return this.streamId;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public AvailableImageHandler availableImageHandler() {
        return this.availableImageHandler;
    }

    public UnavailableImageHandler unavailableImageHandler() {
        return this.unavailableImageHandler;
    }

    public int poll(FragmentHandler fragmentHandler, int fragmentLimit) {
        int i;
        int startingIndex;
        Image[] images = this.images;
        int length = images.length;
        int fragmentsRead = 0;
        if ((startingIndex = this.roundRobinIndex++) >= length) {
            startingIndex = 0;
            this.roundRobinIndex = 0;
        }
        for (i = startingIndex; i < length && fragmentsRead < fragmentLimit; fragmentsRead += images[i].poll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        for (i = 0; i < startingIndex && fragmentsRead < fragmentLimit; fragmentsRead += images[i].poll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        return fragmentsRead;
    }

    public int controlledPoll(ControlledFragmentHandler fragmentHandler, int fragmentLimit) {
        int i;
        int startingIndex;
        Image[] images = this.images;
        int length = images.length;
        int fragmentsRead = 0;
        if ((startingIndex = this.roundRobinIndex++) >= length) {
            startingIndex = 0;
            this.roundRobinIndex = 0;
        }
        for (i = startingIndex; i < length && fragmentsRead < fragmentLimit; fragmentsRead += images[i].controlledPoll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        for (i = 0; i < startingIndex && fragmentsRead < fragmentLimit; fragmentsRead += images[i].controlledPoll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        return fragmentsRead;
    }

    public long blockPoll(BlockHandler blockHandler, int blockLengthLimit) {
        long bytesConsumed = 0L;
        for (Image image : this.images) {
            bytesConsumed += (long)image.blockPoll(blockHandler, blockLengthLimit);
        }
        return bytesConsumed;
    }

    public long rawPoll(RawBlockHandler rawBlockHandler, int blockLengthLimit) {
        long bytesConsumed = 0L;
        for (Image image : this.images) {
            bytesConsumed += (long)image.rawPoll(rawBlockHandler, blockLengthLimit);
        }
        return bytesConsumed;
    }

    public boolean isConnected() {
        for (Image image : this.images) {
            if (image.isClosed()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNoImages() {
        return this.images.length == 0;
    }

    public int imageCount() {
        return this.images.length;
    }

    public Image imageBySessionId(int sessionId) {
        Image result = null;
        for (Image image : this.images) {
            if (sessionId != image.sessionId()) continue;
            result = image;
            break;
        }
        return result;
    }

    public Image imageAtIndex(int index) {
        return this.images[index];
    }

    public List<Image> images() {
        return Collections.unmodifiableList(Arrays.asList(this.images));
    }

    public void forEachImage(Consumer<Image> consumer) {
        for (Image image : this.images) {
            consumer.accept(image);
        }
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.conductor.removeSubscription(this);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public long channelStatus() {
        if (this.isClosed) {
            return -1L;
        }
        return this.conductor.channelStatus(this.channelStatusId);
    }

    public int channelStatusId() {
        return this.channelStatusId;
    }

    public List<String> localSocketAddresses() {
        return LocalSocketAddressStatus.findAddresses(this.conductor.countersReader(), this.channelStatus(), this.channelStatusId);
    }

    public void addDestination(String endpointChannel) {
        if (this.isClosed) {
            throw new AeronException("Subscription is closed");
        }
        this.conductor.addRcvDestination(this.registrationId, endpointChannel);
    }

    public void removeDestination(String endpointChannel) {
        if (this.isClosed) {
            throw new AeronException("Subscription is closed");
        }
        this.conductor.removeRcvDestination(this.registrationId, endpointChannel);
    }

    public long asyncAddDestination(String endpointChannel) {
        if (this.isClosed) {
            throw new AeronException("Subscription is closed");
        }
        return this.conductor.asyncAddRcvDestination(this.registrationId, endpointChannel);
    }

    public long asyncRemoveDestination(String endpointChannel) {
        if (this.isClosed) {
            throw new AeronException("Subscription is closed");
        }
        return this.conductor.asyncRemoveRcvDestination(this.registrationId, endpointChannel);
    }

    public String tryResolveChannelEndpointPort() {
        long channelStatus = this.channelStatus();
        if (1L == channelStatus) {
            ChannelUri uri;
            String endpoint;
            List<String> localSocketAddresses = LocalSocketAddressStatus.findAddresses(this.conductor.countersReader(), channelStatus, this.channelStatusId);
            if (1 == localSocketAddresses.size() && null != (endpoint = (uri = ChannelUri.parse(this.channel)).get("endpoint")) && endpoint.endsWith(":0")) {
                uri.replaceEndpointWildcardPort(localSocketAddresses.get(0));
                return uri.toString();
            }
            return this.channel;
        }
        return null;
    }

    public String resolvedEndpoint() {
        return LocalSocketAddressStatus.findAddress(this.conductor.countersReader(), this.channelStatus(), this.channelStatusId);
    }

    void channelStatusId(int id) {
        this.channelStatusId = id;
    }

    void internalClose(long lingerDurationNs) {
        Image[] images = this.images;
        this.images = EMPTY_IMAGES;
        this.isClosed = true;
        this.conductor.closeImages(images, this.unavailableImageHandler, lingerDurationNs);
    }

    void addImage(Image image) {
        this.images = ArrayUtil.add(this.images, image);
    }

    Image removeImage(long correlationId) {
        Image[] oldArray = this.images;
        Image removedImage = null;
        int i = 0;
        for (Image image : oldArray) {
            if (image.correlationId() == correlationId) {
                removedImage = image;
                break;
            }
            ++i;
        }
        if (null != removedImage) {
            removedImage.close();
            this.images = oldArray.length == 1 ? EMPTY_IMAGES : ArrayUtil.remove(oldArray, i);
            this.conductor.releaseLogBuffers(removedImage.logBuffers(), correlationId, -1L);
        }
        return removedImage;
    }

    public String toString() {
        return "Subscription{registrationId=" + this.registrationId + ", isClosed=" + this.isClosed + ", streamId=" + this.streamId + ", channel='" + this.channel + "', localSocketAddresses=" + this.localSocketAddresses() + ", imageCount=" + this.imageCount() + "}";
    }
}

