/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.checksum;

import io.aeron.archive.checksum.Checksum;
import io.aeron.archive.checksum.Crc32;
import io.aeron.archive.checksum.Crc32c;
import java.util.Objects;

public final class Checksums {
    public static Checksum crc32() {
        return Crc32.INSTANCE;
    }

    public static Checksum crc32c() {
        return Crc32c.INSTANCE;
    }

    public static Checksum newInstance(String className) {
        Objects.requireNonNull(className, "className is required!");
        if (Crc32.class.getName().equals(className)) {
            return Checksums.crc32();
        }
        if (Crc32c.class.getName().equals(className)) {
            return Checksums.crc32c();
        }
        try {
            Class<?> klass = Class.forName(className);
            Object instance = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return (Checksum)instance;
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalArgumentException("failed to create Checksum instance for class: " + className, ex);
        }
    }
}

