/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.checksum;

import io.aeron.archive.checksum.Checksum;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.zip.CRC32C;
import org.agrona.LangUtil;

final class Crc32c
implements Checksum {
    public static final Crc32c INSTANCE;
    private static final MethodHandle UPDATE_DIRECT_BYTE_BUFFER;

    private static int bitwiseComplement(int value) {
        return ~value;
    }

    private Crc32c() {
    }

    @Override
    public int compute(long address, int offset, int length) {
        try {
            return UPDATE_DIRECT_BYTE_BUFFER.invokeExact(address, offset, offset + length);
        }
        catch (Throwable t) {
            LangUtil.rethrowUnchecked(t);
            return -1;
        }
    }

    static {
        MethodHandle methodHandle;
        INSTANCE = new Crc32c();
        try {
            Method method = CRC32C.class.getDeclaredMethod("updateDirectByteBuffer", Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            methodHandle = lookup.unreflect(method);
            MethodHandle bitwiseComplement = lookup.findStatic(Crc32c.class, "bitwiseComplement", MethodType.methodType(Integer.TYPE, Integer.TYPE));
            methodHandle = MethodHandles.insertArguments(methodHandle, 0, -1);
            methodHandle = MethodHandles.filterReturnValue(methodHandle, bitwiseComplement);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
        UPDATE_DIRECT_BYTE_BUFFER = methodHandle;
    }
}

