/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.FragmentAssembler;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.client.ControlResponseListener;
import io.aeron.archive.client.RecordingDescriptorConsumer;
import io.aeron.archive.client.RecordingSignalConsumer;
import io.aeron.archive.codecs.ControlResponseDecoder;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.RecordingDescriptorDecoder;
import io.aeron.archive.codecs.RecordingSignalEventDecoder;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

public final class ControlResponseAdapter {
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ControlResponseDecoder controlResponseDecoder = new ControlResponseDecoder();
    private final RecordingDescriptorDecoder recordingDescriptorDecoder = new RecordingDescriptorDecoder();
    private final RecordingSignalEventDecoder recordingSignalEventDecoder = new RecordingSignalEventDecoder();
    private final int fragmentLimit;
    private final ControlResponseListener controlResponseListener;
    private final RecordingSignalConsumer recordingSignalConsumer;
    private final Subscription subscription;
    private final FragmentAssembler fragmentAssembler = new FragmentAssembler(this::onFragment);

    public ControlResponseAdapter(ControlResponseListener controlResponseListener, Subscription subscription, int fragmentLimit) {
        this(controlResponseListener, AeronArchive.Configuration.NO_OP_RECORDING_SIGNAL_CONSUMER, subscription, fragmentLimit);
    }

    public ControlResponseAdapter(ControlResponseListener controlResponseListener, RecordingSignalConsumer recordingSignalConsumer, Subscription subscription, int fragmentLimit) {
        this.fragmentLimit = fragmentLimit;
        this.controlResponseListener = controlResponseListener;
        this.recordingSignalConsumer = recordingSignalConsumer;
        this.subscription = subscription;
    }

    public int poll() {
        return this.subscription.poll(this.fragmentAssembler, this.fragmentLimit);
    }

    public static void dispatchDescriptor(RecordingDescriptorDecoder decoder, RecordingDescriptorConsumer consumer) {
        consumer.onRecordingDescriptor(decoder.controlSessionId(), decoder.correlationId(), decoder.recordingId(), decoder.startTimestamp(), decoder.stopTimestamp(), decoder.startPosition(), decoder.stopPosition(), decoder.initialTermId(), decoder.segmentFileLength(), decoder.termBufferLength(), decoder.mtuLength(), decoder.sessionId(), decoder.streamId(), decoder.strippedChannel(), decoder.originalChannel(), decoder.sourceIdentity());
    }

    void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 101) {
            throw new ArchiveException("expected schemaId=101, actual=" + schemaId);
        }
        switch (this.messageHeaderDecoder.templateId()) {
            case 1: {
                this.handleControlResponse(this.controlResponseListener, buffer, offset);
                break;
            }
            case 22: {
                this.handleRecordingDescriptor(this.controlResponseListener, buffer, offset);
                break;
            }
            case 24: {
                this.handleRecordingSignal(this.recordingSignalConsumer, buffer, offset);
            }
        }
    }

    private void handleControlResponse(ControlResponseListener listener, DirectBuffer buffer, int offset) {
        this.controlResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
        listener.onResponse(this.controlResponseDecoder.controlSessionId(), this.controlResponseDecoder.correlationId(), this.controlResponseDecoder.relevantId(), this.controlResponseDecoder.code(), this.controlResponseDecoder.errorMessage());
    }

    private void handleRecordingDescriptor(ControlResponseListener listener, DirectBuffer buffer, int offset) {
        this.recordingDescriptorDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
        ControlResponseAdapter.dispatchDescriptor(this.recordingDescriptorDecoder, listener);
    }

    private void handleRecordingSignal(RecordingSignalConsumer recordingSignalConsumer, DirectBuffer buffer, int offset) {
        this.recordingSignalEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
        recordingSignalConsumer.onSignal(this.recordingSignalEventDecoder.controlSessionId(), this.recordingSignalEventDecoder.correlationId(), this.recordingSignalEventDecoder.recordingId(), this.recordingSignalEventDecoder.subscriptionId(), this.recordingSignalEventDecoder.position(), this.recordingSignalEventDecoder.signal());
    }
}

