/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Aeron;
import io.aeron.AeronCounters;
import io.aeron.Counter;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersReader;

public final class ClusterCounters {
    private ClusterCounters() {
    }

    public static Counter allocate(Aeron aeron, MutableDirectBuffer tempBuffer, String name, int typeId, int clusterId) {
        int index = 0;
        tempBuffer.putInt(index, clusterId);
        int keyLength = index += 4;
        index += tempBuffer.putStringWithoutLengthAscii(index, name);
        index += tempBuffer.putStringWithoutLengthAscii(index, " - clusterId=");
        index += tempBuffer.putIntAscii(index, clusterId);
        return aeron.addCounter(typeId, tempBuffer, 0, keyLength, tempBuffer, keyLength, index - keyLength);
    }

    public static Counter allocateVersioned(Aeron aeron, MutableDirectBuffer tempBuffer, String name, int typeId, int clusterId, String version, String commitHashCode) {
        int index = 0;
        tempBuffer.putInt(index, clusterId);
        int keyLength = index += 4;
        index += tempBuffer.putStringWithoutLengthAscii(index, name);
        index += tempBuffer.putStringWithoutLengthAscii(index, " - clusterId=");
        index += tempBuffer.putIntAscii(index, clusterId);
        index += AeronCounters.appendVersionInfo(tempBuffer, index, version, commitHashCode);
        return aeron.addCounter(typeId, tempBuffer, 0, keyLength, tempBuffer, keyLength, index - keyLength);
    }

    public static int find(CountersReader counters, int typeId, int clusterId) {
        AtomicBuffer buffer = counters.metaDataBuffer();
        int size = counters.maxCounterId();
        for (int i = 0; i < size; ++i) {
            int counterState = counters.getCounterState(i);
            if (counterState == 1) {
                if (counters.getCounterTypeId(i) != typeId || buffer.getInt(CountersReader.metaDataOffset(i) + 16) != clusterId) continue;
                return i;
            }
            if (0 == counterState) break;
        }
        return -1;
    }

    public static Counter allocateServiceCounter(Aeron aeron, MutableDirectBuffer tempBuffer, String name, int typeId, int clusterId, int serviceId) {
        int index = 0;
        tempBuffer.putInt(index, clusterId);
        tempBuffer.putInt(index += 4, serviceId);
        int keyLength = index += 4;
        index += tempBuffer.putStringWithoutLengthAscii(index, name);
        index += tempBuffer.putStringWithoutLengthAscii(index, " - clusterId=");
        index += tempBuffer.putIntAscii(index, clusterId);
        index += tempBuffer.putStringWithoutLengthAscii(index, " serviceId=");
        index += tempBuffer.putIntAscii(index, serviceId);
        return aeron.addCounter(typeId, tempBuffer, 0, keyLength, tempBuffer, keyLength, index - keyLength);
    }

    static Counter allocateServiceErrorCounter(Aeron aeron, MutableDirectBuffer tempBuffer, int clusterId, int serviceId) {
        int index = 0;
        tempBuffer.putInt(index, clusterId);
        tempBuffer.putInt(index += 4, serviceId);
        int keyLength = index += 4;
        index += tempBuffer.putStringWithoutLengthAscii(index, "Cluster Container Errors");
        index += tempBuffer.putStringWithoutLengthAscii(index, " - clusterId=");
        index += tempBuffer.putIntAscii(index, clusterId);
        index += tempBuffer.putStringWithoutLengthAscii(index, " serviceId=");
        index += tempBuffer.putIntAscii(index, serviceId);
        index += AeronCounters.appendVersionInfo(tempBuffer, index, "1.46.7", "cd8de19f63");
        return aeron.addCounter(215, tempBuffer, 0, keyLength, tempBuffer, keyLength, index - keyLength);
    }
}

