/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.ChannelUri;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.media.Destination;
import io.aeron.driver.media.MultiSndDestinationRhsPadding;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.protocol.StatusMessageFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.status.AtomicCounter;

abstract class MultiSndDestination
extends MultiSndDestinationRhsPadding {
    static final Destination[] EMPTY_DESTINATIONS = new Destination[0];
    Destination[] destinations = EMPTY_DESTINATIONS;
    final CachedNanoClock nanoClock;
    final ErrorHandler errorHandler;
    AtomicCounter destinationsCounter = null;

    MultiSndDestination(CachedNanoClock nanoClock, ErrorHandler errorHandler) {
        this.nanoClock = nanoClock;
        this.errorHandler = errorHandler;
    }

    abstract int send(DatagramChannel var1, ByteBuffer var2, SendChannelEndpoint var3, int var4);

    abstract void onStatusMessage(StatusMessageFlyweight var1, InetSocketAddress var2);

    void addDestination(ChannelUri channelUri, InetSocketAddress address, long registrationId) {
    }

    void removeDestination(ChannelUri channelUri, InetSocketAddress address) {
    }

    void removeDestination(long destinationRegistrationId) {
    }

    void checkForReResolution(SendChannelEndpoint channelEndpoint, long nowNs, DriverConductorProxy conductorProxy) {
    }

    void updateDestination(String endpoint, InetSocketAddress newAddress) {
    }

    void destinationsCounter(AtomicCounter destinationsCounter) {
        this.destinationsCounter = destinationsCounter;
    }

    static int send(DatagramChannel datagramChannel, ByteBuffer buffer, SendChannelEndpoint channelEndpoint, int bytesToSend, int position, InetSocketAddress destination, ErrorHandler errorHandler) {
        int bytesSent = 0;
        try {
            if (destination.isUnresolved()) {
                bytesSent = bytesToSend;
            } else if (datagramChannel.isOpen()) {
                buffer.position(position);
                channelEndpoint.sendHook(buffer, destination);
                bytesSent = datagramChannel.send(buffer, destination);
            }
        }
        catch (PortUnreachableException portUnreachableException) {
        }
        catch (IOException ex) {
            UdpChannelTransport.onSendError(ex, destination, errorHandler);
        }
        return bytesSent;
    }
}

