/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.status;

import io.aeron.driver.DutyCycleTracker;
import java.util.Objects;
import org.agrona.concurrent.status.AtomicCounter;

public class DutyCycleStallTracker
extends DutyCycleTracker {
    private final AtomicCounter maxCycleTime;
    private final AtomicCounter cycleTimeThresholdExceededCount;
    private final long cycleTimeThresholdNs;

    public DutyCycleStallTracker(AtomicCounter maxCycleTime, AtomicCounter cycleTimeThresholdExceededCount, long cycleTimeThresholdNs) {
        this.maxCycleTime = Objects.requireNonNull(maxCycleTime);
        this.cycleTimeThresholdExceededCount = Objects.requireNonNull(cycleTimeThresholdExceededCount);
        this.cycleTimeThresholdNs = cycleTimeThresholdNs;
    }

    public AtomicCounter maxCycleTime() {
        return this.maxCycleTime;
    }

    public AtomicCounter cycleTimeThresholdExceededCount() {
        return this.cycleTimeThresholdExceededCount;
    }

    public long cycleTimeThresholdNs() {
        return this.cycleTimeThresholdNs;
    }

    @Override
    public void reportMeasurement(long durationNs) {
        if (!this.maxCycleTime.isClosed()) {
            this.maxCycleTime.proposeMaxOrdered(durationNs);
            if (durationNs > this.cycleTimeThresholdNs) {
                this.cycleTimeThresholdExceededCount.incrementOrdered();
            }
        }
    }

    @Override
    public String toString() {
        return "DutyCycleStallTracker{maxCycleTime=" + this.maxCycleTime + ", cycleTimeThresholdExceededCount=" + this.cycleTimeThresholdExceededCount + ", cycleTimeThresholdNs=" + this.cycleTimeThresholdNs + "}";
    }
}

