/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.cluster.tutorial;

import io.aeron.cluster.client.AeronCluster;
import io.aeron.cluster.client.EgressListener;
import io.aeron.cluster.codecs.EventCode;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import io.aeron.logbuffer.Header;
import io.aeron.samples.cluster.tutorial.BasicAuctionClusteredServiceNode;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;

public class BasicAuctionClusterClient
implements EgressListener {
    private final MutableDirectBuffer actionBidBuffer = new ExpandableArrayBuffer();
    private final IdleStrategy idleStrategy = new BackoffIdleStrategy();
    private final long customerId;
    private final int numOfBids;
    private final int bidIntervalMs;
    private long nextCorrelationId = 0L;
    private long lastBidSeen = 100L;

    public BasicAuctionClusterClient(long customerId, int numOfBids, int bidIntervalMs) {
        this.customerId = customerId;
        this.numOfBids = numOfBids;
        this.bidIntervalMs = bidIntervalMs;
    }

    @Override
    public void onMessage(long clusterSessionId, long timestamp, DirectBuffer buffer, int offset, int length, Header header) {
        long correlationId = buffer.getLong(offset + 0);
        long customerId = buffer.getLong(offset + 8);
        long currentPrice = buffer.getLong(offset + 16);
        boolean bidSucceed = 0 != buffer.getByte(offset + 24);
        this.lastBidSeen = currentPrice;
        this.printOutput("SessionMessage(" + clusterSessionId + ", " + correlationId + "," + customerId + ", " + currentPrice + ", " + bidSucceed + ")");
    }

    @Override
    public void onSessionEvent(long correlationId, long clusterSessionId, long leadershipTermId, int leaderMemberId, EventCode code, String detail) {
        this.printOutput("SessionEvent(" + correlationId + ", " + leadershipTermId + ", " + leaderMemberId + ", " + code + ", " + detail + ")");
    }

    @Override
    public void onNewLeader(long clusterSessionId, long leadershipTermId, int leaderMemberId, String ingressEndpoints) {
        this.printOutput("NewLeader(" + clusterSessionId + ", " + leadershipTermId + ", " + leaderMemberId + ")");
    }

    private void bidInAuction(AeronCluster aeronCluster) {
        long keepAliveDeadlineMs = 0L;
        long nextBidDeadlineMs = System.currentTimeMillis() + (long)ThreadLocalRandom.current().nextInt(1000);
        int bidsLeftToSend = this.numOfBids;
        while (!Thread.currentThread().isInterrupted()) {
            long currentTimeMs = System.currentTimeMillis();
            if (nextBidDeadlineMs <= currentTimeMs && bidsLeftToSend > 0) {
                long price = this.lastBidSeen + (long)ThreadLocalRandom.current().nextInt(10);
                long correlationId = this.sendBid(aeronCluster, price);
                nextBidDeadlineMs = currentTimeMs + (long)ThreadLocalRandom.current().nextInt(this.bidIntervalMs);
                keepAliveDeadlineMs = currentTimeMs + 1000L;
                this.printOutput("Sent(" + correlationId + ", " + this.customerId + ", " + price + ") bidsRemaining=" + --bidsLeftToSend);
            } else if (keepAliveDeadlineMs <= currentTimeMs) {
                if (bidsLeftToSend <= 0) break;
                aeronCluster.sendKeepAlive();
                keepAliveDeadlineMs = currentTimeMs + 1000L;
            }
            this.idleStrategy.idle(aeronCluster.pollEgress());
        }
    }

    private long sendBid(AeronCluster aeronCluster, long price) {
        long correlationId = this.nextCorrelationId++;
        this.actionBidBuffer.putLong(0, correlationId);
        this.actionBidBuffer.putLong(8, this.customerId);
        this.actionBidBuffer.putLong(16, price);
        this.idleStrategy.reset();
        while (aeronCluster.offer(this.actionBidBuffer, 0, 24) < 0L) {
            this.idleStrategy.idle(aeronCluster.pollEgress());
        }
        return correlationId;
    }

    public static String ingressEndpoints(List<String> hostnames) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hostnames.size(); ++i) {
            sb.append(i).append('=');
            sb.append(hostnames.get(i)).append(':').append(BasicAuctionClusteredServiceNode.calculatePort(i, 2));
            sb.append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private void printOutput(String message) {
        System.out.println(message);
    }

    public static void main(String[] args) {
        int customerId = Integer.parseInt(System.getProperty("aeron.cluster.tutorial.customerId"));
        int numOfBids = Integer.parseInt(System.getProperty("aeron.cluster.tutorial.numOfBids"));
        int bidIntervalMs = Integer.parseInt(System.getProperty("aeron.cluster.tutorial.bidIntervalMs"));
        String[] hostnames = System.getProperty("aeron.cluster.tutorial.hostnames", "localhost,localhost,localhost").split(",");
        String ingressEndpoints = BasicAuctionClusterClient.ingressEndpoints(Arrays.asList(hostnames));
        BasicAuctionClusterClient client = new BasicAuctionClusterClient(customerId, numOfBids, bidIntervalMs);
        try (MediaDriver mediaDriver = MediaDriver.launchEmbedded(new MediaDriver.Context().threadingMode(ThreadingMode.SHARED).dirDeleteOnStart(true).dirDeleteOnShutdown(true));
             AeronCluster aeronCluster = AeronCluster.connect(new AeronCluster.Context().egressListener(client).egressChannel("aeron:udp?endpoint=localhost:0").aeronDirectoryName(mediaDriver.aeronDirectoryName()).ingressChannel("aeron:udp").ingressEndpoints(ingressEndpoints));){
            client.bidInAuction(aeronCluster);
        }
    }
}

